/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FillPattern;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.etc.SolarExecutionTimeCalculator;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.SchedBlockConfiguratorInterface;
import alma.obsprep.services.generator.refactored.TPSchedBlockFullDiscSolarObservingConfigurator;
import alma.obsprep.services.generator.refactored.TPSchedBlockRegionalMappingSolarObservingConfigurator;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.SkyCoordinates;
import java.util.List;
import lombok.NonNull;

public class TPSolarSBConfigurator
implements SchedBlockConfiguratorInterface {
    @NonNull
    private final SchedBlock sb;
    @NonNull
    private final SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult;

    @Override
    public void configureSB() {
        if (!this.sb.isTP()) {
            throw new IllegalArgumentException("The SB should be a TP SB");
        }
        this.ensureTPSolarSBHasSingleSource();
        this.sb.getSchedBlockControl().setExecutionCount(this.solarExecutionTimeResult.n_tp_EB);
        this.configureTPSolarScienceTargets();
        if (this.sb.getSbGenerationContext().getGoal().getIsTPSolarRegionalMappingEnabled()) {
            new TPSchedBlockRegionalMappingSolarObservingConfigurator(this.sb, this.solarExecutionTimeResult).configureSB();
        } else {
            new TPSchedBlockFullDiscSolarObservingConfigurator(this.sb).configureSB();
        }
    }

    private void configureTPSolarScienceTargets() {
        List<Target> list = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        list.stream().forEach(target -> target.getScienceParametersCollection().stream().forEach(scienceParameters -> scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)this.solarExecutionTimeResult.t_tp.getMins(), (String)IntTimeSource.UNIT_MIN))));
        list.stream().forEach(target -> {
            FieldPattern fieldPattern = target.getFieldSource().getFieldPattern();
            if (!(fieldPattern instanceof FillPattern)) {
                throw new WizardSBGenerationException("Unexpected field pattern detected for TP solar SB : " + fieldPattern.getShortClassName());
            }
            FillPattern fillPattern = (FillPattern)((Object)((Object)fieldPattern));
            fillPattern.setPatternCenterCoordinates(SkyCoordinates.createOffsetCoordinates());
        });
    }

    private void ensureTPSolarSBHasSingleSource() {
        List<Target> list = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        list.stream().filter(target -> {
            for (ObservingGroup observingGroup : target.getObservingGroupList()) {
                if (!observingGroup.getMainTarget().equals(target)) continue;
                return false;
            }
            return true;
        }).forEach(target -> {
            this.sb.removeFieldSource(target.getFieldSource());
            this.sb.removeTarget((Target)target);
        });
    }

    public TPSolarSBConfigurator(@NonNull SchedBlock schedBlock, @NonNull SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (solarExecutionTimeResult == null) {
            throw new NullPointerException("solarExecutionTimeResult is marked non-null but is null");
        }
        this.sb = schedBlock;
        this.solarExecutionTimeResult = solarExecutionTimeResult;
    }
}

