/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.services.generator.refactored.SimultaneousACATMOUSStructureAssembler;
import alma.obsprep.services.generator.refactored.StandardOUSStructureAssembler;
import alma.obsprep.services.generator.refactored.StandardOUSStructureAssemblerInterface;
import lombok.NonNull;

public class StandardOUSStructureAssemblerFactory {
    public static StandardOUSStructureAssemblerInterface getStandardOUSStructureAssembler(@NonNull OUSStructureFormat oUSStructureFormat) {
        if (oUSStructureFormat == null) {
            throw new NullPointerException("ousStructureFormat is marked non-null but is null");
        }
        StandardOUSStructureAssemblerInterface standardOUSStructureAssemblerInterface = null;
        switch (oUSStructureFormat.ordinal()) {
            case 0: {
                standardOUSStructureAssemblerInterface = new SimultaneousACATMOUSStructureAssembler();
                break;
            }
            case 1: {
                standardOUSStructureAssemblerInterface = new StandardOUSStructureAssembler();
                break;
            }
            default: {
                throw new RuntimeException("Unable to recognise " + String.valueOf((Object)oUSStructureFormat));
            }
        }
        return standardOUSStructureAssemblerInterface;
    }

    public static enum OUSStructureFormat {
        SIMULTANEOUS_12M_ACA,
        STANDARD_FORMAT;

    }
}

