/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.RepresentativeFlagExpertInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class SpectralScanRepresentativeSPWFlagExpert
implements RepresentativeFlagExpertInterface {
    @Override
    public void setSPWRepresentativeFlag(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        double d = schedBlock.getSchedulingConstraints().getRepresentativeFrequency().getContentInGHz();
        ArrayList<AbstractSpectralWindow> arrayList = new ArrayList<AbstractSpectralWindow>(100);
        for (SpectralSpec spectralSpec : schedBlock.getSpectralSpec()) {
            for (BaseBand baseBand : spectralSpec.getBaseBand()) {
                Collections.addAll(arrayList, baseBand.getSingleSpectralWindow());
            }
        }
        this.setRepresentativeSPWFlag(d, arrayList);
    }

    protected void setRepresentativeSPWFlag(double d, List<AbstractSpectralWindow> list) {
        AbstractSpectralWindow abstractSpectralWindow = null;
        double d2 = -1.0;
        for (AbstractSpectralWindow abstractSpectralWindow2 : list) {
            abstractSpectralWindow2.setRepresentativeWindow(false);
            if (abstractSpectralWindow == null) {
                abstractSpectralWindow = abstractSpectralWindow2;
                d2 = Math.abs(abstractSpectralWindow.getCenterFrequency().getContentInGHz() - d);
                continue;
            }
            double d3 = abstractSpectralWindow2.getSideBandUse().equals((Object)SideBandUse.SIDEBANDUSE_USB) ? abstractSpectralWindow2.getSkyFrequencyUSB().getContentInGHz() : abstractSpectralWindow2.getSkyFrequencyLSB().getContentInGHz();
            double d4 = d3;
            double d5 = Math.abs(d4 - d);
            if (!(d5 < d2)) continue;
            d2 = d5;
            abstractSpectralWindow = abstractSpectralWindow2;
        }
        assert (abstractSpectralWindow != null);
        double d6 = abstractSpectralWindow.getSideBandUse().equals((Object)SideBandUse.SIDEBANDUSE_USB) ? abstractSpectralWindow.getSkyFrequencyUSB().getContentInGHz() : abstractSpectralWindow.getSkyFrequencyLSB().getContentInGHz();
        String string = abstractSpectralWindow.getBaseBandConfig().getBaseBandName();
        Log.logger(this.getClass()).fine("Baseband Name " + string + " spwRepWindowCentreGHZ: " + d6 + " SB RF(GHz) : " + d);
        abstractSpectralWindow.setRepresentativeWindow(true);
    }
}

