/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.annotations.TargetContext;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.CalibrationRequirements;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ObsUnitControl;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Preconditions;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproject.WeatherConstraints;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedBlockControl;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParameters;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SBExpertParameterExpert;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.ShadowingExpert;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Latitude;
import alma.valuetypes.Length;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jsky.coords.WorldCoords;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.lang3.StringUtils;

public class SchedBlockWorker {
    private static CacheAccess<Integer, ObsUnitSet> sbOutputCache = JCS.getInstance((String)"obsUnitSetCache");
    private static final String TM_MODE = "Standard Interferometry";
    static final String TP_MODE = "Standard Single Dish";
    private static final String TP_SOLAR_MODE = "Solar Single Dish";
    private static final String TM_SOLAR_MODE = "Solar Interferometry";
    private static final String VLBI_MODE = "Standard VLBI";
    private static final String POLARIZATION_MODE = "Polarization Interferometry";
    static String bandwidthSwitchingMode = "BandwidthSwitching Interferometry";
    private static String bandToBandMode = "BandToBand Interferometry";

    private SchedBlockWorker() {
    }

    public static void setupSchedBlock(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock, @NonNull RequestedArray requestedArray, @NonNull Double d, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws WizardSBGenerationException {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (d == null) {
            throw new NullPointerException("antennaRelatedTOSMultiplier is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        ObsUnitControl obsUnitControl = schedBlock.getObsUnitControl();
        SchedBlockExpert schedBlockExpert = SchedBlockExpert.getInstance(scienceGoal);
        try {
            SchedBlockWorker.setupObsUnitControl(obsUnitControl, requestedArray);
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
            throw new WizardSBGenerationException(exception.getMessage(), exception);
        }
        SchedBlockWorker.setupSBMode(schedBlock, requestedArray);
        SBExpertParameterExpert.setupExpertParameters(scienceGoal, schedBlock);
        SchedBlockWorker.setupSchedulingConstraints(scienceGoal, schedBlock.getSchedulingConstraints(), schedBlock);
        schedBlock.setName(schedBlock.generateName(scienceGoal));
        SchedBlockWorker.setupPreconditions(scienceGoal, schedBlock.getPreconditions());
        SchedBlockControl schedBlockControl = schedBlock.getSchedBlockControl();
        try {
            SchedBlockWorker.applyAntennaTOSMultiplier(schedBlock, d, requestedArray);
            SchedBlockWorker.setupSchedBlockControl(schedBlockExpert, schedBlockControl, requestedArray, enumSet);
            if (!RequestedArray.TP.equals((Object)requestedArray)) {
                SchedBlockWorker.quantizeScienceIntegrationTimes(schedBlock, enumSet);
                if (Log.logger(SchedBlockWorker.class).fine()) {
                    Time time = SchedBlockExpert.getTotalTOSForSB(schedBlock).getTime();
                    Log.logger(SchedBlockWorker.class).fine("Quantized time for " + schedBlock.getName() + " is " + String.valueOf(time));
                }
            }
        }
        catch (UnableToFindSolutionException | SourceNeverVisibleException | InvalidFrequencyException exception) {
            throw new WizardSBGenerationException(exception.getMessage(), exception);
        }
        obsUnitControl.setMaximumTime(schedBlockControl.calcMaxTime());
    }

    private static void applyAntennaTOSMultiplier(@NonNull SchedBlock schedBlock, @NonNull Double d, @NonNull RequestedArray requestedArray) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (d == null) {
            throw new NullPointerException("antennaRelatedTOSMultiplier is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (RequestedArray.TP.equals((Object)requestedArray) || d == 1.0) {
            return;
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                Target target = orderedTarget.getTarget();
                if (!target.hasScienceParameters()) continue;
                for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                    IntTimeSource intTimeSource2 = scienceParameters.getIntegrationTime();
                    scienceParameters.setIntegrationTime((IntTimeSource)((IntTimeSource)intTimeSource2.multiply(d)).multiply(ShadowingExpert.getShadowingFactor(schedBlock)));
                    scienceParameters.getTwoBitTotalTMITOSTime().ifPresent(intTimeSource -> scienceParameters.setTwoBitTotalTMITOSTime(Optional.of((IntTimeSource)((IntTimeSource)intTimeSource.multiply(d)).multiply(ShadowingExpert.getShadowingFactor(schedBlock)))));
                }
            }
        }
    }

    public static void quantizeScienceIntegrationTimes(@NonNull SchedBlock schedBlock, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws InvalidFrequencyException, SourceNeverVisibleException, UnableToFindSolutionException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
        int n = SchedBlockExpert.calcExecutionCount(SchedBlockExpert.getTotalTOSForSB(schedBlock).getTime(), enumSet);
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                if (hashSet.contains((Object)scienceParameters)) continue;
                IntTimeSource intTimeSource = scienceParameters.getIntegrationTime();
                scienceParameters.setIntegrationTime((IntTimeSource)intTimeSource.divide(n));
                hashSet.add(scienceParameters);
            }
        }
    }

    static double getMaxTimeOnSourcePerSBExec(@NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        double d = ((Time)SchedBlockExpert.NOMINAL_SB_LENGTH.divide(SchedBlockExpert.getNominalExecutionTimeToTOSRatio(enumSet))).getContentInUnits(Time.UNIT_S);
        assert (d > 0.0);
        return d;
    }

    private static void setupSBMode(@NonNull SchedBlock schedBlock, @NonNull RequestedArray requestedArray) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        String string = TM_MODE;
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        boolean bl = false;
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        try {
            bl = scienceGoal.getObsProposal().isVLBIorPhasedArray();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SchedBlockWorker.class).warning("Unable to determine if we are VLBI");
        }
        boolean bl2 = scienceGoal.getSpectralSetupParameters().isFullPolarisation();
        boolean bl3 = sBGenerationContext.isSolar();
        if (RequestedArray.TP.equals((Object)requestedArray)) {
            string = TP_MODE;
            if (bl3) {
                string = TP_SOLAR_MODE;
            }
        } else if (RequestedArray.TWELVE_M.equals((Object)requestedArray) && bl3) {
            string = TM_SOLAR_MODE;
        } else if (bl) {
            string = VLBI_MODE;
        } else if (bl2) {
            string = POLARIZATION_MODE;
        } else if (sBGenerationContext.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW)) {
            string = bandwidthSwitchingMode;
        } else if ((schedBlock.is12mExtendedArraySB() || schedBlock.is12mCompactArraySB() || schedBlock.isACA7mArraySB()) && sBGenerationContext.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_B2B)) {
            string = bandToBandMode;
        }
        schedBlock.setModeName(string);
        ObservingModeExpert.getInstance().updateSchedBlock(schedBlock, string);
    }

    private static void setupSchedulingConstraints(@NonNull ScienceGoal scienceGoal, @NonNull SchedulingConstraints schedulingConstraints, @NonNull SchedBlock schedBlock) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (schedulingConstraints == null) {
            throw new NullPointerException("schedblockConstraints is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Velocity velocity = schedBlock.getSchedulingConstraints().getRepresentativeTarget().getFieldSource().getSourceVelocityInReferenceFrame();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        Frequency frequency = spectralSetupParameters.gettrueRepresentativeFrequency();
        if (frequency == null || frequency.isZero()) {
            frequency = spectralSetupParameters.getSoleFrequency();
        }
        if (!(spectralSetupParameters.isSingleContinuumSkyFrequency() || spectralSetupParameters.isDerivedSSP() || spectralSetupParameters.isSpectralScan())) {
            frequency = frequency.dopplerShifted(velocity);
        }
        schedulingConstraints.setRepresentativeFrequency(frequency.deepCopy());
        schedulingConstraints.setDynamicRange(performanceParameters.getDesiredDynamicRange());
        HashSet<String> hashSet = new HashSet<String>();
        for (SpectralSpec spectralSpec : schedBlock.getSpectralSpec()) {
            hashSet.add(spectralSpec.getReceiverBand().getName());
        }
        schedulingConstraints.setRequiredReceiverBands(hashSet.toArray(new String[hashSet.size()]));
    }

    private static void setupPreconditions(@NonNull ScienceGoal scienceGoal, @NonNull Preconditions preconditions) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (preconditions == null) {
            throw new NullPointerException("preconditions is marked non-null but is null");
        }
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        Latitude latitude = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates().getLatitude();
        int n = WaterVaporColumns.wvindexSelector(frequency, latitude, Optional.ofNullable(scienceGoal.getSpectralSetupParameters().getReceiverBand()));
        String string = WaterVaporColumns.getWVIndexLabel(n);
        Pattern pattern = Pattern.compile("(\\d+\\.\\d+)[ ]*mm.*");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new WizardSBGenerationException("Programming error - unable to parse pmvc values: " + string);
        }
        WeatherConstraints weatherConstraints = preconditions.getWeatherConstraints();
        Length length = weatherConstraints.getMaxPWVC();
        length.setContent(Double.parseDouble(matcher.group(1)));
        length.setUnit(Length.UNIT_MM);
        String string2 = scienceGoal.getCalibrationSetupParameters().getPositionalAccuracy();
        if (StringUtils.equals((CharSequence)string2, (CharSequence)CalibrationSetupParameters.POSITIONALACCURACY_STANDARD)) {
            weatherConstraints.setPhaseStability(Angle.createAngle((double)1.0, (String)Angle.UNIT_RAD));
        } else if (StringUtils.equals((CharSequence)string2, (CharSequence)CalibrationSetupParameters.POSITIONALACCURACY_ENHANCED)) {
            weatherConstraints.setPhaseStability(Angle.createAngle((double)0.5, (String)Angle.UNIT_RAD));
        } else {
            throw new WizardSBGenerationException("Unknown positional accuracy defined: " + string2);
        }
        boolean bl = !scienceGoal.getSpectralSetupParameters().getPolarisation().equals("1");
        preconditions.setPolarizationCalValid(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupSchedBlockControl(@NonNull SchedBlockExpert schedBlockExpert, @NonNull SchedBlockControl schedBlockControl, @NonNull RequestedArray requestedArray, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws InvalidFrequencyException, SourceNeverVisibleException, UnableToFindSolutionException {
        if (schedBlockExpert == null) {
            throw new NullPointerException("sbExpert is marked non-null but is null");
        }
        if (schedBlockControl == null) {
            throw new NullPointerException("schedBlockControl is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        Time time = schedBlockExpert.getNominalSBLengthPolicy(requestedArray);
        time.convertToFriendlyUnit();
        SchedBlockControl schedBlockControl2 = schedBlockControl;
        synchronized (schedBlockControl2) {
            schedBlockControl.getSBMaximumTime().setContentAndUnit((ValueUnitPair)time);
            Time time2 = SchedBlockExpert.getTotalTOSForSB((SchedBlock)schedBlockControl.getParent()).getTime();
            if (RequestedArray.TWELVE_M.equals((Object)requestedArray)) {
                Integer n = SchedBlockExpert.calcExecutionCount(time2, enumSet);
                schedBlockControl.setExecutionCount(n);
            } else if (requestedArray.equals((Object)RequestedArray.ACA) || requestedArray.equals((Object)RequestedArray.SEVEN_M)) {
                Time time3 = (Time)SchedBlockExpert.NOMINAL_SB_LENGTH.divide(SchedBlockExpert.NOMINAL_TOTAL_TO_SCIENCE_ACA_7M_RATIO);
                schedBlockControl.setExecutionCount((int)Math.ceil(time2.getContentInUnits(Time.UNIT_S) / time3.getContentInUnits(Time.UNIT_S)));
            } else if (!requestedArray.equals((Object)RequestedArray.TP)) {
                throw new WizardSBGenerationException("Unknown array encountered " + String.valueOf((Object)requestedArray));
            }
        }
    }

    private static void setupObsUnitControl(@NonNull ObsUnitControl obsUnitControl, @NonNull RequestedArray requestedArray) throws InvalidFrequencyException, SourceNeverVisibleException {
        if (obsUnitControl == null) {
            throw new NullPointerException("control is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        CalibrationRequirements calibrationRequirements = obsUnitControl.getCalibrationRequirements();
        Angle angle = Angle.createAngle((double)1.0, (String)Angle.UNIT_ARCSEC);
        calibrationRequirements.setPointingAccuracy(angle);
        calibrationRequirements.setBandpassAccuracy(0.1);
        calibrationRequirements.setPolarizationAccuracy(0.1);
        obsUnitControl.setArrayRequested(requestedArray.getType());
    }

    public static void setMajorSBGenerationSchema(@NonNull Set<SBGeneratorTemplate.SBGenerationSchema> set, @NonNull SBGeneratorTemplate.SBGenerationSchema sBGenerationSchema) {
        if (set == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        if (sBGenerationSchema == null) {
            throw new NullPointerException("majorMode is marked non-null but is null");
        }
        set.removeAll(List.of(SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING, SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN, SBGeneratorTemplate.SBGenerationSchema.STANDARD));
        set.add(sBGenerationSchema);
    }

    public static void renameMultipleTuningObservingGroups(@NonNull SchedBlock schedBlock, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        String string;
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING) || enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                string = observingGroup.getName();
                if (string.startsWith(ObservingGroupManager.ObservingGroupType.CALIBRATOR.getGroupLabelPrefix())) {
                    observingGroup.setName("One time calibrators");
                }
                if (!string.startsWith(ObservingGroupManager.ObservingGroupType.SCIENCE.getGroupLabelPrefix())) continue;
                observingGroup.setName(string.replace(ObservingGroupManager.ObservingGroupType.SCIENCE.getGroupLabelPrefix(), "Tuning Group"));
            }
        }
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.STANDARD)) {
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                string = observingGroup.getName();
                if (string.startsWith(ObservingGroupManager.ObservingGroupType.CALIBRATOR.getGroupLabelPrefix())) {
                    observingGroup.setName("Calibrators");
                }
                if (!string.startsWith(ObservingGroupManager.ObservingGroupType.SCIENCE.getGroupLabelPrefix())) continue;
                observingGroup.setName("Science");
            }
        }
    }

    public static void appendTuningIndicatorToSpectralSpecs(@NonNull ObsUnitSet obsUnitSet) throws UnknownEntityException {
        if (obsUnitSet == null) {
            throw new NullPointerException("rootOUS is marked non-null but is null");
        }
        for (SchedBlock schedBlock : obsUnitSet.findSchedBlocks()) {
            int n = 0;
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                Iterator<Target> iterator = observingGroup.getAllOrderedTargets(Optional.of(Target::hasScienceParameters)).iterator();
                if (iterator.hasNext()) {
                    Target target = iterator.next();
                    target.getSpectralSpec().setName(target.getSpectralSpec().getName() + "_" + n);
                }
                ++n;
            }
        }
    }

    public static SchedBlock findSBUnderScienceGoal(@NonNull ScienceGoal scienceGoal, @NonNull SBGeneratorTemplate.SchedBlockType schedBlockType) throws SBNotFoundException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (schedBlockType == null) {
            throw new NullPointerException("schedBlockType is marked non-null but is null");
        }
        SchedBlock schedBlock = SchedBlockWorker.locateSB(scienceGoal.getObsUnitSet(), schedBlockType);
        if (schedBlock == null) {
            throw new SBNotFoundException();
        }
        return schedBlock;
    }

    private static SchedBlock locateSB(@NonNull ObsUnitSet obsUnitSet, @NonNull SBGeneratorTemplate.SchedBlockType schedBlockType) {
        Object object;
        if (obsUnitSet == null) {
            throw new NullPointerException("obsUnitSet is marked non-null but is null");
        }
        if (schedBlockType == null) {
            throw new NullPointerException("schedBlockType is marked non-null but is null");
        }
        try {
            for (SchedBlock obsUnitSetComponent : obsUnitSet.getSchedBlock()) {
                object = RequestedArray.valueOf(ControlBlockTArrayRequestedType.valueOf((String)obsUnitSetComponent.getObsUnitControl().getArrayRequested()));
                if (!object.equals((Object)schedBlockType.getArrayType())) continue;
                if (object.equals((Object)RequestedArray.TP)) {
                    if (schedBlockType.equals((Object)SBGeneratorTemplate.SchedBlockType.TPAMPCAL) && obsUnitSetComponent.isTotalPowerAmpcalSB()) {
                        return obsUnitSetComponent;
                    }
                    if (!schedBlockType.equals((Object)SBGeneratorTemplate.SchedBlockType.TPSCIENCE) || !obsUnitSetComponent.isTotalPowerScienceSB()) continue;
                    return obsUnitSetComponent;
                }
                if (object.equals((Object)RequestedArray.TWELVE_M)) {
                    if (!schedBlockType.equals((Object)obsUnitSetComponent.getSbGenerationContext().getSBType())) continue;
                    return obsUnitSetComponent;
                }
                return obsUnitSetComponent;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            return null;
        }
        for (ObsUnitSetComponent obsUnitSetComponent : obsUnitSet.getObsUnitSet()) {
            object = SchedBlockWorker.locateSB((ObsUnitSet)obsUnitSetComponent, schedBlockType);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void quantizeIntegrationTimesOnSourceBySubscanDuration(@NonNull SchedBlock schedBlock, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws UnableToQuantizeIntegrationTimeException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        if (schedBlock.isTotalPowerScienceSB()) {
            return;
        }
        SchedBlock schedBlock2 = schedBlock;
        synchronized (schedBlock2) {
            void var10_33;
            Time time;
            Object object;
            Object object2;
            for (Target target : schedBlock.getTarget()) {
                PointingPattern pointingPattern;
                if (!target.hasScienceParameters() || !target.getFieldSource().getFieldPattern().isPointingPattern() || !(pointingPattern = (PointingPattern)((Object)target.getFieldSource().getFieldPattern())).isDerivedFromRectanglePointingPattern()) continue;
                return;
            }
            HashMap hashMap = new HashMap();
            int n = schedBlock.getSchedBlockControl().getExecutionCount();
            if (n == 0 || n > 5000) {
                Log.logger(SchedBlockWorker.class).info("SB execution count exceeds limits: not running algorithm");
                return;
            }
            if (Log.logger(SchedBlockWorker.class).fine()) {
                for (Target target : schedBlock.getTarget()) {
                    void var10_27;
                    if (!target.hasScienceParameters()) continue;
                    Object object4 = target.getScienceParametersList()[0];
                    if (hashMap.get(object4) == null) {
                        IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource();
                        hashMap.put(object4, intTimeSource);
                    } else {
                        IntTimeSource intTimeSource = (IntTimeSource)((Object)hashMap.get(object4));
                    }
                    IntTimeSource object32 = (IntTimeSource)var10_27.plus((AbstractDoubleWithUnit)((IntTimeSource)object4.getIntegrationTime().multiply(n)));
                    hashMap.put(object4, object32);
                }
                for (IntTimeSource intTimeSource : hashMap.values()) {
                    Log.logger(SchedBlockWorker.class).fine("Unquantized total integration time :" + String.valueOf((Object)intTimeSource));
                }
            }
            HashMap<ScienceParameters, Time> hashMap2 = new HashMap<ScienceParameters, Time>();
            for (Object object4 : schedBlock.getTarget()) {
                if (!object4.hasScienceParameters()) continue;
                ScienceParameters scienceParameters = object4.getScienceParametersList()[0];
                hashMap2.put(scienceParameters, scienceParameters.getSubScanDuration().deepCopy());
            }
            int n2 = 0;
            Time time2 = Time.createTimeSec(0.0);
            block7: while (!SchedBlockWorker.verifyIntegrationTimesCanBeQuantizedWithExistingSubscanDurations(schedBlock, enumSet)) {
                HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
                for (Target target : schedBlock.getScienceTargets()) {
                    ScienceParameters scienceParameters = target.getScienceParametersList()[0];
                    if (hashSet.contains((Object)scienceParameters)) continue;
                    object2 = target.getSpectralSpec().getAbstractCorrelatorConfiguration().getIntegrationDuration();
                    object = scienceParameters.getSubScanDuration();
                    time = (Time)scienceParameters.getSubScanDuration().minus((AbstractDoubleWithUnit)object2);
                    while (time.isGreaterThan((AbstractDoubleWithUnit)time2) && SchedBlockWorker.getAlignedSubscanDuration(time, target).isEqual((AbstractDoubleWithUnit)object)) {
                        time = (Time)time.minus((AbstractDoubleWithUnit)object2);
                    }
                    if (time.isGreaterThan((AbstractDoubleWithUnit)time2)) {
                        scienceParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(time, target));
                        hashSet.add(scienceParameters);
                        continue;
                    }
                    for (Target target2 : schedBlock.getTarget()) {
                        if (!target2.hasScienceParameters()) continue;
                        ScienceParameters scienceParameters2 = target2.getScienceParametersList()[0];
                        assert (hashMap2.get((Object)scienceParameters2) != null);
                        scienceParameters2.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration((Time)hashMap2.get((Object)scienceParameters2), target));
                    }
                    SchedBlockWorker.increaseNumberOfSBExecs(schedBlock);
                    if (++n2 <= 100) continue block7;
                    Log.logger(SchedBlockWorker.class).warning("Unable to quantize science integration time by subscan duration");
                    throw new UnableToQuantizeIntegrationTimeException();
                }
            }
            Object object3 = schedBlock.getObservingParameters();
            int n3 = ((ObservingParameters[])object3).length;
            boolean bl = false;
            while (var10_33 < n3) {
                ObservingParameters observingParameters = object3[var10_33];
                if (observingParameters instanceof ScienceParameters) {
                    object2 = (ScienceParameters)((Object)observingParameters);
                    object = object2.getIntegrationTime().getTime().deepCopy();
                    time = object2.getIntegrationTime().getTime().deepCopy();
                    double d = object.getContentInUnits(Time.UNIT_S);
                    double d2 = object2.getSubScanDuration().getContentInUnits(Time.UNIT_S);
                    double d3 = Math.ceil(d / d2);
                    object = Time.createTimeSec(d3 * d2 - 0.1);
                    object2.setIntegrationTime(IntTimeSource.createIntTimeSource((double)object.getContentInUnits(Time.UNIT_S), (String)IntTimeSource.UNIT_S));
                    Log.logger(SchedBlockWorker.class).fine("Quantized integration time for science parameters is " + String.valueOf(object) + " was " + String.valueOf(time));
                }
                ++var10_33;
            }
            hashMap.clear();
            if (Log.logger(SchedBlockWorker.class).fine()) {
                void var10_35;
                object3 = schedBlock.getTarget();
                n3 = ((TargetContext[])object3).length;
                boolean bl2 = false;
                while (var10_35 < n3) {
                    TargetContext targetContext = object3[var10_35];
                    if (((Target)targetContext).hasScienceParameters()) {
                        object2 = ((Target)targetContext).getScienceParametersList()[0];
                        if (hashMap.get(object2) == null) {
                            object = IntTimeSource.createIntTimeSource();
                            hashMap.put(object2, object);
                        } else {
                            object = (IntTimeSource)((Object)hashMap.get(object2));
                        }
                        object = (IntTimeSource)object.plus((AbstractDoubleWithUnit)((IntTimeSource)object2.getIntegrationTime().multiply(n)));
                        hashMap.put(object2, object);
                    }
                    ++var10_35;
                }
                for (IntTimeSource intTimeSource : hashMap.values()) {
                    Log.logger(SchedBlockWorker.class).fine("Quantized total integration time " + String.valueOf((Object)intTimeSource));
                }
            }
        }
    }

    private static void increaseNumberOfSBExecs(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
        int n = schedBlock.getSchedBlockControl().getExecutionCount();
        Log.logger(SchedBlock.class).fine("Incrementing the number of SB executions from " + n + " to " + (n + 1));
        schedBlock.getSchedBlockControl().setExecutionCount(n + 1);
        for (Target target : schedBlock.getTarget()) {
            ScienceParameters scienceParameters;
            if (!target.hasScienceParameters() || hashSet.contains((Object)(scienceParameters = target.getScienceParametersList()[0]))) continue;
            double d = (double)n / ((double)n + 1.0);
            IntTimeSource intTimeSource = (IntTimeSource)scienceParameters.getIntegrationTime().multiply(d);
            Log.logger(SchedBlock.class).fine("Changing int time from " + String.valueOf((Object)scienceParameters.getIntegrationTime()) + " to " + String.valueOf((Object)intTimeSource));
            assert (!intTimeSource.isZero());
            scienceParameters.setIntegrationTime(intTimeSource);
            hashSet.add(scienceParameters);
        }
    }

    private static boolean verifyIntegrationTimesCanBeQuantizedWithExistingSubscanDurations(@NonNull SchedBlock schedBlock, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        Time time = Time.createTime();
        for (Target target : schedBlock.getTarget()) {
            if (!target.hasScienceParameters()) continue;
            ScienceParameters scienceParameters = target.getScienceParametersList()[0];
            double d = scienceParameters.getIntegrationTime().getContentInUnits(IntTimeSource.UNIT_S);
            double d2 = scienceParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S);
            double d3 = d2 * Math.ceil(d / d2);
            time.aggregate(Time.createTimeSec(d3));
        }
        assert (time.getContent() > 0.0);
        double d = SchedBlockWorker.getMaxTimeOnSourcePerSBExec(enumSet);
        return time.getContentInUnits(Time.UNIT_S) < d;
    }

    public static Time getAlignedSubscanDuration(@NonNull Time time, @NonNull Target target) {
        if (time == null) {
            throw new NullPointerException("subscanDuration is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (time.isLessThanOrEqualTo((AbstractDoubleWithUnit)Time.createTimeSec(0.0))) {
            throw new IllegalArgumentException("Subscan duration should be greater than zero");
        }
        SpectralSpec spectralSpec = (SpectralSpec)((Object)target.getAbstractInstrumentSpec());
        assert (spectralSpec != null);
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration == null) {
            return time;
        }
        CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
        double d = time.getContentInUnits(Time.UNIT_S);
        assert (d >= 0.0);
        double d2 = abstractCorrelatorConfiguration.getIntegrationDuration().getContentInUnits(Time.UNIT_S);
        assert (d2 >= 0.0);
        double d3 = correlatorExpert.calcSubscanDuration(d, d2, null);
        assert (d3 >= 0.0);
        return Time.createTimeSec(d3);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMosaicPointingsOverlapping(@NonNull TargetParameters targetParameters) throws InfiniteBandwithException, NotAMosaicException {
        Object object;
        boolean bl;
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (targetParameters.getFieldSinglePointCount() > 1 && !targetParameters.isMosaic()) {
            throw new NotAMosaicException();
        }
        if (targetParameters.getFieldSinglePointCount() == 1) {
            return true;
        }
        SpatialVisualParameters spatialVisualParameters = targetParameters.getSpatialVisualParameters();
        ScienceGoal scienceGoal = targetParameters.getScienceGoal();
        ScienceGoal scienceGoal2 = scienceGoal;
        if (scienceGoal2 == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: spatial");
        }
        spatialVisualParameters.setContextDocument(scienceGoal2);
        Frequency frequency = spatialVisualParameters.getFrequency();
        Antenna antenna = scienceGoal.isStandAloneACA() ? Antenna.ANTENNA_7M : Antenna.ANTENNA_12M;
        Double d = antenna.getBeamSize(frequency).getArcmin();
        if (d.isInfinite()) {
            throw new InfiniteBandwithException();
        }
        if (Log.logger(SchedBlockWorker.class).fine()) {
            Log.logger(SchedBlockWorker.class).fine("Dealing with a mosaic - Max mosaic spread is : " + d + " (arcmin) " + d * 60.0 + " (arcsec)");
            Log.logger(SchedBlockWorker.class).fine("Distance between pointings for  : " + targetParameters.getSourceName());
        }
        SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates().getJ2000SkyCoordinates();
        SinglePoint[] singlePointArray = targetParameters.getFieldSinglePoint();
        LinkedHashSet<Set<SinglePoint>> linkedHashSet = new LinkedHashSet<Set<SinglePoint>>(30);
        for (SinglePoint singlePoint : singlePointArray) {
            void var15_27;
            void var15_30;
            SkyPoint skyPoint = singlePoint.getCentre().getAbsoluteCoordinates(skyCoordinates).getAbsoluteSkyPointInICRSDeg();
            Object var15_28 = null;
            for (Set set : linkedHashSet) {
                if (!set.contains((Object)singlePoint)) continue;
                Set set2 = set;
                break;
            }
            if (var15_30 == null) {
                LinkedHashSet<SinglePoint> linkedHashSet2 = new LinkedHashSet<SinglePoint>(50);
                linkedHashSet2.add(singlePoint);
                linkedHashSet.add(linkedHashSet2);
            }
            assert (var15_27 != null);
            for (Object object2 : singlePointArray) {
                Object object3;
                double d2;
                if (object2 == singlePoint || !((d2 = WorldCoords.dist((double)(object3 = object2.getCentre().getAbsoluteCoordinates(skyCoordinates).getAbsoluteSkyPointInICRSDeg()).getX(), (double)object3.getY(), (double)skyPoint.getX(), (double)skyPoint.getY())) < d) || var15_27.contains(object2)) continue;
                var15_27.add(object2);
            }
        }
        assert (SchedBlockWorker.verifyAllPointingsAreInClusters(singlePointArray, linkedHashSet));
        Log.logger(SchedBlockWorker.class).fine("Number of pointing clusters found : " + linkedHashSet.size());
        if (linkedHashSet.size() == 1) {
            Log.logger(SchedBlockWorker.class).fine("Pointings in source " + targetParameters.getSourceName() + " overlap");
            return true;
        }
        for (Set set : linkedHashSet) {
            if (set.size() != singlePointArray.length) continue;
            Log.logger(SchedBlockWorker.class).fine("Pointings in source " + targetParameters.getSourceName() + " overlap - all pointings are in the same cluster");
            return true;
        }
        ArrayList arrayList = new ArrayList();
        do {
            bl = false;
            block5: for (Set set : linkedHashSet) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Set set3 = (Set)iterator.next();
                    if (set != set3) continue;
                    continue block5;
                }
                block7: for (Set set4 : linkedHashSet) {
                    if (set4 == set) continue;
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        Set set5 = (Set)object.next();
                        if (set4 != set5) continue;
                        continue block7;
                    }
                    for (SinglePoint singlePoint : set) {
                        SkyPoint skyPoint = singlePoint.getCentre().getAbsoluteCoordinates(skyCoordinates).getAbsoluteSkyPointInICRSDeg();
                        assert (skyPoint != null);
                        for (Object object3 : set4) {
                            SkyPoint skyPoint2 = object3.getCentre().getAbsoluteCoordinates(skyCoordinates).getAbsoluteSkyPointInICRSDeg();
                            assert (object3 != null);
                            double d3 = WorldCoords.dist((double)skyPoint2.getX(), (double)skyPoint2.getY(), (double)skyPoint.getX(), (double)skyPoint.getY());
                            assert (d3 >= 0.0);
                            if (!(d3 < d) && object3 != singlePoint) continue;
                            arrayList.add(set4);
                            set.addAll(set4);
                            bl = true;
                            continue block7;
                        }
                    }
                }
            }
        } while (bl);
        boolean bl2 = false;
        block11: for (Set set : linkedHashSet) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (Set)iterator.next();
                if (object != set) continue;
                continue block11;
            }
            if (Log.logger(SchedBlockWorker.class).fine()) {
                Log.logger(SchedBlockWorker.class).fine("clusterSize: " + set.size() + " looking for " + singlePointArray.length);
            }
            if (set.size() != singlePointArray.length) continue;
            bl2 = true;
            break;
        }
        if (Log.logger(SchedBlockWorker.class).fine()) {
            if (bl2) {
                Log.logger(SchedBlockWorker.class).fine("Pointings in source " + targetParameters.getSourceName() + " overlap");
            } else {
                Log.logger(SchedBlockWorker.class).fine("Pointings in source " + targetParameters.getSourceName() + " do not overlap");
            }
        }
        return bl2;
    }

    private static boolean verifyAllPointingsAreInClusters(@NonNull SinglePoint[] singlePointArray, @NonNull Set<Set<SinglePoint>> set) {
        if (singlePointArray == null) {
            throw new NullPointerException("pointingsInMosaic is marked non-null but is null");
        }
        if (set == null) {
            throw new NullPointerException("pointingCluster is marked non-null but is null");
        }
        LinkedHashSet<SinglePoint> linkedHashSet = new LinkedHashSet<SinglePoint>(40);
        for (Set<SinglePoint> set2 : set) {
            for (SinglePoint singlePoint : set2) {
                linkedHashSet.add(singlePoint);
            }
        }
        Log.logger(SchedBlockWorker.class).fine("pointingCluster.size(): " + set.size());
        return linkedHashSet.size() == singlePointArray.length;
    }

    public static List<SchedBlock> findSBsInSG(@NonNull AbstractScienceGoal abstractScienceGoal) {
        if (abstractScienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        ObsUnitSet obsUnitSet = abstractScienceGoal.getObsUnitSet();
        if (obsUnitSet == null) {
            return arrayList;
        }
        SchedBlockWorker.findSBsUnderOUS(arrayList, obsUnitSet);
        return arrayList;
    }

    public static List<SchedBlock> findSBsUnderOUS(@NonNull List<SchedBlock> list, ObsUnitSet obsUnitSet) {
        if (list == null) {
            throw new NullPointerException("schedblocks is marked non-null but is null");
        }
        if (obsUnitSet == null) {
            return list;
        }
        try {
            Arrays.stream(obsUnitSet.getSchedBlock()).forEach(list::add);
        }
        catch (UnknownEntityException unknownEntityException) {
            return list;
        }
        for (ObsUnitSet obsUnitSet2 : obsUnitSet.getObsUnitSet()) {
            SchedBlockWorker.findSBsUnderOUS(list, obsUnitSet2);
        }
        return list;
    }

    public static List<SchedBlock> findSBsUnderOUS(@NonNull List<SchedBlock> list, List<ObsUnitSet> list2) {
        if (list == null) {
            throw new NullPointerException("schedblocks is marked non-null but is null");
        }
        if (list2 == null || list2.isEmpty()) {
            return list;
        }
        list2.stream().forEach(obsUnitSet -> {
            try {
                Arrays.stream(obsUnitSet.getSchedBlock()).forEach(list::add);
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(SchedBlockWorker.class).warning("Unable to find SBs");
            }
        });
        list2.stream().forEach(obsUnitSet -> SchedBlockWorker.findSBsUnderOUS(list, obsUnitSet));
        return list;
    }

    public static ObsUnitSet generateSBs(@NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        Integer n = MiscUtils.getCacheHashcode(false, new BusinessObject[]{scienceGoal});
        ObsUnitSet obsUnitSet = (ObsUnitSet)sbOutputCache.get((Object)n);
        if (obsUnitSet != null) {
            Log.logger(SchedBlockWorker.class).fine("Using cached SBs");
            return obsUnitSet;
        }
        obsUnitSet = ObsUnitSet.createObsUnitSet();
        ScienceGoalSchedBlockGenerator scienceGoalSchedBlockGenerator = new ScienceGoalSchedBlockGenerator(scienceGoal, obsUnitSet, false);
        try {
            scienceGoalSchedBlockGenerator.generate();
        }
        catch (WizardSBGenerationException wizardSBGenerationException) {
            throw new InvalidObsProgramParametersException(wizardSBGenerationException);
        }
        sbOutputCache.put((Object)n, (Object)obsUnitSet);
        return obsUnitSet;
    }

    public static Map<String, SchedBlock> createTargetParametersSBMap(@NonNull Array array, @NonNull ObsUnitSet obsUnitSet) throws UnknownEntityException {
        if (array == null) {
            throw new NullPointerException("arrayToUse is marked non-null but is null");
        }
        if (obsUnitSet == null) {
            throw new NullPointerException("ous is marked non-null but is null");
        }
        HashMap<String, SchedBlock> hashMap = new HashMap<String, SchedBlock>(150);
        for (ObsUnitSet obsUnitSet2 : obsUnitSet.getObsUnitSet()) {
            for (ObsUnitSet obsUnitSet3 : obsUnitSet2.getObsUnitSet()) {
                for (SchedBlock schedBlock : obsUnitSet3.findSchedBlocks()) {
                    if (array.equals((Object)Array.ARRAY_12M) ? !schedBlock.is12mExtendedArraySB() : array.equals((Object)Array.ARRAY_7M) && !schedBlock.isACA7mArraySB()) continue;
                    for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                        for (Target target : observingGroup.getAllOrderedTargets(ScienceParameters.scienceParametersFilter)) {
                            hashMap.put(target.getFieldSource().getTargetParameters().getSourceName(), schedBlock);
                        }
                    }
                }
            }
        }
        return hashMap;
    }

    public static Map<String, SchedBlock> createTargetParametersSBMap(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        HashMap<String, SchedBlock> hashMap = new HashMap<String, SchedBlock>(150);
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            for (Target target : observingGroup.getAllOrderedTargets(ScienceParameters.scienceParametersFilter)) {
                hashMap.put(target.getFieldSource().getTargetParameters().getSourceName(), schedBlock);
            }
        }
        return hashMap;
    }

    public static class SBNotFoundException
    extends Exception {
        private static final long serialVersionUID = -1376482961494088385L;
    }

    public static class UnableToQuantizeIntegrationTimeException
    extends Exception {
        private static final long serialVersionUID = 2270109901775084793L;
    }

    public static class NotAMosaicException
    extends Exception {
    }

    public static class InfiniteBandwithException
    extends Exception {
    }
}

