/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.annotations.TargetContext;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public final class SchedBlockConsolidator {
    private static final List<TestUtilities.Prune> pruneAllEntityIds = Arrays.asList(new TestUtilities.Prune(" partId=\\S+", ""), new TestUtilities.Prune(" entityId=\\S+", ""), new TestUtilities.Prune(" entityPartId=\\S+", ""));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consolidate(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        SchedBlock schedBlock2 = schedBlock;
        synchronized (schedBlock2) {
            SchedBlockConsolidator.consolidateSpectralSpecs(schedBlock);
            SchedBlockConsolidator.consolidateObservingParameters(schedBlock);
            SchedBlockConsolidator.consolidateFieldSources(schedBlock);
        }
    }

    static void consolidateFieldSources(@NonNull SchedBlock schedBlock) {
        String string;
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        HashMap<Integer, FieldSource> hashMap = new HashMap<Integer, FieldSource>(40);
        HashMap<String, FieldSource> hashMap2 = new HashMap<String, FieldSource>(40);
        for (FieldSource targetContext : schedBlock.getFieldSource()) {
            string = TestUtilities.pruneXml(MiscUtils.convertToString((BusinessObject)targetContext), TestUtilities.pruneEntityIds);
            int n = string.hashCode();
            if (hashMap.keySet().contains(n)) {
                hashMap2.put(targetContext.getEntityPartId(), (FieldSource)hashMap.get(n));
                schedBlock.removeFieldSource(targetContext);
                continue;
            }
            hashMap.put(n, targetContext);
        }
        for (TargetContext targetContext : schedBlock.getTarget()) {
            string = targetContext.getCastorObject().getFieldSourceRef().getPartId();
            if (!hashMap2.containsKey(string)) continue;
            FieldSource fieldSource = (FieldSource)hashMap2.get(string);
            targetContext.setFieldSource(fieldSource);
        }
    }

    static void consolidateSpectralSpecs(@NonNull SchedBlock schedBlock) {
        String string;
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        HashMap<Integer, SpectralSpec> hashMap = new HashMap<Integer, SpectralSpec>(40);
        HashMap<String, SpectralSpec> hashMap2 = new HashMap<String, SpectralSpec>(40);
        for (SpectralSpec spectralSpecDocument : schedBlock.getSpectralSpec()) {
            string = MiscUtils.convertToString((BusinessObject)spectralSpecDocument).replaceAll("<sbl:desiredCenterFrequency[ ]*unit=\"[\\w]+?\">[ ]*(?:<content>)?(?:(?i)(?:[+-]?)(?:(?=[.]?[0-9])(?:[0-9]*)(?:(?:[.])(?:[0-9]{0,}))?)(?:(?:[E])(?:(?:[+-]?)(?:[0-9]+))|))(?:</content>)?[ ]*</sbl:desiredCenterFrequency>", "<sbl:desiredCenterFrequency unit=\"MHz\">0.0</sbl:desiredCenterFrequency>");
            string = TestUtilities.pruneXml(string, pruneAllEntityIds);
            int n = string.hashCode();
            if (hashMap.keySet().contains(n)) {
                hashMap2.put(spectralSpecDocument.getEntityPartId(), (SpectralSpec)hashMap.get(n));
                schedBlock.removeSpectralSpec(spectralSpecDocument);
                continue;
            }
            hashMap.put(n, spectralSpecDocument);
        }
        for (SpectralSpecDocument spectralSpecDocument : schedBlock.getTarget()) {
            string = spectralSpecDocument.getCastorObject().getAbstractInstrumentSpecRef().getPartId();
            if (!hashMap2.containsKey(string)) continue;
            SpectralSpec spectralSpec = (SpectralSpec)hashMap2.get(string);
            ((Target)spectralSpecDocument).setSpectralSpec(spectralSpec);
        }
    }

    static int getHash(@NonNull ObservingParameters observingParameters) {
        if (observingParameters == null) {
            throw new NullPointerException("observingParameters is marked non-null but is null");
        }
        return TestUtilities.pruneXml(MiscUtils.convertToString((BusinessObject)observingParameters), TestUtilities.pruneEntityIds).hashCode();
    }

    static void consolidateObservingParameters(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        HashMap<Integer, ObservingParameters> hashMap = new HashMap<Integer, ObservingParameters>(40);
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>(40);
        ObservingParameters[] observingParametersArray = schedBlock.getObservingParameters();
        List<ConsolidatedScienceParameters> list = SchedBlockConsolidator.groupSimilarScienceParameters(Arrays.asList(observingParametersArray));
        for (ObservingParameters targetContext : observingParametersArray) {
            int n = SchedBlockConsolidator.getHash(targetContext);
            ScienceParameters scienceParameters = null;
            if (targetContext instanceof ScienceParameters) {
                block1: for (ConsolidatedScienceParameters consolidatedScienceParameters : list) {
                    if (n == SchedBlockConsolidator.getHash((ObservingParameters)((Object)consolidatedScienceParameters.getRepresentativeScienceParameters()))) break;
                    for (Object object : consolidatedScienceParameters.getSimilarScienceParameters()) {
                        if (n != SchedBlockConsolidator.getHash((ObservingParameters)object)) continue;
                        scienceParameters = consolidatedScienceParameters.getRepresentativeScienceParameters();
                        continue block1;
                    }
                }
            }
            if (hashMap.keySet().contains(n) || scienceParameters != null) {
                if (scienceParameters != null) {
                    hashMap2.put(targetContext.getEntityPartId(), (Object)scienceParameters);
                } else {
                    hashMap2.put(targetContext.getEntityPartId(), (ObservingParameters)hashMap.get(n));
                }
                schedBlock.removeObservingParameters(targetContext);
                continue;
            }
            hashMap.put(n, targetContext);
        }
        for (TargetContext targetContext : schedBlock.getTarget()) {
            for (ObservingParameters observingParameters : targetContext.getObservingParameters()) {
                Object object;
                String string = observingParameters.getEntityPartId();
                if (!hashMap2.containsKey(string)) continue;
                object = (ObservingParameters)hashMap2.get(string);
                targetContext.removeObservingParameters(observingParameters);
                targetContext.addObservingParameters((ObservingParameters)object);
            }
        }
    }

    static List<ConsolidatedScienceParameters> groupSimilarScienceParameters(@NonNull List<ObservingParameters> list) {
        if (list == null) {
            throw new NullPointerException("observingParametersList is marked non-null but is null");
        }
        ArrayList<ConsolidatedScienceParameters> arrayList = new ArrayList<ConsolidatedScienceParameters>(40);
        ArrayList<ScienceParameters> arrayList2 = new ArrayList<ScienceParameters>(40);
        for (ObservingParameters object : list) {
            if (!(object instanceof ScienceParameters)) continue;
            arrayList2.add((ScienceParameters)((Object)object));
        }
        Collections.sort(arrayList2, (scienceParameters, scienceParameters2) -> {
            if (scienceParameters.getIntegrationTime().isGreaterThan((AbstractDoubleWithUnit)scienceParameters2.getIntegrationTime())) {
                return -1;
            }
            if (scienceParameters2.getIntegrationTime().isGreaterThan((AbstractDoubleWithUnit)scienceParameters.getIntegrationTime())) {
                return 1;
            }
            return 0;
        });
        HashSet hashSet = new HashSet(40);
        for (ScienceParameters scienceParameters3 : arrayList2) {
            if (hashSet.contains((Object)scienceParameters3)) continue;
            ConsolidatedScienceParameters consolidatedScienceParameters = new ConsolidatedScienceParameters(scienceParameters3);
            hashSet.add(scienceParameters3);
            for (ScienceParameters scienceParameters4 : arrayList2) {
                if (((Object)((Object)scienceParameters3)).equals((Object)scienceParameters4) || hashSet.contains((Object)scienceParameters4) || !SchedBlockConsolidator.isScienceIntegrationTimeApproximatelyTheSame(scienceParameters3, scienceParameters4)) continue;
                consolidatedScienceParameters.addSimilarScienceParameters(scienceParameters4);
                hashSet.add(scienceParameters4);
            }
            arrayList.add(consolidatedScienceParameters);
        }
        return arrayList;
    }

    private static boolean isScienceIntegrationTimeApproximatelyTheSame(@NonNull ScienceParameters scienceParameters, @NonNull ScienceParameters scienceParameters2) {
        boolean bl;
        if (scienceParameters == null) {
            throw new NullPointerException("scienceParametersA is marked non-null but is null");
        }
        if (scienceParameters2 == null) {
            throw new NullPointerException("scienceParametersB is marked non-null but is null");
        }
        if (!scienceParameters.getSubScanDuration().isEqual((AbstractDoubleWithUnit)scienceParameters2.getSubScanDuration())) {
            return false;
        }
        double d = scienceParameters.getIntegrationTime().getContentInUnits(Time.UNIT_S);
        double d2 = scienceParameters2.getIntegrationTime().getContentInUnits(Time.UNIT_S);
        double d3 = Math.round(scienceParameters.getRepresentativeBandwidth().getContentInUnits(Frequency.UNIT_KHZ));
        double d4 = Math.round(scienceParameters2.getRepresentativeBandwidth().getContentInUnits(Frequency.UNIT_KHZ));
        double d5 = scienceParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S);
        boolean bl2 = Math.ceil(d / d5) == Math.ceil(d2 / d5);
        boolean bl3 = bl = d4 == d3;
        if (bl2 && bl) {
            ScienceParameters scienceParameters3 = scienceParameters.deepCopy();
            ScienceParameters scienceParameters4 = scienceParameters2.deepCopy();
            IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource();
            scienceParameters3.setIntegrationTime(intTimeSource);
            scienceParameters4.setIntegrationTime(intTimeSource);
            Frequency frequency = Frequency.createFrequency();
            scienceParameters3.setRepresentativeBandwidth(frequency);
            scienceParameters4.setRepresentativeBandwidth(frequency);
            String string = TestUtilities.pruneXml(MiscUtils.convertToString((BusinessObject)scienceParameters3), TestUtilities.pruneEntityIds);
            String string2 = TestUtilities.pruneXml(MiscUtils.convertToString((BusinessObject)scienceParameters4), TestUtilities.pruneEntityIds);
            if (string.hashCode() == string2.hashCode()) {
                return true;
            }
        }
        return false;
    }

    private SchedBlockConsolidator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class ConsolidatedScienceParameters {
        private final ScienceParameters representativeScienceParameters;
        private final Set<ScienceParameters> similarScienceParameters = new HashSet<ScienceParameters>();

        public ConsolidatedScienceParameters(ScienceParameters scienceParameters) {
            this.representativeScienceParameters = scienceParameters;
        }

        public Set<ScienceParameters> getSimilarScienceParameters() {
            return Collections.unmodifiableSet(this.similarScienceParameters);
        }

        void addSimilarScienceParameters(ScienceParameters scienceParameters) {
            this.similarScienceParameters.add(scienceParameters);
        }

        public ScienceParameters getRepresentativeScienceParameters() {
            return this.representativeScienceParameters;
        }
    }
}

