/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.EntityIdFactoryImpl;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class SPWLinker {
    public void linkScienceSPWsInGroupOUSes(@NonNull ObsUnitSet obsUnitSet, @NonNull ScienceGoal scienceGoal) throws UnknownEntityException, MinTuningsCalculator.UnableToCalculateMinNumberOfTunings, UnableToFindSolutionException {
        if (obsUnitSet == null) {
            throw new NullPointerException("groupOUS is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        HashSet<SpectralSpec> hashSet = new HashSet<SpectralSpec>(60);
        List<SchedBlock> list = obsUnitSet.findSchedBlocks();
        int n = 0;
        n = scienceGoal.isSpectralScan() ? scienceGoal.getSpectralSetupParameters().getSpectralScan().getTunings().getNumberOfTunings().intValue() : MinTuningsCalculator.getLO1Tunings(scienceGoal).size();
        EntityIdFactoryImpl.FakeUIdGenerator fakeUIdGenerator = new EntityIdFactoryImpl.FakeUIdGenerator();
        HashMap<SPWLabel, String> hashMap = new HashMap<SPWLabel, String>(100);
        for (SchedBlock schedBlock : list) {
            for (int i = 0; i <= n; ++i) {
                ObservingGroup observingGroup = schedBlock.getObservingGroup(i);
                List<SpectralSpec> list2 = observingGroup.getAllOrderedTargets(ScienceParameters.scienceParametersFilter).stream().map(Target::getSpectralSpec).distinct().toList();
                for (SpectralSpec spectralSpec : list2) {
                    if (hashSet.contains(spectralSpec)) continue;
                    hashSet.add(spectralSpec);
                    for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
                        if (abstractBaseBandConfig == null) continue;
                        for (int j = 0; j < abstractBaseBandConfig.getSpectralWindowCount(); ++j) {
                            SPWLabel sPWLabel2 = new SPWLabel(this, i, j, abstractBaseBandConfig.getBaseBandIndex());
                            String string = hashMap.computeIfAbsent(sPWLabel2, sPWLabel -> StringUtils.remove((String)fakeUIdGenerator.generate(), (String)"fakeuid://"));
                            Log.logger(SPWLinker.class).fine("schedBlock=" + schedBlock.getName() + " Tuning=" + i + " baseband=" + abstractBaseBandConfig.getBaseBandName() + " spwIndex=" + j + " UUID=" + string);
                            SpectralWindowI spectralWindowI = abstractBaseBandConfig.getSpectralWindow(j);
                            spectralWindowI.setGroupingIdentifier(string);
                        }
                    }
                }
            }
        }
    }

    class SPWLabel {
        private int tuning;
        private int spwIndex;
        private int basebandIndex;

        public int getTuning() {
            return this.tuning;
        }

        public int getSpwIndex() {
            return this.spwIndex;
        }

        public int getBasebandIndex() {
            return this.basebandIndex;
        }

        public void setTuning(int n) {
            this.tuning = n;
        }

        public void setSpwIndex(int n) {
            this.spwIndex = n;
        }

        public void setBasebandIndex(int n) {
            this.basebandIndex = n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SPWLabel)) {
                return false;
            }
            SPWLabel sPWLabel = (SPWLabel)object;
            if (!sPWLabel.canEqual(this)) {
                return false;
            }
            if (this.getTuning() != sPWLabel.getTuning()) {
                return false;
            }
            if (this.getSpwIndex() != sPWLabel.getSpwIndex()) {
                return false;
            }
            return this.getBasebandIndex() == sPWLabel.getBasebandIndex();
        }

        protected boolean canEqual(Object object) {
            return object instanceof SPWLabel;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + this.getTuning();
            n = n * 59 + this.getSpwIndex();
            n = n * 59 + this.getBasebandIndex();
            return n;
        }

        public String toString() {
            return "SPWLinker.SPWLabel(tuning=" + this.getTuning() + ", spwIndex=" + this.getSpwIndex() + ", basebandIndex=" + this.getBasebandIndex() + ")";
        }

        public SPWLabel(SPWLinker sPWLinker, int n, int n2, int n3) {
            this.tuning = n;
            this.spwIndex = n2;
            this.basebandIndex = n3;
        }
    }
}

