/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.Velocity;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public class MinTuningsCalculator {
    private static CacheAccess<Integer, List<TuningResult>> loTuningsOutputCache = JCS.getInstance((String)"MinTuningsCalculator.lo1Tunings");
    private static int MAX_NUMBER_OF_CANDIDATE_TUNINGS = 16;

    public static List<TuningResult> removeDuplicateTargets(List<TuningResult> list) {
        HashSet<TargetParameters> hashSet = new HashSet<TargetParameters>();
        for (TuningResult tuningResult : list) {
            Sets.SetView setView = Sets.intersection(hashSet, tuningResult.getTargets());
            if (!setView.isEmpty()) {
                setView.stream().forEach(targetParameters -> tuningResult.targets.remove(targetParameters));
                if (!tuningResult.targets.contains(tuningResult.getKeyTarget())) {
                    tuningResult.setKeyTarget(tuningResult.getTargets().iterator().next());
                }
            }
            hashSet.addAll(tuningResult.targets);
        }
        return list;
    }

    public static List<TuningResult> getLO1Tunings(@NonNull ScienceGoal scienceGoal) throws UnableToCalculateMinNumberOfTunings {
        Object object;
        Object object3;
        Object object4;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        Integer n = MiscUtils.getCacheHashcode(false, new BusinessObject[]{scienceGoal});
        List list = (List)loTuningsOutputCache.get((Object)n);
        if (list != null) {
            return list;
        }
        ScienceGoal scienceGoal2 = scienceGoal.deepCopy();
        int n2 = scienceGoal2.getKeyTargetParametersPosition();
        SpectralSetupParameters spectralSetupParameters = scienceGoal2.getSpectralSetupParameters();
        HashMap<Frequency, Set<TargetParameters>> hashMap = new HashMap<Frequency, Set<TargetParameters>>(30);
        HashMap<Frequency, TargetParameters> hashMap2 = new HashMap<Frequency, TargetParameters>(30);
        TargetParameters[] targetParametersArray = scienceGoal2.getTargetParameters();
        for (int i = 0; i < targetParametersArray.length; ++i) {
            scienceGoal2.setKeyTargetParameters(i);
            boolean bl = false;
            try {
                bl = spectralSetupParameters.verifyBasebandSetting();
            }
            catch (BaseBandNotDeployableException baseBandNotDeployableException) {
                continue;
            }
            if (!bl) continue;
            object4 = scienceGoal2.getKeyTargetParameters();
            object3 = spectralSetupParameters.getLO1Frequency().deepCopy();
            if (!hashMap.containsKey(object3)) {
                hashMap.put((Frequency)((Object)object3), new HashSet(30));
                hashMap2.put((Frequency)((Object)object3), (TargetParameters)object4);
            }
            if (spectralSetupParameters.isSingleContinuum() && !spectralSetupParameters.isSingleContinuumSkyFrequency()) {
                Velocity velocity = object4.getSourceVelocity();
                object = targetParametersArray;
                int n3 = ((TargetParameters[])object).length;
                for (int j = 0; j < n3; ++j) {
                    TargetParameters targetParameters = object[j];
                    if (!((Object)((Object)targetParameters.getSourceVelocity())).equals((Object)velocity)) continue;
                    ((Set)hashMap.get(object3)).add(targetParameters);
                }
                continue;
            }
            for (TargetParameters targetParameters : targetParametersArray) {
                boolean bl2 = true;
                UserFrequency userFrequency = targetParameters.getExpectedProperties().getExpectedLineWidth();
                for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                    Frequency frequency;
                    FrequencyRange frequencyRange;
                    Frequency frequency2;
                    Frequency frequency3 = scienceSpectralWindow.getCenterFrequencySky();
                    FrequencyRange frequencyRange2 = FrequencyRange.centredOn(frequency3, frequency2 = scienceSpectralWindow.getEffectiveBandwidth());
                    if (frequencyRange2.contains(frequencyRange = FrequencyRange.centredOn(frequency = targetParameters.getSourceVelocityInDefaultReferenceFrame(Optional.of(scienceGoal)).dopplerShift(scienceSpectralWindow.getCenterFrequencyRest()), (Frequency)((Object)userFrequency))) || targetParameters == object4) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                ((Set)hashMap.get(object3)).add(targetParameters);
            }
        }
        scienceGoal2.setKeyTargetParameters(n2);
        LinkedHashSet<TargetParameters> linkedHashSet = new LinkedHashSet<TargetParameters>(Arrays.asList(targetParametersArray));
        Filter filter = MinTuningsCalculator.getFilter(linkedHashSet);
        object4 = MinTuningsCalculator.getSmallestNumberOfTunings(filter, MinTuningsCalculator.removeTuningsThatAreSubsetsOfOtherTunings(hashMap));
        if (object4 == null) {
            object3 = MinTuningsCalculator.toTuningResults(hashMap, hashMap2);
            loTuningsOutputCache.put((Object)n, object3);
            return object3;
        }
        object3 = new LinkedHashMap(50);
        Iterator iterator = object4.iterator();
        while (iterator.hasNext()) {
            object = (Set)iterator.next();
            Frequency frequency = MinTuningsCalculator.getKeyByValue(hashMap, object);
            if (frequency == null) continue;
            object3.put(frequency, (Set)hashMap.get((Object)frequency));
        }
        List<TuningResult> list2 = MinTuningsCalculator.toTuningResults((Map<Frequency, Set<TargetParameters>>)object3, hashMap2);
        loTuningsOutputCache.put((Object)n, list2);
        return list2;
    }

    private static List<TuningResult> toTuningResults(Map<Frequency, Set<TargetParameters>> map, Map<Frequency, TargetParameters> map2) {
        ArrayList<TuningResult> arrayList = new ArrayList<TuningResult>();
        for (Frequency frequency : map.keySet()) {
            TargetParameters targetParameters = map2.get((Object)frequency);
            TuningResult tuningResult = new TuningResult(frequency, targetParameters, map.get((Object)frequency));
            arrayList.add(tuningResult);
        }
        return arrayList;
    }

    private static <T, E> T getKeyByValue(Map<T, E> map, E e) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!e.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private static <T> Filter<Set<Set<T>>> getFilter(Set<T> set) {
        return set2 -> {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            for (Set set3 : set2) {
                linkedHashSet.addAll(set3);
            }
            return linkedHashSet.equals(set);
        };
    }

    static List<Set<TargetParameters>> removeTuningsThatAreSubsetsOfOtherTunings(Map<Frequency, Set<TargetParameters>> map) {
        int n;
        ArrayList<Set<TargetParameters>> arrayList = new ArrayList<Set<TargetParameters>>(map.values());
        Collections.sort(arrayList, (set, set2) -> {
            if (set.size() > set2.size()) {
                return 1;
            }
            if (set.size() == set2.size()) {
                return 0;
            }
            return -1;
        });
        for (int i = arrayList.size() - 1; i > 0; --i) {
            block1: for (n = 0; n < i; ++n) {
                Set set3 = (Set)arrayList.get(i);
                Set set4 = (Set)arrayList.get(n);
                if (set3 == null || set4 == null) continue;
                int n2 = 0;
                int n3 = set4.size();
                for (TargetParameters targetParameters : set4) {
                    for (TargetParameters targetParameters2 : set3) {
                        if (!targetParameters.equals(targetParameters2)) continue;
                        ++n2;
                    }
                    if (n2 != n3) continue;
                    arrayList.set(n, null);
                    continue block1;
                }
            }
        }
        ArrayList<Set<TargetParameters>> arrayList2 = new ArrayList<Set<TargetParameters>>();
        for (n = 0; n < arrayList.size(); ++n) {
            if (arrayList.get(n) == null) continue;
            arrayList2.add((Set)arrayList.get(n));
        }
        if (Log.logger(MinTuningsCalculator.class).fine()) {
            Log.logger(MinTuningsCalculator.class).fine("Number of candidates after subset analysis: " + arrayList2.size() + " reduced from " + arrayList.size());
        }
        return arrayList2;
    }

    static <T> Set<T> getSmallestNumberOfTunings(Filter<Set<T>> filter, Collection<T> collection) throws UnableToCalculateMinNumberOfTunings {
        Set set3;
        Object object2;
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        int n = arrayList.size();
        for (Object object2 : arrayList) {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            linkedHashSet.add(object2);
            if (!filter.matches(linkedHashSet)) continue;
            return linkedHashSet;
        }
        if (n > MAX_NUMBER_OF_CANDIDATE_TUNINGS) {
            throw new UnableToCalculateMinNumberOfTunings("Too many tuning combinations to be processed: distribute your sources over different science goals");
        }
        int n2 = 1 << n;
        object2 = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            set3 = new LinkedHashSet();
            for (int j = 0; j < n; ++j) {
                if ((i >> j & 1) == 0) continue;
                set3.add(arrayList.get(j));
            }
            object2.add(set3);
        }
        Collections.sort(object2, (set, set2) -> set.size() - set2.size());
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            set3 = (Set)iterator.next();
            if (!filter.matches(set3)) continue;
            return set3;
        }
        return null;
    }

    public static class TuningResult {
        private final Frequency frequency;
        private TargetParameters keyTarget;
        private final Set<TargetParameters> targets;

        public Set<TargetParameters> getTargets() {
            return new HashSet<TargetParameters>(this.targets);
        }

        public TuningResult(Frequency frequency, TargetParameters targetParameters, Set<TargetParameters> set) {
            this.frequency = frequency;
            this.keyTarget = targetParameters;
            this.targets = set;
        }

        public Frequency getFrequency() {
            return this.frequency;
        }

        public TargetParameters getKeyTarget() {
            return this.keyTarget;
        }

        public void setKeyTarget(TargetParameters targetParameters) {
            this.keyTarget = targetParameters;
        }
    }

    static interface Filter<T> {
        public boolean matches(T var1);
    }

    public static class UnableToCalculateMinNumberOfTunings
    extends Exception {
        public UnableToCalculateMinNumberOfTunings(String string) {
            super(string);
        }
    }
}

