/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.SpectralSpec;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public class BasebandPostProcessor {
    @NonNull
    private final SpectralSpec spectralSpec;

    public void sortBasebandsInScienceSpectralSpecByFrequency() {
        if (this.spectralSpec.getReceiverType().equals("TSB")) {
            this.sortBBsinTSBReceiver(this.spectralSpec);
        } else {
            this.sortBBsinNonTSBReceiver(this.spectralSpec);
        }
    }

    private void sortBBsinNonTSBReceiver(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        List<AbstractBaseBandConfig> list = spectralSpec.getBaseBandConfig();
        list.sort((abstractBaseBandConfig, abstractBaseBandConfig2) -> abstractBaseBandConfig.getCenterFrequency().compareTo((AbstractDoubleWithUnit)abstractBaseBandConfig2.getCenterFrequency()));
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
        List<BaseBandSpecification> list2 = Arrays.asList(spectralSpec.getFrequencySetup().getBaseBandSpecification());
        list2.sort((baseBandSpecification, baseBandSpecification2) -> baseBandSpecification.getCenterFrequency().compareTo((AbstractDoubleWithUnit)baseBandSpecification2.getCenterFrequency()));
        spectralSpec.clearBaseBand();
        for (int i = 0; i < list.size(); ++i) {
            abstractCorrelatorConfiguration.addBaseBandConfig(i, list.get(i));
        }
        FrequencySetup frequencySetup = spectralSpec.getFrequencySetup();
        for (int i = 0; i < list2.size(); ++i) {
            BaseBandSpecification baseBandSpecification3 = list2.get(i);
            baseBandSpecification3.setBaseBandName("BB_" + (i + 1));
            frequencySetup.addBaseBandSpecification(i, baseBandSpecification3);
        }
    }

    private void sortBBsinTSBReceiver(@NonNull SpectralSpec spectralSpec) {
        BaseBandSpecification baseBandSpecification;
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        List<AbstractBaseBandConfig> list = spectralSpec.getBaseBandConfig();
        list.sort((abstractBaseBandConfig, abstractBaseBandConfig2) -> abstractBaseBandConfig.getCenterFrequency().compareTo((AbstractDoubleWithUnit)abstractBaseBandConfig2.getCenterFrequency()));
        List<AbstractBaseBandConfig> list2 = list.stream().filter(abstractBaseBandConfig -> abstractBaseBandConfig.getSingleSpectralWindowCount() > 0 && abstractBaseBandConfig.getSingleSpectralWindow(0).getSideBand().equals(AbstractSpectralWindow.SIDEBAND_LSB)).toList();
        List<AbstractBaseBandConfig> list3 = list.stream().filter(abstractBaseBandConfig -> abstractBaseBandConfig.getSingleSpectralWindowCount() > 0 && abstractBaseBandConfig.getSingleSpectralWindow(0).getSideBand().equals(AbstractSpectralWindow.SIDEBAND_USB)).toList();
        spectralSpec.clearBaseBand();
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
        FrequencySetup frequencySetup = spectralSpec.getFrequencySetup();
        int n = 1;
        int n2 = 0;
        for (AbstractBaseBandConfig abstractBaseBandConfig3 : list2) {
            abstractCorrelatorConfiguration.addBaseBandConfig(n2, abstractBaseBandConfig3);
            baseBandSpecification = abstractBaseBandConfig3.getBaseBandSpecification();
            frequencySetup.addBaseBandSpecification(baseBandSpecification);
            baseBandSpecification.setBaseBandName("BB_" + n++);
            ++n2;
        }
        if (list3.size() != 4 && !list2.isEmpty()) {
            n = 3;
        }
        for (AbstractBaseBandConfig abstractBaseBandConfig3 : list3) {
            abstractCorrelatorConfiguration.addBaseBandConfig(n2, abstractBaseBandConfig3);
            baseBandSpecification = abstractBaseBandConfig3.getBaseBandSpecification();
            frequencySetup.addBaseBandSpecification(baseBandSpecification);
            baseBandSpecification.setBaseBandName("BB_" + n++);
            ++n2;
        }
    }

    public BasebandPostProcessor(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        this.spectralSpec = spectralSpec;
    }
}

