/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.generator.refactored.ArraySBGroupPostProcessorInterface;
import alma.obsprep.services.generator.refactored.TotalPowerScienceSBGroupPostProcessor;
import java.util.Collection;
import java.util.Optional;
import lombok.NonNull;

public class ArraySBGroupPostProcessorFactory {
    public static Optional<ArraySBGroupPostProcessorInterface> getSBGroupPostProcessor(@NonNull Collection<SchedBlock> collection) {
        if (collection == null) {
            throw new NullPointerException("schedBlockGroup is marked non-null but is null");
        }
        if (collection.isEmpty()) {
            return Optional.empty();
        }
        Optional<Object> optional = Optional.empty();
        for (SchedBlock schedBlock : collection) {
            String string = schedBlock.getObsUnitControl().getArrayRequested();
            if (!optional.isPresent()) {
                optional = Optional.of(string);
                continue;
            }
            if (optional.get().equals(string)) continue;
            throw new IllegalArgumentException("All of the SBs in groups should be for the same array");
        }
        if (collection.iterator().next().isTotalPowerScienceSB()) {
            return Optional.of(new TotalPowerScienceSBGroupPostProcessor());
        }
        return Optional.empty();
    }
}

