/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.DataProcessingParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.SchedBlockPostProcessor;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class AQUADataProcessingFlagGenerator {
    @NonNull
    private final ScienceGoal piDefinedSG;

    void setAQUASBDataProcessingFlags(@NonNull SchedBlock schedBlock, boolean bl) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        List<DataProcessingParameters.AQUADataProcessingFlags> list = schedBlock.getDataProcessingParameters();
        this.setEnhancedAstrometryFlag(sBGenerationContext, list);
        this.setDGCFlag(bl, sBGenerationContext, list);
        this.setVLBIFlag(sBGenerationContext, list);
        this.setPhasedArrayFlag(list);
        this.setFullPolarizationFlag(sBGenerationContext, list);
        this.setExternalEphemerisSelectedFlag(sBGenerationContext, list);
        this.setTimeConstrainedFlag(sBGenerationContext, list);
        this.setHighFrequencyFlag(sBGenerationContext, list);
        this.setNarrowBandwidthFlag(sBGenerationContext, list);
        this.setLongbaselineFlag(schedBlock, list);
        this.setSolarFlag(sBGenerationContext, list);
        this.setUserdefinedCalibrationFlag(sBGenerationContext, list);
        this.setTOOFlag(sBGenerationContext, list);
        this.setSpectralScanFlag(sBGenerationContext, list);
        this.setSinglePolarizationFlag(sBGenerationContext, list);
        if (Log.logger(SchedBlockPostProcessor.class).fine()) {
            String string = list.stream().map(Enum::toString).collect(Collectors.joining(","));
            Log.logger(SchedBlockPostProcessor.class).fine("AQUA flags for sb " + schedBlock.getName() + " are " + string);
        }
    }

    private void setTOOFlag(@NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        ObsProposal obsProposal;
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        try {
            obsProposal = sBGenerationContext.getGoal().getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(AQUADataProcessingFlagGenerator.class).warning("Unable to get the obsproposal to determine if TOO" + unknownEntityException.getMessage());
            return;
        }
        if (obsProposal.isToO()) {
            list.add(DataProcessingParameters.AQUADataProcessingFlags.TOO);
        }
    }

    private void setUserdefinedCalibrationFlag(@NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        if (scienceGoal.getCalibrationSetupParameters().isUserDefinedCalibration()) {
            list.add(DataProcessingParameters.AQUADataProcessingFlags.USERDEFINEDCALIBRATION);
        }
    }

    private void setSolarFlag(@NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        try {
            if (sBGenerationContext.getGoal().isSolarScienceGoal()) {
                list.add(DataProcessingParameters.AQUADataProcessingFlags.SOLAR);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(AQUADataProcessingFlagGenerator.class).warning("Unable to determine if the SB is solar");
        }
    }

    private void setLongbaselineFlag(@NonNull SchedBlock schedBlock, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        List<String> list2 = Arrays.asList(schedBlock.getSchedulingConstraints().getNominalConfiguration());
        if (list2 == null) {
            return;
        }
        if (Configuration.getLongBaseLineConfigurations().stream().anyMatch(configuration -> list2.contains(configuration.getName()))) {
            list.add(DataProcessingParameters.AQUADataProcessingFlags.LONGBASELINE);
        }
    }

    private void setFullPolarizationFlag(@NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        if (sBGenerationContext.getGoal().getSpectralSetupParameters().isFullPolarisation()) {
            list.add(DataProcessingParameters.AQUADataProcessingFlags.FULLPOLARIZATION);
        }
    }

    private void setSinglePolarizationFlag(@NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        if (sBGenerationContext.getGoal().getSpectralSetupParameters().isSinglePolarisation()) {
            list.add(DataProcessingParameters.AQUADataProcessingFlags.SINGLEPOLARIZATION);
        }
    }

    private void setSpectralScanFlag(@NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        if (sBGenerationContext.getGoal().getSpectralSetupParameters().isSpectralScan()) {
            list.add(DataProcessingParameters.AQUADataProcessingFlags.SPECTRALSCAN);
        }
    }

    private void setExternalEphemerisSelectedFlag(@NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            if (!targetParameters.getNonSiderealMotion() || !StringUtils.isNotEmpty((CharSequence)targetParameters.getSourceEphemeris())) continue;
            list.add(DataProcessingParameters.AQUADataProcessingFlags.EXTERNALEPHEMERIS);
            return;
        }
    }

    private void setTimeConstrainedFlag(@NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        if (scienceGoal.getPerformanceParameters().getIsTimeConstrained()) {
            list.add(DataProcessingParameters.AQUADataProcessingFlags.TIMECONSTRAINED);
        }
    }

    private void setVLBIFlag(@NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        ObsProposal obsProposal;
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        try {
            obsProposal = this.piDefinedSG.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(AQUADataProcessingFlagGenerator.class).warning("Unable to determine proposal " + unknownEntityException.getMessage());
            return;
        }
        if (obsProposal != null && obsProposal.isVLBI()) {
            list.add(DataProcessingParameters.AQUADataProcessingFlags.VLBI);
        }
    }

    private void setPhasedArrayFlag(@NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        ObsProposal obsProposal;
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        try {
            obsProposal = this.piDefinedSG.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(AQUADataProcessingFlagGenerator.class).warning("Unable to determine proposal " + unknownEntityException.getMessage());
            return;
        }
        if (obsProposal != null && obsProposal.isPhasedArray()) {
            list.add(DataProcessingParameters.AQUADataProcessingFlags.PHASEDARRAY);
        }
    }

    private void setHighFrequencyFlag(@NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        ReceiverBand receiverBand = scienceGoal.getSpectralSetupParameters().getReceiverBand();
        if (receiverBand != null && ReceiverBand.isHighFrequencyBand(receiverBand)) {
            list.add(DataProcessingParameters.AQUADataProcessingFlags.HIGHFREQUENCY);
        }
    }

    private void setNarrowBandwidthFlag(@NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        if (SingleFieldScienceGoalModel.isNarrowBWScienceGoal(scienceGoal)) {
            list.add(DataProcessingParameters.AQUADataProcessingFlags.NARROWBANDWIDTH);
        }
    }

    private void setDGCFlag(boolean bl, @NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = sBGenerationContext.getSchemaToUseForSBGeneration();
        if (bl) {
            if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_B2B)) {
                list.add(DataProcessingParameters.AQUADataProcessingFlags.B2B);
            } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW)) {
                list.add(DataProcessingParameters.AQUADataProcessingFlags.BWSW);
            } else {
                throw new WizardSBGenerationException("Unable to determine the DGC mode when establishing the AQUA flags");
            }
        }
    }

    private void setEnhancedAstrometryFlag(@NonNull SBGenerationContext sBGenerationContext, @NonNull List<DataProcessingParameters.AQUADataProcessingFlags> list) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("dataProcessingParameters is marked non-null but is null");
        }
        if (sBGenerationContext.getGoal().getCalibrationSetupParameters().isEnhancedAstrometry()) {
            list.add(DataProcessingParameters.AQUADataProcessingFlags.ASTROMETRY);
        }
    }

    public AQUADataProcessingFlagGenerator(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("piDefinedSG is marked non-null but is null");
        }
        this.piDefinedSG = scienceGoal;
    }

    @NonNull
    public ScienceGoal getPiDefinedSG() {
        return this.piDefinedSG;
    }
}

