/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BLBaseBandConfig;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLSpectralWindow;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.SpectralSpecWorker;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.util.Optional;
import lombok.NonNull;

public class BLSpectralSpecWorker
extends SpectralSpecWorker {
    public BLSpectralSpecWorker(SpectralSetupParameters spectralSetupParameters, Velocity velocity, @NonNull Optional<SBGenerationContext> optional) {
        super(spectralSetupParameters, CorrelatorType.BL, velocity, optional);
        if (optional == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
    }

    @Override
    protected SpectralSpec createSpectralSpecWithCorrelatorConfiguration() {
        return SpectralSpec.createSpectralSpecWithBLCorrelatorConfiguration(this.sbGenerationContext);
    }

    @Override
    public void setupCorrelatorConfig(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        super.setupCorrelatorConfig(abstractCorrelatorConfiguration);
        Time time = Time.createTime((double)this.correxp.calcDumpDurationInmsecs(), (String)Time.UNIT_MS);
        ((BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration)).setDumpDuration(time);
    }

    @Override
    protected AbstractBaseBandConfig addNewBaseBandConfig(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        BLBaseBandConfig bLBaseBandConfig = (BLBaseBandConfig)((Object)super.addNewBaseBandConfig(abstractCorrelatorConfiguration));
        return bLBaseBandConfig;
    }

    @Override
    protected AbstractSpectralWindow addNewSpectralWindow(AbstractBaseBandConfig abstractBaseBandConfig, ScienceSpectralWindow scienceSpectralWindow) {
        BLSpectralWindow bLSpectralWindow = (BLSpectralWindow)((Object)super.addNewSpectralWindow(abstractBaseBandConfig, scienceSpectralWindow));
        bLSpectralWindow.setCorrelationBits(BLSpectralWindow.CORRELATIONBITS_BITS_2X2);
        return bLSpectralWindow;
    }
}

