/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.NonNull;

public class UnitFormat
extends Format {
    private final SortedSet<UnitOfMagnitude> units = new TreeSet<UnitOfMagnitude>();

    public void addUnitOfMagnitude(double d, String string) {
        this.addUnitOfMagnitude(d, new DecimalFormat(string));
    }

    public void addUnitOfMagnitude(double d, DecimalFormat decimalFormat) {
        this.units.add(new UnitOfMagnitude(d, decimalFormat));
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Number number = (Number)object;
        UnitOfMagnitude unitOfMagnitude = this.bestUnitForObject(number);
        Number number2 = unitOfMagnitude.adjust(number);
        return unitOfMagnitude.getFormat().format(number2, stringBuffer, fieldPosition);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        Number number = (Number)object;
        UnitOfMagnitude unitOfMagnitude = this.bestUnitForObject(number);
        Number number2 = unitOfMagnitude.adjust(number);
        return unitOfMagnitude.getFormat().formatToCharacterIterator(number2);
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    private UnitOfMagnitude bestUnitForObject(@NonNull Number number) {
        UnitOfMagnitude unitOfMagnitude;
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (this.units.isEmpty()) {
            throw new IllegalStateException();
        }
        double d = number.doubleValue();
        UnitOfMagnitude unitOfMagnitude2 = this.units.first();
        Iterator iterator = this.units.iterator();
        while (iterator.hasNext() && d >= (unitOfMagnitude = (UnitOfMagnitude)iterator.next()).getMagnitude()) {
            unitOfMagnitude2 = unitOfMagnitude;
        }
        return unitOfMagnitude2;
    }

    public static UnitFormat fileSizes() {
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(1.0, "###0 bytes");
        unitFormat.addUnitOfMagnitude(1024.0, "###0.# KB");
        unitFormat.addUnitOfMagnitude(1048576.0, "###0.# MB");
        unitFormat.addUnitOfMagnitude(1.073741824E9, "###0.# GB");
        return unitFormat;
    }

    public static UnitFormat length() {
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(1.0E-6, "###0.# \u00b5m");
        unitFormat.addUnitOfMagnitude(0.001, "###0.# mm");
        unitFormat.addUnitOfMagnitude(1.0, "###0.# m");
        unitFormat.addUnitOfMagnitude(1000.0, "###0.# km");
        return unitFormat;
    }

    public static UnitFormat frequency() {
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(1.0E-6, "###0.###### \u00b5Hz");
        unitFormat.addUnitOfMagnitude(0.001, "###0.###### mHz");
        unitFormat.addUnitOfMagnitude(1.0, "###0.####### Hz");
        unitFormat.addUnitOfMagnitude(1000.0, "###0.###### kHz");
        unitFormat.addUnitOfMagnitude(1000000.0, "###0.000000 MHz");
        unitFormat.addUnitOfMagnitude(1.0E9, "###0.000000 GHz");
        unitFormat.addUnitOfMagnitude(1.0E12, "###0.###### THz");
        return unitFormat;
    }

    public static UnitFormat frequency(String string) {
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(1.0E-6, string + " \u00b5Hz");
        unitFormat.addUnitOfMagnitude(0.001, string + " mHz");
        unitFormat.addUnitOfMagnitude(1.0, string + " Hz");
        unitFormat.addUnitOfMagnitude(1000.0, string + " kHz");
        unitFormat.addUnitOfMagnitude(1000000.0, string + " MHz");
        unitFormat.addUnitOfMagnitude(1.0E9, string + " GHz");
        unitFormat.addUnitOfMagnitude(1.0E12, string + " THz");
        return unitFormat;
    }

    public static UnitFormat fluxDensity(String string) {
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(1.0E-9, string + " nJy");
        unitFormat.addUnitOfMagnitude(1.0E-6, string + " \u00b5Jy");
        unitFormat.addUnitOfMagnitude(0.001, string + " mJy");
        unitFormat.addUnitOfMagnitude(1.0, string + " Jy");
        unitFormat.addUnitOfMagnitude(1000.0, string + " kJy");
        return unitFormat;
    }

    public static UnitFormat fluxDensity() {
        return UnitFormat.fluxDensity("###0.###");
    }

    public static UnitFormat energy() {
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(1.0E-24, "###0.### yJ");
        unitFormat.addUnitOfMagnitude(1.0E-21, "###0.### zJ");
        unitFormat.addUnitOfMagnitude(1.0E-18, "###0.### aJ");
        unitFormat.addUnitOfMagnitude(1.0E-15, "###0.### fJ");
        unitFormat.addUnitOfMagnitude(1.0E-12, "###0.### pJ");
        unitFormat.addUnitOfMagnitude(1.0E-9, "###0.### nJ");
        unitFormat.addUnitOfMagnitude(1.0E-6, "###0.### \u00b5J");
        unitFormat.addUnitOfMagnitude(0.001, "###0.### mJ");
        unitFormat.addUnitOfMagnitude(1.0, "###0.### J");
        unitFormat.addUnitOfMagnitude(1000.0, "###0.### kJ");
        unitFormat.addUnitOfMagnitude(1000000.0, "###0.### MJ");
        unitFormat.addUnitOfMagnitude(1.0E9, "###0.### GJ");
        unitFormat.addUnitOfMagnitude(1.0E12, "###0.### TJ");
        unitFormat.addUnitOfMagnitude(1.0E15, "###0.### PJ");
        unitFormat.addUnitOfMagnitude(1.0E18, "###0.### EJ");
        unitFormat.addUnitOfMagnitude(1.0E21, "###0.### ZJ");
        unitFormat.addUnitOfMagnitude(1.0E24, "###0.### YJ");
        return unitFormat;
    }

    public static UnitFormat velocity() {
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(1.0, "###0.### m/s");
        unitFormat.addUnitOfMagnitude(1000.0, "###0.### km/s");
        return unitFormat;
    }

    public static UnitFormat velocity(String string) {
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(1.0, string + " m/s");
        unitFormat.addUnitOfMagnitude(1000.0, string + " km/s");
        return unitFormat;
    }

    public static UnitFormat properMotion() {
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(1.0, "###0.### mas/yr");
        unitFormat.addUnitOfMagnitude(1000.0, "###0.### arcsec/yr");
        unitFormat.addUnitOfMagnitude(60000.0, "###0.### arcmin/yr");
        unitFormat.addUnitOfMagnitude(3600000.0, "###0.### deg/yr");
        return unitFormat;
    }

    public static UnitFormat temperature(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(1.0E-24, string + " yK");
        unitFormat.addUnitOfMagnitude(1.0E-21, string + " zK");
        unitFormat.addUnitOfMagnitude(1.0E-18, string + " aK");
        unitFormat.addUnitOfMagnitude(1.0E-15, string + " fK");
        unitFormat.addUnitOfMagnitude(1.0E-12, string + " pK");
        unitFormat.addUnitOfMagnitude(1.0E-9, string + " nK");
        unitFormat.addUnitOfMagnitude(1.0E-6, string + " \u00b5K");
        unitFormat.addUnitOfMagnitude(0.001, string + " mK");
        unitFormat.addUnitOfMagnitude(1.0, string + " K");
        return unitFormat;
    }

    public static UnitFormat uvLimit(String string) {
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(0.001, string + "\u03bb");
        unitFormat.addUnitOfMagnitude(1.0, string + " k\u03bb");
        return unitFormat;
    }

    public static UnitFormat temperature() {
        return UnitFormat.temperature("###0.###");
    }

    public static UnitFormat debyeSquared() {
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(1.0, "###0.### D\u00b2");
        return unitFormat;
    }

    public static UnitFormat sexagesimalArc() {
        UnitFormat unitFormat = new UnitFormat();
        unitFormat.addUnitOfMagnitude(1.0, "###0.###\u00b0");
        unitFormat.addUnitOfMagnitude(0.016666666666666666, "#0.###\u2032");
        unitFormat.addUnitOfMagnitude(2.777777777777778E-4, "#0.###\u2033");
        unitFormat.addUnitOfMagnitude(2.7777777777777776E-7, "#0.### mas");
        unitFormat.addUnitOfMagnitude(2.7777777777777777E-10, "#0.### \u00b5as");
        return unitFormat;
    }

    private static class UnitOfMagnitude
    implements Comparable<UnitOfMagnitude> {
        private final double magnitude;
        private final DecimalFormat format;

        public Number adjust(Number number) {
            return number.doubleValue() / this.magnitude;
        }

        @Override
        public int compareTo(UnitOfMagnitude unitOfMagnitude) {
            if (this.magnitude < unitOfMagnitude.magnitude) {
                return -1;
            }
            if (this.magnitude == unitOfMagnitude.magnitude) {
                return 0;
            }
            return 1;
        }

        public double getMagnitude() {
            return this.magnitude;
        }

        public DecimalFormat getFormat() {
            return this.format;
        }

        public UnitOfMagnitude(double d, DecimalFormat decimalFormat) {
            this.magnitude = d;
            this.format = decimalFormat;
        }
    }
}

