/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import alma.obsprep.services.experts.spectralline.gui.DateRenderer;
import alma.obsprep.services.experts.spectralline.gui.LineTitleRenderer;
import alma.obsprep.services.experts.spectralline.gui.OTTableRenderer;
import alma.obsprep.services.experts.spectralline.gui.UnitFormat;
import alma.obsprep.services.experts.spectralline.gui.UnitFormatTableCellRenderer;

public class TableCellRendererFactory {
    public static OTTableRenderer getTableCellRenderer(Units units) {
        switch (units.ordinal()) {
            case 1: {
                return new UnitFormatTableCellRenderer(UnitFormat.debyeSquared());
            }
            case 2: {
                return new UnitFormatTableCellRenderer(UnitFormat.frequency());
            }
            case 3: {
                return new UnitFormatTableCellRenderer(UnitFormat.fluxDensity());
            }
            case 0: {
                return new UnitFormatTableCellRenderer(UnitFormat.temperature());
            }
            case 4: {
                return new UnitFormatTableCellRenderer(UnitFormat.sexagesimalArc());
            }
            case 6: {
                return new DateRenderer();
            }
            case 5: {
                return new LineTitleRenderer();
            }
        }
        return new OTTableRenderer();
    }

    public static enum Units {
        TEMPERATURE,
        DEBYE_SQUARED,
        FREQUENCY,
        FLUX_DENSITY,
        SEPARATION,
        LINETITLE,
        DATE,
        CAL_FLUX_DENSITY;

    }
}

