/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class HintTextFieldUI
extends BasicTextFieldUI
implements FocusListener {
    private String hint;
    private boolean hideOnFocus;
    private Color color;
    private int prefixLength = 0;
    private int suffixLength = 0;

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    private void repaint() {
        if (this.getComponent() != null) {
            this.getComponent().repaint();
        }
    }

    public boolean isHideOnFocus() {
        return this.hideOnFocus;
    }

    public void setHideOnFocus(boolean bl) {
        this.hideOnFocus = bl;
        this.repaint();
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String string) {
        this.hint = string;
        this.repaint();
    }

    public HintTextFieldUI(int n, int n2, String string) {
        this(n, n2, string, false);
    }

    public HintTextFieldUI(int n, int n2, String string, boolean bl) {
        this(n, n2, string, bl, null);
    }

    public HintTextFieldUI(int n, int n2, String string, boolean bl, Color color) {
        this.prefixLength = n;
        this.suffixLength = n2;
        this.hint = string;
        this.hideOnFocus = bl;
        this.color = color;
    }

    @Override
    protected void paintSafely(Graphics graphics) {
        super.paintSafely(graphics);
        JTextComponent jTextComponent = this.getComponent();
        int n = this.prefixLength + this.suffixLength;
        if (!(this.hint == null || jTextComponent.getText().length() != n || this.hideOnFocus && jTextComponent.hasFocus())) {
            if (jTextComponent.isOpaque()) {
                this.paintBackground(graphics);
            }
            if (this.color != null) {
                graphics.setColor(this.color);
            } else {
                graphics.setColor(jTextComponent.getForeground().brighter().brighter().brighter());
            }
            int n2 = (jTextComponent.getHeight() - jTextComponent.getFont().getSize()) / 2;
            graphics.drawString(this.hint, 2, jTextComponent.getHeight() - n2 - 1);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.hideOnFocus) {
            this.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.hideOnFocus) {
            this.repaint();
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addFocusListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this);
    }
}

