/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.calibrators;

import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.SimpleMeasurement;
import alma.obsprep.bo.obsproject.ICalibratorExpertDocument;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.widgets.IndeterminateProgressMonitor;
import alma.obsprep.ot.editors.obsproject.QuerySourceEditor;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertEditor;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.util.GUIUtilities;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import lombok.NonNull;

public class CalibratorExpertController
implements ModelChangeSubscriber,
PropertyChangeListener {
    private static final DialogId id = new DialogId("CalibratorExpertController.search", "Problem encountered while searching for calibrators");
    private final CalibratorExpert calibrationExpert = CalibratorExpert.getInstance();
    private QueryTask queryTask;

    private static List<Measurement> getSolarSystemMeasurements() {
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        int n = 1;
        for (String string : FieldSource.getKnownSolarSystemObjectList()) {
            arrayList.add((Measurement)new SimpleMeasurement().name(string).sourceId(Integer.valueOf(n)));
            ++n;
        }
        return arrayList;
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        CalibratorExpertModel calibratorExpertModel = (CalibratorExpertModel)model;
        ICalibratorExpertDocument iCalibratorExpertDocument = (ICalibratorExpertDocument)calibratorExpertModel.getDocument();
        if (QuerySourceEditor.catlocFID.equals(fieldID)) {
            this.calibrationExpert.setCatalogueAccess(CalibratorExpert.SourceCatalog.byName(iCalibratorExpertDocument.getCatalogueLocation()));
        }
        if (QuerySourceEditor.filterFID.equals(fieldID)) {
            this.performRemoteCalibratorSearch(calibratorExpertModel, iCalibratorExpertDocument);
        }
        if (CalibratorExpertEditor.planetButtonFID.equals(fieldID)) {
            List<Measurement> list = CalibratorExpertController.getSolarSystemMeasurements();
            iCalibratorExpertDocument.setCalibList(list);
            calibratorExpertModel.publish(CalibratorExpertEditor.tableFID, list);
        }
    }

    private void performRemoteCalibratorSearch(@NonNull CalibratorExpertModel calibratorExpertModel, @NonNull ICalibratorExpertDocument iCalibratorExpertDocument) {
        if (calibratorExpertModel == null) {
            throw new NullPointerException("calibratorExpertModel is marked non-null but is null");
        }
        if (iCalibratorExpertDocument == null) {
            throw new NullPointerException("calibratorExpert is marked non-null but is null");
        }
        IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor(null, "Searching ALMA Catalogues", "", Dialog.ModalityType.APPLICATION_MODAL);
        indeterminateProgressMonitor.addPropertyChangeListener(this);
        this.calibrationExpert.setCatalogueAccess(CalibratorExpert.SourceCatalog.byName(iCalibratorExpertDocument.getCatalogueLocation()));
        this.queryTask = new QueryTask(calibratorExpertModel, iCalibratorExpertDocument.getQuery());
        this.queryTask.addPropertyChangeListener(indeterminateProgressMonitor);
        this.queryTask.execute();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("IPM_CANCELLED") && this.queryTask != null) {
            this.queryTask.cancel(true);
            this.queryTask.model.publish(CalibratorExpertEditor.tableFID, null);
        }
    }

    private class QueryTask
    extends SwingWorker<List<Measurement>, Void> {
        final CalibratorExpertModel model;
        final CatalogQueryParameters query;

        @Override
        protected List<Measurement> doInBackground() throws Exception {
            CalibratorExpertController.this.calibrationExpert.setCatalogsToQuery(new ArrayList<Integer>());
            return CalibratorExpertController.this.calibrationExpert.query(this.query);
        }

        @Override
        protected void done() {
            if (this.isCancelled() || !this.getState().equals((Object)SwingWorker.StateValue.DONE)) {
                return;
            }
            try {
                List list = (List)this.get();
                ICalibratorExpertDocument iCalibratorExpertDocument = (ICalibratorExpertDocument)this.model.getDocument();
                iCalibratorExpertDocument.setCalibList(list);
                this.model.publish(CalibratorExpertEditor.tableFID, list);
            }
            catch (Exception exception) {
                if (exception.getCause() instanceof IllegalArgumentException && exception.getCause().getMessage().contains("Connection error")) {
                    SwingUtilities.invokeLater(() -> {
                        GUIUtilities.info(id, "Could not contact catalogue server.\nPlease check your network connection.");
                        this.model.publish(CalibratorExpertEditor.tableFID, null);
                    });
                }
                exception.printStackTrace();
                SwingUtilities.invokeLater(() -> {
                    GUIUtilities.error(id, "Error while searching for calibrators", exception);
                    this.model.publish(CalibratorExpertEditor.tableFID, null);
                });
            }
        }

        public QueryTask(CalibratorExpertModel calibratorExpertModel, CatalogQueryParameters catalogQueryParameters) {
            this.model = calibratorExpertModel;
            this.query = catalogQueryParameters;
        }
    }
}

