/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.generator.refactored.RequestedArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class ScienceGoalConfigurations<T extends ConfigurationSet>
extends ArrayList<T> {
    private boolean isConfigurationsTruncated = false;

    public List<Configuration> getCompactConfigurations() {
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        for (ConfigurationSet configurationSet : this) {
            Optional<Configuration> optional = configurationSet.getTM2Configuration();
            if (!optional.isPresent()) continue;
            arrayList.add(optional.get());
        }
        return arrayList;
    }

    public List<Configuration> getExtendedConfigurations() {
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        for (ConfigurationSet configurationSet : this) {
            Optional<Configuration> optional = configurationSet.getTM1Configuration();
            if (!optional.isPresent()) continue;
            arrayList.add(optional.get());
        }
        return arrayList;
    }

    public Configuration getMostExtendedTM1Configuration() throws Configuration.UnableToDetermineConfigurationException {
        Configuration configuration = null;
        for (ConfigurationSet configurationSet : this) {
            Optional<Configuration> optional = configurationSet.getTM1Configuration();
            if (!optional.isPresent()) continue;
            Configuration configuration2 = optional.get();
            if (configuration != null && !(configuration2.getMaxBaseline() > configuration.getMaxBaseline())) continue;
            configuration = configuration2;
        }
        if (configuration == null) {
            throw new Configuration.UnableToDetermineConfigurationException("Unable to determine TM1 configurations");
        }
        return configuration;
    }

    public ConfigurationSet getConfigurationRequiringMostTime(RequestedArray requestedArray) {
        return ConfigurationSet.getConfigurationRequiringMostTime(this, requestedArray);
    }

    public Configuration getMostCompactTM2Configuration() throws Configuration.UnableToDetermineConfigurationException {
        if (this.isEmpty()) {
            throw new Configuration.UnableToDetermineConfigurationException("Unable to determine most compact TM2 configuration");
        }
        Configuration configuration = null;
        for (ConfigurationSet configurationSet : this) {
            Optional<Configuration> optional = configurationSet.getTM2Configuration();
            if (!optional.isPresent() || configuration != null && !(optional.get().getMaxBaseline() < configuration.getMaxBaseline())) continue;
            configuration = optional.get();
        }
        if (configuration == null) {
            throw new Configuration.UnableToDetermineConfigurationException("Unable to determine TM2 configurations");
        }
        return configuration;
    }

    public Configuration getMostCompactTM1Configuration() throws Configuration.UnableToDetermineConfigurationException {
        if (this.isEmpty()) {
            throw new Configuration.UnableToDetermineConfigurationException("Unable to determine most compact TM2 configuration");
        }
        Configuration configuration = null;
        for (ConfigurationSet configurationSet : this) {
            Optional<Configuration> optional = configurationSet.getTM1Configuration();
            if (!optional.isPresent() || configuration != null && !(optional.get().getMaxBaseline() < configuration.getMaxBaseline())) continue;
            configuration = optional.get();
        }
        if (configuration == null) {
            throw new Configuration.UnableToDetermineConfigurationException("Unable to determine TM1 configurations");
        }
        return configuration;
    }

    public Configuration getMostExtendedTM2Configuration() throws Configuration.UnableToDetermineConfigurationException {
        if (this.isEmpty()) {
            throw new Configuration.UnableToDetermineConfigurationException("Unable to determine most compact TM2 configuration");
        }
        Configuration configuration = null;
        for (ConfigurationSet configurationSet : this) {
            Optional<Configuration> optional = configurationSet.getTM2Configuration();
            if (!optional.isPresent() || configuration != null && !(optional.get().getMaxBaseline() > configuration.getMaxBaseline())) continue;
            configuration = optional.get();
        }
        if (configuration == null) {
            throw new Configuration.UnableToDetermineConfigurationException("Unable to determine TM2 configurations");
        }
        return configuration;
    }

    public Optional<ConfigurationSet> getMostTimeDemandingSolutionSet(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (scienceGoal.isStandAloneACA()) {
            throw new IllegalArgumentException("This method cannot handle SACA");
        }
        boolean bl = scienceGoal.getPerformanceParameters().isSimultaneous12and7Observation();
        Optional<ConfigurationSet> optional = Optional.empty();
        if (this.isEmpty()) {
            return optional;
        }
        double d = 0.0;
        for (ConfigurationSet configurationSet : this) {
            double d2;
            double d3;
            double d4;
            Configuration configuration = configurationSet.getTM1Configuration().orElse(Configuration.NO_CONFIG);
            double d5 = configurationSet.getTM1Configuration().orElse(Configuration.NO_CONFIG).getCompact12mMultiplier();
            double d6 = d4 = configurationSet.isTPRequired() ? configuration.getACATPMultiplier() : 0.0;
            if (bl) {
                d3 = configuration.getSimultaneous12mAnd7mMultiplier();
            } else {
                double d7 = d3 = configurationSet.isACA7mRequired() ? configuration.getACATPMultiplier() : 0.0;
            }
            if (!((d2 = d5 + d4 + d3) >= d)) continue;
            d = d2;
            optional = Optional.of(configurationSet);
        }
        return optional;
    }

    public boolean isConfigurationsTruncated() {
        return this.isConfigurationsTruncated;
    }

    public void setConfigurationsTruncated(boolean bl) {
        this.isConfigurationsTruncated = bl;
    }
}

