/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.util.Log;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.awt.geom.Point2D;
import lombok.NonNull;

public class Line {
    private final double length;
    private final Point2D.Double p1;
    private final Point2D.Double p2;

    public Line(double d, @NonNull Point2D.Double double_, @NonNull Point2D.Double double_2) {
        if (double_ == null) {
            throw new NullPointerException("p1 is marked non-null but is null");
        }
        if (double_2 == null) {
            throw new NullPointerException("p2 is marked non-null but is null");
        }
        this.length = d;
        this.p1 = double_;
        this.p2 = double_2;
    }

    final SkyCoordinates getRectangleCentre() {
        SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
        double d = (this.p1.getX() + this.p2.getX()) / 2.0;
        double d2 = (this.p1.getY() + this.p2.getY()) / 2.0;
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
        skyCoordinates.setLatitude(Latitude.createLatitude((double)d2, (String)Latitude.UNIT_ARCSEC));
        skyCoordinates.setLongitude(Longitude.createLongitude((double)d, (String)Latitude.UNIT_ARCSEC));
        return skyCoordinates;
    }

    final double getAngleOfLine() {
        if (this.length == 0.0) {
            return 0.0;
        }
        double d = Math.abs(this.p1.getY() - this.p2.getY());
        double d2 = Math.toDegrees(Math.asin(Math.abs(d / this.length)));
        double d3 = (this.p1.getY() - this.p2.getY()) / (this.p1.getX() - this.p2.getX());
        if (d3 < 0.0) {
            d2 *= -1.0;
        }
        Log.logger(Line.class).fine("Angle of the line degrees : " + d2);
        return d2;
    }

    public double getLength() {
        return this.length;
    }
}

