/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.common.sourcecatalog.Catalog;
import alma.common.sourcecatalog.CatalogAccess;
import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.Source;
import alma.common.sourcecatalog.SourceType;
import alma.common.sourcecatalog.flatfile.CatalogAccessFlatFile;
import alma.common.sourcecatalog.restful.CatalogAccessRESTful;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.util.GUIUtilities;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import lombok.NonNull;

public class CalibratorExpert
implements CatalogAccess {
    public static final Integer ALMACalibratorCatalogue = 5;
    private static final Log.Logger logger = Log.logger(CalibratorExpert.class);
    private static volatile CalibratorExpert instance;
    protected SourceCatalog catalog;
    @NonNull
    protected List<Integer> clientDefinedCataloguesToQuery = new ArrayList<Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CalibratorExpert getInstance() {
        if (instance != null) return instance;
        Class<CalibratorExpert> clazz = CalibratorExpert.class;
        synchronized (CalibratorExpert.class) {
            if (instance != null) return instance;
            instance = new CalibratorExpert();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected CalibratorExpert() {
        Log.logger((Object)this).log(Level.FINER, "CalibratorExpert: initialising the calibrator list");
    }

    public void setCatalogueAccess(SourceCatalog sourceCatalog) {
        if (this.catalog == null || !this.catalog.equals((Object)sourceCatalog)) {
            logger.log(Level.FINER, "Setting catalog to " + sourceCatalog.getName());
            this.catalog = sourceCatalog;
        }
    }

    public void setCatalogsToQuery(@NonNull List<Integer> list) {
        if (list == null) {
            throw new NullPointerException("catalogIds is marked non-null but is null");
        }
        this.clientDefinedCataloguesToQuery = list;
    }

    public List<Measurement> query(CatalogQueryParameters catalogQueryParameters) throws IOException {
        if (this.catalog == null) {
            return Collections.emptyList();
        }
        try {
            CatalogAccess catalogAccess = this.catalog.getCatalogAccess();
            if (!this.clientDefinedCataloguesToQuery.isEmpty()) {
                catalogAccess.setCatalogsToQuery(this.clientDefinedCataloguesToQuery);
            }
            return catalogAccess.query(catalogQueryParameters);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IOException iOException) {
            SwingUtilities.invokeLater(() -> GUIUtilities.error(null, "Could not contact the source catalogue server. Please try again later."));
        }
        return Collections.emptyList();
    }

    public Source getSource(Integer n) {
        if (this.catalog == null) {
            return null;
        }
        try {
            return this.catalog.getCatalogAccess().getSource(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public Collection<Catalog> listCatalogs() throws IOException {
        if (this.catalog == null) {
            return Collections.emptyList();
        }
        return this.catalog.getCatalogAccess().listCatalogs();
    }

    public Collection<String> listSortFields() throws IOException {
        if (this.catalog == null) {
            return Collections.emptyList();
        }
        return this.catalog.getCatalogAccess().listSortFields();
    }

    public Collection<SourceType> listTypes() throws IOException {
        if (this.catalog == null) {
            return Collections.emptyList();
        }
        return this.catalog.getCatalogAccess().listTypes();
    }

    public static String findJ2000NameOrDefault(List<String> list) {
        for (String string : list) {
            if (!string.startsWith("J")) continue;
            return string;
        }
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static enum SourceCatalog {
        ALMA("Online Catalog", (CatalogAccess)new CatalogAccessRESTful()),
        OFFLINE("Local File Catalog", (CatalogAccess)CatalogAccessFlatFile.getInstance());

        private static final String DEFAULT_URL = "https://asa.alma.cl/sc/rest/";
        private static boolean offlineEnabled;
        private final String name;
        private final CatalogAccess catalogAccess;
        private static final Set<SourceCatalog> ALL_CATALOGS;

        private SourceCatalog(String string2, CatalogAccess catalogAccess) {
            if (catalogAccess instanceof CatalogAccessRESTful) {
                CatalogAccessRESTful catalogAccessRESTful = (CatalogAccessRESTful)catalogAccess;
                try {
                    String string3 = System.getProperty("sourcecat.url", DEFAULT_URL);
                    URL uRL = new URL(string3);
                    catalogAccessRESTful.setEndpoint(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    logger.log(Level.SEVERE, "Invalid source catalogue URL", (Throwable)malformedURLException);
                    malformedURLException.printStackTrace();
                }
            }
            this.name = string2;
            this.catalogAccess = catalogAccess;
        }

        public static SourceCatalog byName(String string) {
            for (SourceCatalog sourceCatalog : ALL_CATALOGS) {
                if (!sourceCatalog.getName().equals(string)) continue;
                return sourceCatalog;
            }
            return null;
        }

        public static String[] getNames() {
            EnumSet<SourceCatalog> enumSet = EnumSet.copyOf(ALL_CATALOGS);
            if (!offlineEnabled) {
                enumSet.remove((Object)OFFLINE);
            }
            String[] stringArray = new String[enumSet.size()];
            Iterator iterator = enumSet.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n++] = ((SourceCatalog)((Object)iterator.next())).getName();
            }
            return stringArray;
        }

        public static void setEnableOfflineCatalogAccess(boolean bl) {
            offlineEnabled = bl;
        }

        public String getName() {
            return this.name;
        }

        public CatalogAccess getCatalogAccess() {
            return this.catalogAccess;
        }

        static {
            offlineEnabled = false;
            ALL_CATALOGS = EnumSet.allOf(SourceCatalog.class);
        }
    }
}

