/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import lombok.NonNull;

public class DGCReferenceCalObs
extends CalObs {
    private final Flux ZERO_FLUX = Flux.createFlux();

    public DGCReferenceCalObs() {
        this.setCalType(CalType.DGCReference);
        this.setNoOfAtmCalsToBePerformed(0);
        this.setIncludedInTimeEstimateAccounting(false);
    }

    public DGCReferenceCalObs(@NonNull ScienceGoal scienceGoal) {
        this();
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        this.scienceGoal = scienceGoal;
        this.configure();
    }

    @Override
    public boolean atmCalRequired(SchedBlock schedBlock) {
        return false;
    }

    @Override
    public Frequency getDefaultChannelWidth() {
        if (this.scienceGoal == null || this.scienceGoal.getSpectralSetupParameters().getAbstractScienceSpectralWindowCount() == 0) {
            return Frequency.createFrequencyMHZ(0.48828125);
        }
        return this.scienceGoal.getSpectralSetupParameters().getStringentSpectralWindow().getBandWidth().deepCopy();
    }

    @Override
    public Flux getDefaultFlux() {
        return this.ZERO_FLUX;
    }

    @Override
    public double getDefaultSNR() {
        return 0.0;
    }

    @Override
    public Time calTime() {
        if (this.SBSuggestedCalibrationDefaultIntegrationTime != null) {
            return this.SBSuggestedCalibrationDefaultIntegrationTime;
        }
        return DGCReferenceCalObs.getCalObsProperties().getDGCReferenceCycleTime();
    }

    @Override
    public Time rawCycleTime() {
        if (this.SBSuggestedCalibrationCycleTime != null) {
            return this.SBSuggestedCalibrationCycleTime;
        }
        return DGCReferenceCalObs.getCalObsProperties().getDGCReferenceCycleTime();
    }
}

