/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.services.calibration.CalTimeData;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Temperature;
import alma.valuetypes.Time;

public class CalTimeCalculator {
    private static final double BOLTZMANN = 1.38E-23;

    public static Time rawCalTime(CalTimeData calTimeData) throws InvalidFrequencyException, SourceNeverVisibleException {
        double d = calTimeData.getChannelWidth().getContentInUnits(Frequency.UNIT_HZ);
        double d2 = calTimeData.getTsys().getContentInUnits(Temperature.UNIT_K);
        double d3 = calTimeData.getCalibratorFlux().getContentInUnits(Flux.UNIT_JY);
        double d4 = d3 * 1.0E-26;
        int n = calTimeData.getNoOfAntennas();
        double d5 = 1.38E-23 * d2;
        double d6 = calTimeData.getCorrelatorEfficiency();
        double d7 = calTimeData.getEffectiveApertureArea();
        d5 /= d6 * d7 * d4;
        d5 *= calTimeData.getSNR();
        d5 *= d5;
        return Time.createTimeSec(d5 *= 2.0 / d / (double)(n - 1));
    }
}

