/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.roledirectory;

import alma.obsprep.roledirectory.OTOperation;
import alma.obsprep.roledirectory.RoleDirectory;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;

public class WebServiceRoleDirectory
implements RoleDirectory {
    public static final int CONNECTION_TIMEOUT = 10000;
    public static final int TRANSACTION_TIMEOUT = 10000;
    private URL webappUrl;
    private String username = "";
    private String password = "";
    private boolean authenticated = false;

    public void setWebappUrl(URL uRL) {
        this.webappUrl = uRL;
        this.authenticated = false;
    }

    public boolean login() throws IOException {
        this.authenticated = false;
        this.authenticated = this.canExecute(OTOperation.IS_AUTHENTICATED);
        return this.authenticated;
    }

    public void setCredentials(String string, String string2) {
        this.username = string;
        this.password = string2;
    }

    @Override
    public boolean canExecute(OTOperation oTOperation) throws IOException {
        URL uRL;
        GetMethod getMethod;
        HttpClient httpClient = this.getHttpClient();
        int n = httpClient.executeMethod((HttpMethod)(getMethod = new GetMethod((uRL = oTOperation.getURL(this.webappUrl)).toString())));
        if (200 == n) {
            return true;
        }
        if (403 == n || 401 == n) {
            return false;
        }
        if (404 == n) {
            throw new IOException("Expected roles not found. Please update your server.");
        }
        throw new IOException("Unexpected response from web service: " + n + " " + HttpStatus.getStatusText((int)n));
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    private HttpClient getHttpClient() {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter("http.socket.timeout", (Object)10000);
        httpClient.getParams().setParameter("http.connection.timeout", (Object)10000);
        httpClient.getParams().setAuthenticationPreemptive(true);
        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.username, this.password);
        AuthScope authScope = new AuthScope(this.webappUrl.getHost(), this.webappUrl.getPort());
        httpClient.getState().setCredentials(authScope, (Credentials)usernamePasswordCredentials);
        return httpClient;
    }

    public static void main(String[] stringArray) throws Exception {
        WebServiceRoleDirectory webServiceRoleDirectory = new WebServiceRoleDirectory();
        webServiceRoleDirectory.setWebappUrl(new URL("http://192.168.56.101:8180/ObsprepSubmissionService"));
        webServiceRoleDirectory.setCredentials("john", "john");
        webServiceRoleDirectory.login();
        System.out.println(webServiceRoleDirectory.isAuthenticated());
        System.out.println(webServiceRoleDirectory.canExecute(OTOperation.SERVICE_PING));
        System.out.println(webServiceRoleDirectory.canExecute(OTOperation.CREATE_OBSERVATORY_GOAL));
        webServiceRoleDirectory.setCredentials("paul", "paul");
        webServiceRoleDirectory.login();
        System.out.println(webServiceRoleDirectory.isAuthenticated());
        System.out.println(webServiceRoleDirectory.canExecute(OTOperation.SERVICE_PING));
        System.out.println(webServiceRoleDirectory.canExecute(OTOperation.CREATE_OBSERVATORY_GOAL));
    }
}

