/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.obsproject.WeatherConstraints;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.Angle;

public class WeatherConstraintsValidator
extends AbstractValidator {
    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        WeatherConstraints weatherConstraints = (WeatherConstraints)businessObject;
        if (weatherConstraints.getPhaseStability().getContentInUnits(Angle.UNIT_DEG) <= 0.0) {
            problem = DefaultProblem.createError("Requested phase stability is invalid", "Set the phase stability required to a sensible value", (IBusinessObject)weatherConstraints);
            problemListModel.add(problem);
        }
        if (weatherConstraints.getSeeing().getContentInUnits(Angle.UNIT_DEG) <= 0.0) {
            problem = DefaultProblem.createError("Requested seeing is invalid", "Set the seeing required to a sensible value", (IBusinessObject)weatherConstraints);
            problemListModel.add(problem);
        }
        if (weatherConstraints.getMaxPWVC().getContentInDefaultUnits() <= 0.0) {
            problem = DefaultProblem.createError("Requested maximum PWVC is invalid", "Set the maximum PWVC required to a sensible value", (IBusinessObject)weatherConstraints);
            problemListModel.add(problem);
        }
        if (weatherConstraints.getMaxWindVelocity().getContentInDefaultUnits() <= 0.0) {
            problem = DefaultProblem.createError("Requested maximum wind speed is invalid", "Set the maximum wind speed required to a sensible value", (IBusinessObject)weatherConstraints);
            problemListModel.add(problem);
        }
    }
}

