/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.common.horizonsparser.HorizonParser;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.BOUtilities;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractSwitchingCycle;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.BeamSwitchingCycle;
import alma.obsprep.bo.schedblock.BeamSwitchingState;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.FrequencySwitchingCycle;
import alma.obsprep.bo.schedblock.FrequencySwitchingState;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowPair;
import alma.obsprep.bo.schedblock.SquareLawSetup;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.obsproject.SpectralSetupParametersValidator;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.util.OTHorizonParser;
import alma.obsprep.util.OTLoggerAdapter;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import com.formdev.flatlaf.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.math3.util.Precision;

public class SpectralSpecValidator
extends AbstractValidator {
    public static final Frequency BASEBAND_EDGE_MARGIN = Frequency.createFrequencyMHZ(30.0);
    public static final Frequency LO_BASEBAND_NOISE_REGION = (Frequency)Frequency.createFrequencyGHZ(2.0).plus((AbstractDoubleWithUnit)BASEBAND_EDGE_MARGIN);
    public static final Frequency HI_BASEBAND_NOISE_REGION = (Frequency)Frequency.createFrequencyGHZ(4.0).minus((AbstractDoubleWithUnit)BASEBAND_EDGE_MARGIN);
    public static final String MOVE_BASEBANDS_FURTHER_AWAY_FROM_THE_EDGE_OF_THE_FREQUENCY_BAND = "Move spws/basebands further away from the edge of the frequency band.";
    public static final String MOVE_THE_SPW_AWAY_FROM_THE_BASEBAND_EDGE_TO_AVOID_THIS_PROBLEM = "Move the spw away from the baseband edge to avoid this problem.";
    public static final String SPEC_WINDOW_HAS_CENTRE_SET_NEAR_OR_OUTSIDE_ANTI_ALIASING_FILTER = "Spec. window has centre set near or outside anti-aliasing filter";
    private static final Speed EARTH_SIDEREAL_DOPPLER_SPEED = Speed.createSpeed((double)32.0, (String)Speed.UNIT_KM_S);
    private static final Speed EARTH_NON_SIDEREAL_DOPPLER_SPEED = Speed.createSpeed((double)45.0, (String)Speed.UNIT_KM_S);
    private static final Frequency MHZ_120_TOLERANCE = Frequency.createFrequencyMHZ(120.0);

    public SpectralSpecValidator() {
        this.setValidatorThreadSafe(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        SpectralSpec spectralSpec = (SpectralSpec)businessObject;
        assert (spectralSpec != null);
        if (spectralSpec.getUsedCount() == 0) {
            problem = DefaultProblem.createWarning("Spectral spec. " + spectralSpec.getName() + " is not used by any target", " ", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        this.checkSwitchingCycle(problemListModel, spectralSpec);
        this.checkSquareLawSetup(businessObject, problemListModel, spectralSpec);
        try {
            this.checkSPWsDoNotInfringeBasebandAntiAliasingRegion(businessObject, problemListModel, spectralSpec);
        }
        catch (UnableToCheckAntiAliasingRegionException unableToCheckAntiAliasingRegionException) {
            Log.logger(SpectralSpecValidator.class).warning("Unable to validate that SPWs do not infringe baseband edges: " + unableToCheckAntiAliasingRegionException.getMessage());
        }
        SpectralSpecTuningValidationResult spectralSpecTuningValidationResult = new SpectralSpecTuningValidationResult();
        boolean bl = true;
        boolean bl2 = false;
        List<Target> list = null;
        try {
            list = spectralSpec.getObservingGroupDopplerTargetsForSpectralSpec();
            if (list.isEmpty()) {
                list = spectralSpec.locateAllDopplerTargetInSB().orElse(List.of(spectralSpec.getSchedBlock().getSchedulingConstraints().getRepresentativeTarget()));
            }
        }
        catch (SpectralSpec.SpectralSpecAncestorIsAnObservatoryGoalException spectralSpecAncestorIsAnObservatoryGoalException) {
            list = null;
            bl2 = true;
        }
        catch (SpectralSpec.NoAbstractScienceGoalFoundAsParentException noAbstractScienceGoalFoundAsParentException) {
            list = null;
            bl = false;
        }
        if (!bl) {
            return;
        }
        assert (bl);
        boolean bl3 = spectralSpec.getFrequencySetup().getDopplerReference().equals(FrequencySetup.DOPPLERREFERENCE_REST);
        for (Target target : spectralSpec.getTargetList()) {
            if (target.hasScienceParameters()) {
                boolean bl4;
                Velocity velocity = Velocity.createVelocity();
                boolean bl5 = bl4 = !list.isEmpty();
                if (bl3) {
                    if (bl4) {
                        for (Target target2 : list) {
                            FieldSource fieldSource = target2.getFieldSource();
                            assert (fieldSource != null);
                            velocity = fieldSource.getSourceVelocityInReferenceFrame();
                            Log.logger(SpectralSpecValidator.class).fine(String.format("Validating spectral spec %s against velocity %s from doppler target %s", spectralSpec.getName(), velocity.getCenterVelocity().toString(), fieldSource.getSourceName()));
                            this.validateSpectralSpecTunings(spectralSpec, velocity, spectralSpecTuningValidationResult);
                            this.validateBasebandRxBandEdgeInfringementDueToEarthDoppler(fieldSource, spectralSpec, velocity, spectralSpecTuningValidationResult);
                        }
                        continue;
                    }
                    if (bl2) {
                        void var17_25;
                        Target target2 = spectralSpec.getSchedBlock().getSchedulingConstraints().getRepresentativeTarget();
                        Object var17_23 = null;
                        if (target2 != null) {
                            FieldSource fieldSource = target2.getFieldSource();
                        }
                        velocity = var17_25 == null ? Velocity.createVelocity() : var17_25.getSourceVelocityInReferenceFrame();
                        this.validateSpectralSpecTunings(spectralSpec, velocity, spectralSpecTuningValidationResult);
                        this.validateBasebandRxBandEdgeInfringementDueToEarthDoppler((FieldSource)var17_25, spectralSpec, velocity, spectralSpecTuningValidationResult);
                        continue;
                    }
                    Log.logger(SpectralSpecValidator.class).warning(String.format("Unable to determine representative target/doppler target associated with spectral spec %s", spectralSpec.getName()));
                    continue;
                }
                this.validateSpectralSpecTunings(spectralSpec, velocity, spectralSpecTuningValidationResult);
                this.validateBasebandRxBandEdgeInfringementDueToEarthDoppler(target.getFieldSource(), spectralSpec, velocity, spectralSpecTuningValidationResult);
                continue;
            }
            this.checkCalibratorSpectralSpec(spectralSpec, spectralSpecTuningValidationResult, bl2, list);
        }
        if (!spectralSpecTuningValidationResult.isValidationOkay()) {
            problem = DefaultProblem.createError("Spectral spec. " + spectralSpec.getName() + " does not have a valid LO solution for all its science targets", "Test its LO setup against each target that uses it", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (spectralSpecTuningValidationResult.isBasebandNotInReceiverBand()) {
            problem = DefaultProblem.createWarning("Spectral spec. " + spectralSpec.getName() + " may fail during execution due to the Earth's motion", MOVE_BASEBANDS_FURTHER_AWAY_FROM_THE_EDGE_OF_THE_FREQUENCY_BAND, (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!spectralSpecTuningValidationResult.isCalibrationSetupOkay()) {
            problem = DefaultProblem.createWarning("Cal target Spectral spec. " + spectralSpec.getName() + " does not have a valid LO solution", "Check its LO setup", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        SpectralSpecValidator.checkSPWCentreFrequenciesCoincideWithPhase1(Optional.of(new ValidationDetails(businessObject, problemListModel)), spectralSpec);
    }

    private void checkCalibratorSpectralSpec(SpectralSpec spectralSpec, SpectralSpecTuningValidationResult spectralSpecTuningValidationResult, boolean bl, List<Target> list) {
        boolean bl2 = spectralSpec.getFrequencySetup().getDopplerReference() == FrequencySetup.DOPPLERREFERENCE_REST;
        boolean bl3 = !list.isEmpty();
        Velocity velocity = Velocity.createVelocity();
        if (bl2) {
            if (bl3) {
                for (Target target : list) {
                    velocity = target.getFieldSource().getSourceVelocityInReferenceFrame();
                    this.validateSpectralSpecForCalibrator(spectralSpec, velocity, spectralSpecTuningValidationResult);
                }
            } else if (bl) {
                Target target = spectralSpec.getSchedBlock().getSchedulingConstraints().getRepresentativeTarget();
                FieldSource fieldSource = null;
                if (target != null) {
                    fieldSource = target.getFieldSource();
                }
                velocity = fieldSource == null ? Velocity.createVelocity() : fieldSource.getSourceVelocityInReferenceFrame();
                this.validateSpectralSpecForCalibrator(spectralSpec, velocity, spectralSpecTuningValidationResult);
            }
        } else {
            this.validateSpectralSpecForCalibrator(spectralSpec, velocity, spectralSpecTuningValidationResult);
        }
    }

    private void checkSPWsDoNotInfringeBasebandAntiAliasingRegion(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull SpectralSpec spectralSpec) throws UnableToCheckAntiAliasingRegionException {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        AbstractScienceGoal abstractScienceGoal = BOUtilities.findScienceGoal((BusinessObject)spectralSpec);
        assert (abstractScienceGoal != null);
        if (abstractScienceGoal instanceof ScienceGoal) {
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            SchedBlock schedBlock = spectralSpec.getSchedBlock();
            assert (schedBlock != null);
            List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
            if (list.isEmpty()) {
                return;
            }
            List<String> list2 = list.stream().map(target -> target.getFieldSource().getSourceName()).toList();
            Frequency frequency = Frequency.createFrequencyMHZ(Arrays.stream(scienceGoal.getTargetParameters()).filter(targetParameters -> list2.stream().filter(string -> string.equals(targetParameters.getSourceName())).findFirst().isPresent()).mapToDouble(SpectralSetupParametersValidator::getLineWidthInMHz).max().orElseThrow(() -> new UnableToCheckAntiAliasingRegionException("Unable to calculate the max line width")));
            boolean bl = SpectralSpecValidator.validateBasebandEdgeInfringementbySPWs(businessObject, problemListModel, spectralSpec, false);
            if (bl) {
                Problem problem = DefaultProblem.createWarning(SPEC_WINDOW_HAS_CENTRE_SET_NEAR_OR_OUTSIDE_ANTI_ALIASING_FILTER, "Signal to noise will be lower than expected. See Technical Handbook for more details.", (IBusinessObject)businessObject);
                problemListModel.addUnpublishedProblem(problem);
            }
        }
    }

    private void checkSquareLawSetup(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSpec spectralSpec) {
        if (spectralSpec.hasSquareLawSetup()) {
            SquareLawSetup squareLawSetup = spectralSpec.getSquareLawSetup();
            double d = squareLawSetup.getIntegrationDuration().getContentInUnits(Time.UNIT_MS);
            if (squareLawSetup.getIntegrationDuration().isZero() || d % 0.5 != 0.0) {
                Problem problem = DefaultProblem.createError("Square law setup in instrument setup " + businessObject.getName() + " has an illegal integration duration ", "The integration duration must be a positive multiple of 0.5 ms", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
    }

    private void checkSwitchingCycle(ProblemListModel problemListModel, SpectralSpec spectralSpec) {
        block13: {
            Problem problem;
            AbstractSwitchingCycle abstractSwitchingCycle;
            block14: {
                abstractSwitchingCycle = spectralSpec.getAbstractSwitchingCycle();
                String string = null;
                if (abstractSwitchingCycle != null) {
                    if (abstractSwitchingCycle instanceof FrequencySwitchingCycle) {
                        string = SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING;
                    } else if (abstractSwitchingCycle instanceof BeamSwitchingCycle) {
                        string = SpectralSpec.SWITCHINGTYPE_NUTATOR_SWITCHING;
                    }
                } else {
                    string = SpectralSpec.SWITCHINGTYPE_NO_SWITCHING;
                }
                if (!spectralSpec.getSwitchingType().equals(string)) {
                    problem = DefaultProblem.createError("Expected switching type '" + string + "' doesn't match the inner switching cycle type", "The OT should automatically set this for you", (IBusinessObject)spectralSpec);
                    problemListModel.add(problem);
                }
                if (abstractSwitchingCycle == null) break block13;
                if (!(abstractSwitchingCycle instanceof FrequencySwitchingCycle)) break block14;
                FrequencySwitchingCycle frequencySwitchingCycle = (FrequencySwitchingCycle)((Object)abstractSwitchingCycle);
                if (frequencySwitchingCycle.getFrequencySwitchingState().length == 0) {
                    problem = DefaultProblem.createWarning("No frequency switching states specified", "Add the necessary frequency switching states", (IBusinessObject)abstractSwitchingCycle);
                    problemListModel.add(problem);
                } else {
                    for (FrequencySwitchingState frequencySwitchingState : frequencySwitchingCycle.getFrequencySwitchingState()) {
                        if (frequencySwitchingState.getBin() > 0) continue;
                        problem = DefaultProblem.createError("Switching state bins should be natural numbers", "Bin values should start from 1", (IBusinessObject)frequencySwitchingState);
                        problemListModel.add(problem);
                    }
                }
                break block13;
            }
            if (!(abstractSwitchingCycle instanceof BeamSwitchingCycle)) break block13;
            BeamSwitchingCycle beamSwitchingCycle = (BeamSwitchingCycle)((Object)abstractSwitchingCycle);
            if (beamSwitchingCycle.getBeamSwitchingState().length == 0) {
                problem = DefaultProblem.createWarning("No beam switching states specified", "Add the necessary beam switching states", (IBusinessObject)abstractSwitchingCycle);
                problemListModel.add(problem);
            } else {
                for (BeamSwitchingState beamSwitchingState : beamSwitchingCycle.getBeamSwitchingState()) {
                    double d;
                    if (beamSwitchingState.getBin() <= 0) {
                        problem = DefaultProblem.createError("Switching state bins should be natural numbers", "Bin values should start from 1", (IBusinessObject)beamSwitchingState);
                        problemListModel.add(problem);
                    }
                    if (this.isMultiple(d = beamSwitchingState.getDwellTime().getContentInUnits(Time.UNIT_MS), 48.0, 0.0)) continue;
                    problem = DefaultProblem.createError("Dwell time is not multiple of 48 [ms]", "Dwell times should be multiples of 48 [ms]", (IBusinessObject)beamSwitchingState);
                    problemListModel.add(problem);
                }
            }
        }
    }

    private void validateBasebandRxBandEdgeInfringementDueToEarthDoppler(FieldSource fieldSource, @NonNull SpectralSpec spectralSpec, @NonNull Velocity velocity, @NonNull SpectralSpecTuningValidationResult spectralSpecTuningValidationResult) {
        boolean bl;
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        if (velocity == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        if (spectralSpecTuningValidationResult == null) {
            throw new NullPointerException("validationReport is marked non-null but is null");
        }
        if (fieldSource != null && fieldSource.getSourceVelocity().isTopocentric()) {
            return;
        }
        Log.logger(SpectralSpecValidator.class).fine("validateBasebandRxBandEdgeInfringementDueToEarthDoppler processing : " + spectralSpec.getName());
        boolean bl2 = bl = fieldSource != null && fieldSource.getNonSiderealMotion();
        if (bl || !spectralSpec.getFrequencySetup().getDopplerReference().equals(FrequencySetup.DOPPLERREFERENCE_TOPO)) {
            EarthDoppler earthDoppler = new EarthDoppler(this);
            if (bl) {
                earthDoppler = this.determineNonSiderealDopplerFactor(fieldSource);
            }
            Velocity velocity2 = null;
            Velocity velocity3 = null;
            if (earthDoppler.getPositiveSpeed() != null) {
                velocity2 = Velocity.createVelocity();
                velocity2.setCenterVelocity(earthDoppler.getPositiveSpeed());
                velocity2.setReferenceSystem(velocity.getReferenceSystem());
                velocity2.setDopplerCalcType(velocity.getDopplerCalcType());
            }
            if (earthDoppler.getNegativeSpeed() != null) {
                velocity3 = Velocity.createVelocity();
                velocity3.setCenterVelocity(earthDoppler.getNegativeSpeed());
                velocity3.setReferenceSystem(velocity.getReferenceSystem());
                velocity3.setDopplerCalcType(velocity.getDopplerCalcType());
            }
            ReceiverBand receiverBand = spectralSpec.getReceiverBand();
            double d = ((Frequency)((Object)receiverBand.getRFRange().min())).getContentInGHz();
            double d2 = ((Frequency)((Object)receiverBand.getRFRange().max())).getContentInGHz();
            spectralSpec.setLOInSpectralSpec(velocity, false);
            for (BaseBandSpecification baseBandSpecification : spectralSpec.getBaseBandSpecification()) {
                double d3;
                Frequency frequency = baseBandSpecification.getActualBaseBandCenterFrequencySky();
                Frequency frequency2 = (Frequency)baseBandSpecification.getBandwidth().half();
                if (velocity2 != null && Math.abs(d3 = ((Frequency)frequency.dopplerShifted(velocity2).minus((AbstractDoubleWithUnit)frequency2)).getContentInGHz()) < d) {
                    spectralSpecTuningValidationResult.setBasebandNotInReceiverBand(true);
                }
                if (velocity3 == null) continue;
                d3 = ((Frequency)frequency.dopplerShifted(velocity3).plus((AbstractDoubleWithUnit)frequency2)).getContentInGHz();
                Log.logger(SpectralSpecValidator.class).fine(spectralSpec.getName() + "-ve earth doppler delta_nu " + d3 + " maxReceiverFreqRangeGHz " + d2);
                if (!(Math.abs(d3) > d2)) continue;
                spectralSpecTuningValidationResult.setBasebandNotInReceiverBand(true);
            }
        }
    }

    private EarthDoppler determineNonSiderealDopplerFactor(@NonNull FieldSource fieldSource) {
        if (fieldSource == null) {
            throw new NullPointerException("dopplerFieldSource is marked non-null but is null");
        }
        EarthDoppler earthDoppler = new EarthDoppler(this);
        String string = fieldSource.getSourceEphemeris();
        if (fieldSource.isEphemerisSource() && !StringUtils.isEmpty((String)string)) {
            List list;
            Object object;
            earthDoppler.clearDopplerSpeeds();
            try {
                object = new OTHorizonParser(new OTLoggerAdapter(Log.logger((Object)this), this.getClass().getName(), null), string);
                list = object.parseEphemeris();
            }
            catch (HorizonParser.UnableToParseEphemerisDataException | IOException throwable) {
                Log.logger(SpectralSpecValidator.class).warning("Unable to parse ephemeris " + throwable.getMessage());
                return earthDoppler;
            }
            object = Speed.createSpeed((double)list.stream().mapToDouble(parsedEphemerisLine -> parsedEphemerisLine.deltaDot).max().orElse(EARTH_NON_SIDEREAL_DOPPLER_SPEED.getContentInUnits(Speed.UNIT_M_S)), (String)Speed.UNIT_M_S);
            earthDoppler.setPositiveSpeed((Speed)((Object)(object.getContentInDefaultUnits() > 0.0 ? object : null)));
            Speed speed = Speed.createSpeed((double)list.stream().mapToDouble(parsedEphemerisLine -> parsedEphemerisLine.deltaDot).min().orElse(((Speed)EARTH_NON_SIDEREAL_DOPPLER_SPEED.multiply(-1.0)).getContentInUnits(Speed.UNIT_M_S)), (String)Speed.UNIT_M_S);
            earthDoppler.setNegativeSpeed(speed.getContentInDefaultUnits() < 0.0 ? speed : null);
        } else {
            earthDoppler.setNegativeSpeed((Speed)EARTH_NON_SIDEREAL_DOPPLER_SPEED.multiply(-1.0));
            earthDoppler.setPositiveSpeed(EARTH_NON_SIDEREAL_DOPPLER_SPEED.deepCopy());
        }
        return earthDoppler;
    }

    private void validateSpectralSpecForCalibrator(SpectralSpec spectralSpec, Velocity velocity, SpectralSpecTuningValidationResult spectralSpecTuningValidationResult) {
        if (!(spectralSpec.getBaseBandConfigCount() <= 0 || spectralSpec.setLOInSpectralSpec(velocity) && spectralSpec.getFeedbackInfo() == null)) {
            spectralSpecTuningValidationResult.setCalibrationSetupOkay(false);
        }
    }

    private void validateSpectralSpecTunings(SpectralSpec spectralSpec, Velocity velocity, SpectralSpecTuningValidationResult spectralSpecTuningValidationResult) {
        if (!(spectralSpec.getBaseBandConfigCount() <= 0 || spectralSpec.setLOInSpectralSpec(velocity) && spectralSpec.getFeedbackInfo() == null)) {
            spectralSpecTuningValidationResult.setValidationOkay(false);
        }
    }

    public static boolean validateBasebandEdgeInfringementbySPWs(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull SpectralSpec spectralSpec, boolean bl) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        HashSet hashSet = new HashSet();
        Frequency frequency = Frequency.createFrequencyGHZ(1.875);
        for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
            if (abstractBaseBandConfig == null) continue;
            Arrays.stream(abstractBaseBandConfig.getSpectralWindow()).filter(spectralWindowI -> spectralWindowI.getEffectiveBandwidth().isLessThanOrEqualTo((AbstractDoubleWithUnit)frequency)).forEach(spectralWindowI -> {
                Problem problem;
                String string;
                boolean bl2 = bl && spectralWindowI.isRepresentativeWindow();
                boolean bl3 = false;
                Frequency frequency = spectralWindowI.getCenterFrequency();
                ScienceSpectralWindow scienceSpectralWindow = spectralWindowI.getScienceSpectralWindow();
                String string2 = bl ? scienceSpectralWindow.getTransitionName() : spectralWindowI.getSpectralWindowName();
                Frequency frequency2 = (Frequency)spectralWindowI.getEffectiveBandwidth().half(true);
                Frequency frequency3 = (Frequency)frequency.plus((AbstractDoubleWithUnit)frequency2);
                Frequency frequency4 = (Frequency)frequency.minus((AbstractDoubleWithUnit)frequency2);
                String string3 = " lies within 30 MHz of the baseband edge. This could result in compromised flux calibration and spurious signals.";
                if (frequency4.isLessThanOrEqualTo((AbstractDoubleWithUnit)LO_BASEBAND_NOISE_REGION) || frequency3.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)HI_BASEBAND_NOISE_REGION)) {
                    string = "Part of spw " + string2 + " in BB " + (abstractBaseBandConfig.getBaseBandIndex() + 1) + " lies within 30 MHz of the baseband edge. This could result in compromised flux calibration and spurious signals.";
                    problem = bl2 ? DefaultProblem.createError(string, MOVE_THE_SPW_AWAY_FROM_THE_BASEBAND_EDGE_TO_AVOID_THIS_PROBLEM, (IBusinessObject)businessObject) : DefaultProblem.createWarning(string, MOVE_THE_SPW_AWAY_FROM_THE_BASEBAND_EDGE_TO_AVOID_THIS_PROBLEM, (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                    hashSet.add(Boolean.TRUE);
                    bl3 = true;
                }
                if (!bl3) {
                    if (LO_BASEBAND_NOISE_REGION.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency)) {
                        string = "Most of spw " + string2 + " in BB " + (abstractBaseBandConfig.getBaseBandIndex() + 1) + " lies within 30 MHz of the baseband edge. This could result in compromised flux calibration and spurious signals.";
                        problem = bl2 ? DefaultProblem.createError(string, MOVE_THE_SPW_AWAY_FROM_THE_BASEBAND_EDGE_TO_AVOID_THIS_PROBLEM, (IBusinessObject)businessObject) : DefaultProblem.createWarning(string, MOVE_THE_SPW_AWAY_FROM_THE_BASEBAND_EDGE_TO_AVOID_THIS_PROBLEM, (IBusinessObject)businessObject);
                        problemListModel.add(problem);
                        bl3 = true;
                        hashSet.add(Boolean.TRUE);
                    }
                    if (HI_BASEBAND_NOISE_REGION.isLessThanOrEqualTo((AbstractDoubleWithUnit)frequency)) {
                        string = "Most of spw " + string2 + " in BB " + (abstractBaseBandConfig.getBaseBandIndex() + 1) + " lies within 30 MHz of the baseband edge. This could result in compromised flux calibration and spurious signals.";
                        problem = bl2 ? DefaultProblem.createError(string, MOVE_THE_SPW_AWAY_FROM_THE_BASEBAND_EDGE_TO_AVOID_THIS_PROBLEM, (IBusinessObject)businessObject) : DefaultProblem.createWarning(string, MOVE_THE_SPW_AWAY_FROM_THE_BASEBAND_EDGE_TO_AVOID_THIS_PROBLEM, (IBusinessObject)businessObject);
                        problemListModel.add(problem);
                        hashSet.add(Boolean.TRUE);
                        bl3 = true;
                    }
                }
            });
        }
        return hashSet.contains(Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkSPWCentreFrequenciesCoincideWithPhase1(@NonNull Optional<ValidationDetails> optional, @NonNull SpectralSpec spectralSpec) {
        ScienceGoal scienceGoal;
        boolean bl;
        block14: {
            if (optional == null) {
                throw new NullPointerException("validationDetails is marked non-null but is null");
            }
            if (spectralSpec == null) {
                throw new NullPointerException("spectralSpec is marked non-null but is null");
            }
            bl = true;
            scienceGoal = null;
            try {
                scienceGoal = (ScienceGoal)((Object)spectralSpec.getGeneratingScienceGoal());
            }
            catch (SpectralSpec.NoAbstractScienceGoalFoundAsParentException noAbstractScienceGoalFoundAsParentException) {
                Log.logger(SpectralSpecValidator.class).warning("No generating SG found");
            }
            finally {
                if (scienceGoal != null) break block14;
                Log.logger(SpectralSpecValidator.class).warning("No generating SG found");
                return true;
            }
        }
        if (scienceGoal.isSpectralScan()) {
            return true;
        }
        SchedBlock schedBlock = spectralSpec.getSchedBlock();
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).stream().filter(target -> target.getSpectralSpec().equals(spectralSpec)).toList();
        if (list.isEmpty()) {
            return true;
        }
        Target target2 = list.get(0);
        Optional<ObservingGroup> optional2 = Stream.of(schedBlock.getObservingGroup()).filter(observingGroup -> observingGroup.getAllOrderedTargets(ScienceParameters.scienceParametersFilter).stream().anyMatch(target2 -> target2.equals(target2))).findFirst();
        if (optional2.isEmpty()) {
            Log.logger(SpectralSpecValidator.class).warning("The OG of the target could not be determined.");
            return true;
        }
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        boolean bl2 = spectralSetupParameters.isSpectralLine();
        Target target3 = optional2.get().getMainTarget();
        List<SPWComparisonDetails> list2 = SpectralSpecValidator.getPhase2SPWCentralFrequencies(spectralSpec);
        Velocity velocity = Velocity.createVelocity();
        if (bl2) {
            velocity = target3.getFieldSource().getSourceVelocityInReferenceFrame();
        }
        ArrayList<SPWComparisonDetails> arrayList = new ArrayList<SPWComparisonDetails>();
        for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getAbstractScienceSpectralWindowScienceSpectralWindow()) {
            if (bl2) {
                arrayList.add(new SPWComparisonDetails(velocity.dopplerShift(scienceSpectralWindow.getCenterFrequencyRest()), scienceSpectralWindow.getEffectiveBandwidth()));
                continue;
            }
            arrayList.add(new SPWComparisonDetails(scienceSpectralWindow.getCenterFrequency(), scienceSpectralWindow.getEffectiveBandwidth()));
        }
        if (!SpectralSpecValidator.checkSPWsMatch(arrayList, list2)) {
            optional.ifPresent(validationDetails -> validationDetails.plm().add(DefaultProblem.createWarning("The phase 1 SPW central frequencies do not match those of the phase 2 SPWs", "Please check the spectral setup", (IBusinessObject)validationDetails.bo())));
            bl = false;
        }
        return bl;
    }

    public static boolean checkSPWsMatch(@NonNull List<SPWComparisonDetails> list, @NonNull List<SPWComparisonDetails> list2) {
        if (list == null) {
            throw new NullPointerException("phase1spwCentralFrequencies is marked non-null but is null");
        }
        if (list2 == null) {
            throw new NullPointerException("phase2spwCentralFrequencies is marked non-null but is null");
        }
        int n = list2.size();
        int n2 = list.size();
        if (n2 != n / 2 && n != n2) {
            return false;
        }
        for (SPWComparisonDetails sPWComparisonDetails : list) {
            boolean bl = false;
            for (SPWComparisonDetails sPWComparisonDetails2 : list2) {
                Frequency frequency;
                Frequency frequency2 = (Frequency)sPWComparisonDetails.effectiveBandWidth().multiply(0.2);
                Frequency frequency3 = frequency = frequency2.isLessThan((AbstractDoubleWithUnit)MHZ_120_TOLERANCE) ? frequency2 : MHZ_120_TOLERANCE;
                if (!Precision.equals((double)sPWComparisonDetails.centralFrequency().getContentInGHz(), (double)sPWComparisonDetails2.centralFrequency().getContentInGHz(), (double)frequency.getContentInGHz())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static List<SPWComparisonDetails> getPhase2SPWCentralFrequencies(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        ArrayList<SPWComparisonDetails> arrayList = new ArrayList<SPWComparisonDetails>();
        for (BaseBand baseBand : spectralSpec.getBaseBand()) {
            if (spectralSpec.hasSquareLawSetup()) {
                Log.logger(SpectralSpecValidator.class).warning("Skipping validation for base band spectral window pair because it has a square law setup instead of a correlator configuration");
            } else {
                baseBand.refreshPairList();
            }
            for (SpectralWindowI spectralWindowI : baseBand.getSpectralWindow()) {
                Frequency frequency;
                if (spectralWindowI instanceof SpectralWindowPair) {
                    SpectralWindowPair spectralWindowPair = (SpectralWindowPair)spectralWindowI;
                    arrayList.add(new SPWComparisonDetails(spectralWindowPair.getSkyFrequencyLSB(), spectralWindowPair.getEffectiveBandwidth()));
                    arrayList.add(new SPWComparisonDetails(spectralWindowPair.getSkyFrequencyUSB(), spectralWindowPair.getEffectiveBandwidth()));
                    continue;
                }
                Frequency frequency2 = spectralWindowI.getSkyFrequencyLSB();
                if (frequency2 != null) {
                    arrayList.add(new SPWComparisonDetails(spectralWindowI.getSkyFrequencyLSB(), spectralWindowI.getEffectiveBandwidth()));
                }
                if ((frequency = spectralWindowI.getSkyFrequencyUSB()) == null) continue;
                arrayList.add(new SPWComparisonDetails(spectralWindowI.getSkyFrequencyUSB(), spectralWindowI.getEffectiveBandwidth()));
            }
        }
        return arrayList;
    }

    public static class UnableToCheckAntiAliasingRegionException
    extends Exception {
        public UnableToCheckAntiAliasingRegionException() {
        }

        public UnableToCheckAntiAliasingRegionException(String string) {
            super(string);
        }
    }

    public static class SpectralSpecTuningValidationResult {
        private boolean isPoorLO2Warning = false;
        private boolean isPossEarthDopplerProblemPlusWarning = false;
        private boolean isPossEarthDopplerProblemMinusWarning = false;
        private boolean isValidationOkay = true;
        private boolean isCalibrationSetupOkay = true;
        private boolean isBasebandNotInReceiverBand = false;

        public boolean isPoorLO2Warning() {
            return this.isPoorLO2Warning;
        }

        public boolean isPossEarthDopplerProblemPlusWarning() {
            return this.isPossEarthDopplerProblemPlusWarning;
        }

        public boolean isPossEarthDopplerProblemMinusWarning() {
            return this.isPossEarthDopplerProblemMinusWarning;
        }

        public boolean isValidationOkay() {
            return this.isValidationOkay;
        }

        public boolean isCalibrationSetupOkay() {
            return this.isCalibrationSetupOkay;
        }

        public boolean isBasebandNotInReceiverBand() {
            return this.isBasebandNotInReceiverBand;
        }

        public void setPoorLO2Warning(boolean bl) {
            this.isPoorLO2Warning = bl;
        }

        public void setPossEarthDopplerProblemPlusWarning(boolean bl) {
            this.isPossEarthDopplerProblemPlusWarning = bl;
        }

        public void setPossEarthDopplerProblemMinusWarning(boolean bl) {
            this.isPossEarthDopplerProblemMinusWarning = bl;
        }

        public void setValidationOkay(boolean bl) {
            this.isValidationOkay = bl;
        }

        public void setCalibrationSetupOkay(boolean bl) {
            this.isCalibrationSetupOkay = bl;
        }

        public void setBasebandNotInReceiverBand(boolean bl) {
            this.isBasebandNotInReceiverBand = bl;
        }
    }

    public record ValidationDetails(BusinessObject bo, ProblemListModel plm) {
    }

    private class EarthDoppler {
        private Speed positiveSpeed = EARTH_SIDEREAL_DOPPLER_SPEED.deepCopy();
        private Speed negativeSpeed = (Speed)EARTH_SIDEREAL_DOPPLER_SPEED.multiply(-1.0);

        public void clearDopplerSpeeds() {
            this.positiveSpeed = null;
            this.negativeSpeed = null;
        }

        public EarthDoppler(SpectralSpecValidator spectralSpecValidator) {
        }

        public Speed getPositiveSpeed() {
            return this.positiveSpeed;
        }

        public Speed getNegativeSpeed() {
            return this.negativeSpeed;
        }

        public void setPositiveSpeed(Speed speed) {
            this.positiveSpeed = speed;
        }

        public void setNegativeSpeed(Speed speed) {
            this.negativeSpeed = speed;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof EarthDoppler)) {
                return false;
            }
            EarthDoppler earthDoppler = (EarthDoppler)object;
            if (!earthDoppler.canEqual(this)) {
                return false;
            }
            Speed speed = this.getPositiveSpeed();
            Speed speed2 = earthDoppler.getPositiveSpeed();
            if (speed == null ? speed2 != null : !((Object)((Object)speed)).equals((Object)speed2)) {
                return false;
            }
            Speed speed3 = this.getNegativeSpeed();
            Speed speed4 = earthDoppler.getNegativeSpeed();
            return !(speed3 == null ? speed4 != null : !((Object)((Object)speed3)).equals((Object)speed4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof EarthDoppler;
        }

        public int hashCode() {
            int n = 1;
            Speed speed = this.getPositiveSpeed();
            n = n * 59 + (speed == null ? 43 : ((Object)((Object)speed)).hashCode());
            Speed speed2 = this.getNegativeSpeed();
            n = n * 59 + (speed2 == null ? 43 : ((Object)((Object)speed2)).hashCode());
            return n;
        }

        public String toString() {
            return "SpectralSpecValidator.EarthDoppler(positiveSpeed=" + String.valueOf((Object)this.getPositiveSpeed()) + ", negativeSpeed=" + String.valueOf((Object)this.getNegativeSpeed()) + ")";
        }
    }

    public record SPWComparisonDetails(Frequency centralFrequency, Frequency effectiveBandWidth) {
    }
}

