/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;

public class SchedulingConstraintsValidator
extends AbstractValidator {
    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        SchedulingConstraints schedulingConstraints = (SchedulingConstraints)businessObject;
        if (schedulingConstraints.getDynamicRange() < 0.0) {
            problem = DefaultProblem.createError("Schedblock dynamic range goal is invalid", "Set the dynamic range to a sensible value", (IBusinessObject)schedulingConstraints);
            problemListModel.add(problem);
        }
        if (schedulingConstraints.getMaxAcceptableAngResolution().getContentInDefaultUnits() < 0.0) {
            problem = DefaultProblem.createError("Required maximum angular resolution is invalid", "Set the required maximum angular resolution to a sensible value", (IBusinessObject)schedulingConstraints);
            problemListModel.add(problem);
        }
        if (schedulingConstraints.getMinAcceptableAngResolution().getContentInDefaultUnits() > schedulingConstraints.getMaxAcceptableAngResolution().getContentInDefaultUnits()) {
            problem = DefaultProblem.createError("Required minimum angular resolution is greater than maximum", "Set the required angular resolutions to consistent values", (IBusinessObject)schedulingConstraints);
            problemListModel.add(problem);
        }
        if (((SchedBlock)schedulingConstraints.getParent()).getModeType().equals("User") && schedulingConstraints.getRepresentativeTarget() == null) {
            problem = DefaultProblem.createError("No representative target set for a user mode", "Select a target to be the representative target", (IBusinessObject)schedulingConstraints);
            problemListModel.add(problem);
        }
    }
}

