/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.schedblock.ObservingParametersValidator;
import alma.obsprep.ot.valdef.schedblock.ValidatorUtils;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;

public class PointingCalParametersValidator
extends ObservingParametersValidator {
    protected static double MINACCURACYARCSEC = 0.05;

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        double d;
        Problem problem;
        super.localValidate(businessObject, problemListModel);
        PointingCalParameters pointingCalParameters = (PointingCalParameters)businessObject;
        double d2 = pointingCalParameters.getDefaultIntegrationTime().getContentInUnits(Time.UNIT_S);
        double d3 = pointingCalParameters.getCycleTime().getContentInUnits(Time.UNIT_S);
        if (d3 <= 0.0) {
            problem = DefaultProblem.createError("Calibrator cycle time is invalid", "Set the time to a sensible value", (IBusinessObject)pointingCalParameters);
            problemListModel.add(problem);
        }
        if (d2 <= 0.0) {
            problem = DefaultProblem.createError("Calibrator default integration time is invalid", "Set the time to a sensible value", (IBusinessObject)pointingCalParameters);
            problemListModel.add(problem);
        }
        if ((d = pointingCalParameters.getMaximumElapsedTime().getContentInUnits(Time.UNIT_S)) <= 0.0) {
            problem = DefaultProblem.createError("Pointing Cal. elapsed time is invalid", "Set the time to a sensible value", (IBusinessObject)pointingCalParameters);
            problemListModel.add(problem);
        }
        if (d2 > d) {
            problem = DefaultProblem.createError("Pointing Cal. default int. time is greater than elapsed time", "Set the times to sensible values", (IBusinessObject)pointingCalParameters);
            problemListModel.add(problem);
        }
        if (d > d3 && d != MAGIC_CYCLE_TIME) {
            problem = DefaultProblem.createError("Pointing Cal. elapsed time is greater than cycle time", "Set the times to sensible values", (IBusinessObject)pointingCalParameters);
            problemListModel.add(problem);
        }
        if (pointingCalParameters.getDesiredAccuracy().getContentInUnits(Angle.UNIT_ARCSEC) <= MINACCURACYARCSEC) {
            problem = DefaultProblem.createError("Pointing cal. desired accuracy is too small", "Set the desired accuracy to a sensible value", (IBusinessObject)pointingCalParameters);
            problemListModel.add(problem);
        }
        if (pointingCalParameters.getExcursion().getContentInUnits(Angle.UNIT_ARCSEC) <= MINACCURACYARCSEC) {
            problem = DefaultProblem.createError("Pointing cal. excursion is too small", "Set the excursion to a sensible value", (IBusinessObject)pointingCalParameters);
            problemListModel.add(problem);
        }
        for (Target target : pointingCalParameters.getTargetList()) {
            if (target.getAbstractInstrumentSpec() == null) continue;
            Time time = ((SpectralSpec)((Object)target.getAbstractInstrumentSpec())).getCorrelatorConfiguration().getIntegrationDuration();
            Time time2 = pointingCalParameters.getSubScanDuration();
            if (!ValidatorUtils.isIntegralMultipleTime(time2, time)) {
                problem = DefaultProblem.createError("Subscan duration in pointing cal is not a multiple of the integration duration in the associated instrument setup", "Correct the value of the subscan duration", (IBusinessObject)pointingCalParameters);
                problemListModel.add(problem);
            }
            if (ValidatorUtils.isIntegralMultipleControlRequiredBase(time2)) continue;
            problem = DefaultProblem.createError("Subscan duration in pointing cal is not a multiple of 48.0 ms", "Correct the value of the subscan duration", (IBusinessObject)pointingCalParameters);
            problemListModel.add(problem);
        }
    }
}

