/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.HolographyParameters;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;

public class HolographyParametersValidator
extends AbstractValidator {
    protected static double LOFREQMINGHZ = 78.77;
    protected static double LOFREQMAXGHZ = 79.07;
    protected static double HIFREQMINGHZ = 103.87;
    protected static double HIFREQMAXGHZ = 104.17;

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        double d;
        Problem problem;
        HolographyParameters holographyParameters = (HolographyParameters)businessObject;
        if (holographyParameters.getCalTime().getContentInUnits(Time.UNIT_S) <= 0.0) {
            problem = DefaultProblem.createError("Holography calibration time is < 0.0", "Set the time to a sensible value", (IBusinessObject)holographyParameters);
            problemListModel.add(problem);
        }
        if (holographyParameters.getRowsCal() <= 0) {
            problem = DefaultProblem.createError("Holography calibration rows is < 0.0", "Set the number of calibration rows to a sensible value", (IBusinessObject)holographyParameters);
            problemListModel.add(problem);
        }
        if (holographyParameters.getSpeed().getContentInUnits(AngularVelocity.UNIT_ARCSEC_S) <= 0.0) {
            problem = DefaultProblem.createError("Holography Scanning speed is < 0.0", "Set the scanning speed to a sensible value", (IBusinessObject)holographyParameters);
            problemListModel.add(problem);
        }
        if (holographyParameters.getStartFraction() < 0.0 || holographyParameters.getStartFraction() > 1.0) {
            problem = DefaultProblem.createError("Holography start fraction is an illegal value", "Set the start fraction to be between 0 and 1", (IBusinessObject)holographyParameters);
            problemListModel.add(problem);
        }
        if (!((d = holographyParameters.getFrequency().getContentInUnits(Frequency.UNIT_GHZ)) > LOFREQMINGHZ && d < LOFREQMAXGHZ || d > HIFREQMINGHZ && d < HIFREQMAXGHZ)) {
            problem = DefaultProblem.createError("Holography frequency is not valid", "Set the frequency to be in the ranges " + LOFREQMINGHZ + " to " + LOFREQMAXGHZ + " or " + HIFREQMINGHZ + " to " + HIFREQMAXGHZ + " GHz", (IBusinessObject)holographyParameters);
            problemListModel.add(problem);
        }
    }
}

