/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.Frequency;

public class BaseBandConfigValidator
extends AbstractValidator {
    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        boolean bl;
        Problem problem;
        AbstractBaseBandConfig abstractBaseBandConfig = (AbstractBaseBandConfig)businessObject;
        if (abstractBaseBandConfig.getSingleSpectralWindowCount() == 0) {
            problem = DefaultProblem.createError("No sub bands have been specified for BaseBandConfig " + abstractBaseBandConfig.getBaseBandIndex(), "Navigate to the BaseBandConfig and add one or more sub bands", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        Frequency frequency = abstractBaseBandConfig.getCenterFrequency();
        try {
            ReceiverBand.getReceiverBandName(frequency.getContentInGHz());
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        if (!bl) {
            problem = DefaultProblem.createError("BaseBandConfig " + abstractBaseBandConfig.getBaseBandIndex() + " centre frequency (" + String.valueOf((Object)frequency) + ") is not supported", "Choose another frequency", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }
}

