/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.schedblock.CalibratorParametersValidator;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;

public class BandpassCalParametersValidator
extends CalibratorParametersValidator {
    private static final double MINAMPACCURACY = 0.0;
    private static final double MINPHASEACCURACYARCSEC = 0.0;

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        super.localValidate(businessObject, problemListModel);
        BandpassCalParameters bandpassCalParameters = (BandpassCalParameters)businessObject;
        double d = bandpassCalParameters.getDefaultIntegrationTime().getContentInUnits(Time.UNIT_S);
        double d2 = bandpassCalParameters.getCycleTime().getContentInUnits(Time.UNIT_S);
        double d3 = bandpassCalParameters.getMaximumElapsedTime().getContentInUnits(Time.UNIT_S);
        if (d3 <= 0.0) {
            problem = DefaultProblem.createError("Bandpass Cal. elapsed time is invalid", "Set the time to a sensible value", (IBusinessObject)bandpassCalParameters);
            problemListModel.add(problem);
        }
        if (d > d3) {
            problem = DefaultProblem.createError("Bandpass Cal. default int. time is greater than elapsed time", "Set the times to sensible values", (IBusinessObject)bandpassCalParameters);
            problemListModel.add(problem);
        }
        if (d3 > d2 && d3 != MAGIC_CYCLE_TIME) {
            problem = DefaultProblem.createError("Bandpass Cal. elapsed time is greater than cycle time", "Set the times to sensible values", (IBusinessObject)bandpassCalParameters);
            problemListModel.add(problem);
        }
        if (bandpassCalParameters.getDesiredAmplitudeAccuracy() <= 0.0) {
            problem = DefaultProblem.createError("Bandpass cal. desired amplitude accuracy is too small", "Set the desired accuracy to a sensible value", (IBusinessObject)bandpassCalParameters);
            problemListModel.add(problem);
        }
        if (bandpassCalParameters.getDesiredPhaseAccuracy().getContentInUnits(Angle.UNIT_ARCSEC) <= 0.0) {
            problem = DefaultProblem.createError("Bandpass cal. desired phase accuracy is too small", "Set the desired accuracy to a sensible value", (IBusinessObject)bandpassCalParameters);
            problemListModel.add(problem);
        }
    }
}

