/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.others;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.help.UnsupportedOperationException;
import jsky.coords.WorldCoords;
import lombok.NonNull;

public class UserRestrictionsProvider {
    private static List<Frequency> tuning;

    public static void getUserRestrictionPredicates(@NonNull UserEditRestrictionController.UserEditRestriction userEditRestriction) {
        if (userEditRestriction == null) {
            throw new NullPointerException("userEditRestriction is marked non-null but is null");
        }
        ArrayList<UserEditRestrictionController.ValidationReport> arrayList = new ArrayList<UserEditRestrictionController.ValidationReport>();
        arrayList.add(new UserEditRestrictionController.ValidationReport("You have changed a sky frequency by more than 20% of the spw bandwidth.", "Reset the frequency to be closer to the Phase-1 value."));
        arrayList.add(new UserEditRestrictionController.ValidationReport("You have changed a pointing position by more than half the antenna beamsize.", "Reset the position to be closer to the Phase-1 value."));
        userEditRestriction.setValidationReports(arrayList);
        userEditRestriction.setUserRestrictionPredicates(List.of(UserRestrictionsProvider::isSPWsShiftedBeyondThreshold, UserRestrictionsProvider::isPointingsMovedBeyondThreshold));
    }

    public static boolean isSPWsShiftedBeyondThreshold(@NonNull UserEditRestrictionController.UserEditRestriction userEditRestriction) {
        if (userEditRestriction == null) {
            throw new NullPointerException("userEditRestriction is marked non-null but is null");
        }
        Optional<ScienceGoal> optional = userEditRestriction.getP1SG();
        ScienceGoal scienceGoal = userEditRestriction.getP2SG();
        if (!optional.isPresent()) {
            throw new IllegalArgumentException("Unable to determine the P1 SG counterpart to " + scienceGoal.getName());
        }
        SpectralSetupParameters spectralSetupParameters = optional.get().getSpectralSetupParameters();
        SpectralSetupParameters spectralSetupParameters2 = scienceGoal.getSpectralSetupParameters();
        assert (spectralSetupParameters != null && spectralSetupParameters2 != null);
        if (!spectralSetupParameters.getSpectralType().equals((Object)spectralSetupParameters2.getSpectralType())) {
            throw new UserRestrictionComparisonNotPossibleException();
        }
        boolean bl = false;
        switch (spectralSetupParameters2.getSpectralType()) {
            case SINGLECONTINUUM: 
            case SPECTRALLINE: {
                bl = UserRestrictionsProvider.isContinuumOrSpectralLineSPWsShiftedByMoreThanLimit(spectralSetupParameters, spectralSetupParameters2);
                break;
            }
            case SPECTRALSCAN: {
                bl = UserRestrictionsProvider.isSpectralScanSPWsShiftedByMoreThanLimit(spectralSetupParameters, spectralSetupParameters2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unable to handle this spectral type " + String.valueOf((Object)spectralSetupParameters2.getSpectralType()));
            }
        }
        return bl;
    }

    private static boolean isContinuumOrSpectralLineSPWsShiftedByMoreThanLimit(SpectralSetupParameters spectralSetupParameters, SpectralSetupParameters spectralSetupParameters2) {
        if (spectralSetupParameters.getAbstractScienceSpectralWindowCount() != spectralSetupParameters2.getAbstractScienceSpectralWindowCount()) {
            throw new UserRestrictionComparisonNotPossibleException("No of spectral windows vary in spectral setup between science goals");
        }
        for (int i = 0; i < spectralSetupParameters2.getAbstractScienceSpectralWindow().length; ++i) {
            ScienceSpectralWindow scienceSpectralWindow = (ScienceSpectralWindow)((Object)spectralSetupParameters.getAbstractScienceSpectralWindow()[i]);
            ScienceSpectralWindow scienceSpectralWindow2 = (ScienceSpectralWindow)((Object)spectralSetupParameters2.getAbstractScienceSpectralWindow()[i]);
            double d = scienceSpectralWindow.getEffectiveBandwidth().getContentInGHz() * 0.2;
            double d2 = scienceSpectralWindow2.getCenterFrequencySky().getContentInGHz();
            double d3 = scienceSpectralWindow.getCenterFrequencySky().getContentInGHz();
            if (!(Math.abs(d3 - d2) > d)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSpectralScanSPWsShiftedByMoreThanLimit(SpectralSetupParameters spectralSetupParameters, SpectralSetupParameters spectralSetupParameters2) {
        Frequency frequency;
        if (!spectralSetupParameters.isSpectralScan() || !spectralSetupParameters2.isSpectralScan()) {
            throw new IllegalArgumentException("Illegal argument: both spectral setups should be spectral scans");
        }
        SpectralScan spectralScan = spectralSetupParameters.getSpectralScan();
        SpectralScan spectralScan2 = spectralSetupParameters2.getSpectralScan();
        Frequency frequency2 = spectralScan.getEffectiveBandwidth();
        if (!frequency2.isEqual((AbstractDoubleWithUnit)(frequency = spectralScan2.getEffectiveBandwidth()), 1.0E-9)) {
            throw new UserRestrictionComparisonNotPossibleException("Bandwidth values vary for the spectral scans");
        }
        try {
            SpectralScan.SpectralScanTunings spectralScanTunings = spectralScan.getTunings();
            SpectralScan.SpectralScanTunings spectralScanTunings2 = spectralScan2.getTunings();
            if (!spectralScanTunings.getNumberOfSPWs().equals(spectralScanTunings2.getNumberOfSPWs())) {
                return true;
            }
            if (!spectralScanTunings.getNumberOfTunings().equals(spectralScanTunings2.getNumberOfTunings())) {
                return true;
            }
            double d = frequency.getContentInGHz() * 0.2;
            for (int i = 0; i < spectralScanTunings.getNumberOfTunings(); ++i) {
                List<Frequency> list = spectralScanTunings.getTuning(i);
                List<Frequency> list2 = spectralScanTunings2.getTuning(i);
                for (int j = 0; j < list.size(); ++j) {
                    double d2;
                    double d3 = list.get(j).getContentInGHz();
                    if (!(Math.abs(d3 - (d2 = list2.get(j).getContentInGHz())) > d)) continue;
                    Log.logger(UserRestrictionsProvider.class).fine("Spectral scan SPW has been shifted beyond permitted limit - major change detected");
                    return true;
                }
            }
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
            throw new UserRestrictionComparisonNotPossibleException();
        }
        return false;
    }

    public static boolean isProperMotionMovedBeyondThreshold(@NonNull UserEditRestrictionController.UserEditRestriction userEditRestriction) {
        if (userEditRestriction == null) {
            throw new NullPointerException("userEditRestriction is marked non-null but is null");
        }
        boolean bl = false;
        Optional<ScienceGoal> optional = userEditRestriction.getP1SG();
        ScienceGoal scienceGoal = userEditRestriction.getP2SG();
        if (!optional.isPresent()) {
            throw new IllegalArgumentException("Unable to determine the P1 SG counterpart to " + scienceGoal.getName());
        }
        SpectralSetupParameters spectralSetupParameters = optional.get().getSpectralSetupParameters();
        SpectralSetupParameters spectralSetupParameters2 = scienceGoal.getSpectralSetupParameters();
        assert (spectralSetupParameters != null && spectralSetupParameters2 != null);
        if (!spectralSetupParameters.getSpectralType().equals((Object)spectralSetupParameters2.getSpectralType())) {
            throw new UserRestrictionComparisonNotPossibleException();
        }
        if (scienceGoal.getTargetParametersCount() != optional.get().getTargetParametersCount()) {
            Log.logger(UserRestrictionsProvider.class).warning(" The # of target parameters in the P1 SG varies to that in the P2 SG");
            throw new UserRestrictionComparisonNotPossibleException();
        }
        double d = ((Angle)Antenna.ANTENNA_12M.getBeamSize(spectralSetupParameters.getRepresentativeFrequencyWithSkyOffset()).half()).getContentInUnits(Angle.UNIT_ARCSEC);
        for (int i = 0; i < scienceGoal.getTargetParameters().length; ++i) {
            TargetParameters targetParameters = optional.get().getTargetParameters()[i];
            TargetParameters targetParameters2 = scienceGoal.getTargetParameters()[i];
            double d2 = targetParameters.getPMDec().getContentInUnits(AngularVelocity.UNIT_ARCSEC_S);
            double d3 = targetParameters2.getPMDec().getContentInUnits(AngularVelocity.UNIT_ARCSEC_S);
            double d4 = targetParameters.getPMRA().getContentInUnits(AngularVelocity.UNIT_ARCSEC_S);
            double d5 = targetParameters2.getPMRA().getContentInUnits(AngularVelocity.UNIT_ARCSEC_S);
            if (Math.abs(d2 - d3) > d) {
                Log.logger(UserRestrictionsProvider.class).info("The proper motion Dec has been changed by more than 0.5 * HPBW");
                bl = true;
                break;
            }
            if (!(Math.abs(d4 - d5) > d)) continue;
            Log.logger(UserRestrictionsProvider.class).info("The proper motion RA has been changed by more than 0.5 * HPBW");
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isPointingsMovedBeyondThreshold(@NonNull UserEditRestrictionController.UserEditRestriction userEditRestriction) {
        if (userEditRestriction == null) {
            throw new NullPointerException("userEditRestriction is marked non-null but is null");
        }
        Optional<ScienceGoal> optional = userEditRestriction.getP1SG();
        ScienceGoal scienceGoal = userEditRestriction.getP2SG();
        if (!optional.isPresent()) {
            throw new IllegalArgumentException("Unable to determine the P1 SG counterpart to " + scienceGoal.getName());
        }
        SpectralSetupParameters spectralSetupParameters = optional.get().getSpectralSetupParameters();
        SpectralSetupParameters spectralSetupParameters2 = scienceGoal.getSpectralSetupParameters();
        assert (spectralSetupParameters != null && spectralSetupParameters2 != null);
        if (!spectralSetupParameters.getSpectralType().equals((Object)spectralSetupParameters2.getSpectralType())) {
            throw new UserRestrictionComparisonNotPossibleException();
        }
        if (scienceGoal.getTargetParametersCount() != optional.get().getTargetParametersCount()) {
            Log.logger(UserRestrictionsProvider.class).warning(" The # of target parameters in the P1 SG varies to that in the P2 SG");
            throw new UserRestrictionComparisonNotPossibleException();
        }
        Angle angle = (Angle)Antenna.ANTENNA_12M.getBeamSize(spectralSetupParameters.getRepresentativeFrequencyWithSkyOffset()).half();
        for (int i = 0; i < scienceGoal.getTargetParameters().length; ++i) {
            TargetParameters targetParameters = optional.get().getTargetParameters()[i];
            TargetParameters targetParameters2 = scienceGoal.getTargetParameters()[i];
            if (!targetParameters.getFieldPatternType().equals((Object)targetParameters2.getFieldPatternType())) {
                Log.logger(UserRestrictionsProvider.class).warning("The P1 target parameters counterpart has a different field type");
                throw new UserRestrictionComparisonNotPossibleException();
            }
            boolean bl = false;
            switch (targetParameters2.getFieldPatternType()) {
                case POINT: {
                    bl = UserRestrictionsProvider.isPointingPatternWithinAdjustmentThresholdLimit(targetParameters, targetParameters2, angle);
                    break;
                }
                case RECTANGLE: {
                    bl = UserRestrictionsProvider.isRectanglePatternPositionWithinAdjustmentThresholdLimit(targetParameters, targetParameters2, angle);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unable to handle a field pattern type of " + String.valueOf((Object)targetParameters2.getFieldPatternType()));
                }
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    private static boolean isRectanglePatternPositionWithinAdjustmentThresholdLimit(@NonNull TargetParameters targetParameters, @NonNull TargetParameters targetParameters2, @NonNull Angle angle) {
        if (targetParameters == null) {
            throw new NullPointerException("p1TargetParameter is marked non-null but is null");
        }
        if (targetParameters2 == null) {
            throw new NullPointerException("p2TargetParameter is marked non-null but is null");
        }
        if (angle == null) {
            throw new NullPointerException("maxPermittedChangeInAngularPosition is marked non-null but is null");
        }
        if (!FieldPattern.FieldPatternType.RECTANGLE.equals((Object)targetParameters2.getFieldPatternType())) {
            throw new IllegalArgumentException("Field pattern type should be rectangle");
        }
        Rectangle rectangle = targetParameters2.getSingleRectangle();
        Rectangle rectangle2 = targetParameters.getSingleRectangle();
        SkyCoordinates skyCoordinates = rectangle.getFieldCenterCoordinates();
        SkyCoordinates skyCoordinates2 = rectangle2.getFieldCenterCoordinates();
        SkyCoordinates skyCoordinates3 = null;
        if (skyCoordinates2.isOffsetCoordinates() != skyCoordinates.isOffsetCoordinates()) {
            throw new UserRestrictionComparisonNotPossibleException();
        }
        SkyCoordinates skyCoordinates4 = skyCoordinates2.isOffsetCoordinates() ? skyCoordinates2.getAbsoluteCoordinates(targetParameters.getSourceCoordinates()) : skyCoordinates2;
        skyCoordinates3 = skyCoordinates.isOffsetCoordinates() ? skyCoordinates.getAbsoluteCoordinates(targetParameters2.getSourceCoordinates()) : skyCoordinates;
        SkyPoint skyPoint = skyCoordinates4.getAbsoluteSkyPointInICRSDeg();
        SkyPoint skyPoint2 = skyCoordinates3.getAbsoluteSkyPointInICRSDeg();
        double d = WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint2.getX(), (double)skyPoint2.getY()) / 60.0;
        return !(d > angle.getContentInUnits(Angle.UNIT_DEG));
    }

    private static boolean isPointingPatternWithinAdjustmentThresholdLimit(@NonNull TargetParameters targetParameters, @NonNull TargetParameters targetParameters2, @NonNull Angle angle) {
        SkyCoordinates[] skyCoordinatesArray;
        if (targetParameters == null) {
            throw new NullPointerException("p1TargetParameter is marked non-null but is null");
        }
        if (targetParameters2 == null) {
            throw new NullPointerException("p2TargetParameter is marked non-null but is null");
        }
        if (angle == null) {
            throw new NullPointerException("maxPermittedChangeInAngularPosition is marked non-null but is null");
        }
        if (!FieldPattern.FieldPatternType.POINT.equals((Object)targetParameters2.getFieldPatternType())) {
            throw new IllegalArgumentException("Field pattern type should be pointing pattern");
        }
        SkyCoordinates[] skyCoordinatesArray2 = targetParameters2.getPointingPattern().getPhaseCenterCoordinates();
        if (skyCoordinatesArray2.length != (skyCoordinatesArray = targetParameters.getPointingPattern().getPhaseCenterCoordinates()).length) {
            throw new UserRestrictionComparisonNotPossibleException();
        }
        for (int i = 0; i < skyCoordinatesArray.length; ++i) {
            SkyCoordinates skyCoordinates = skyCoordinatesArray[i];
            SkyCoordinates skyCoordinates2 = skyCoordinatesArray2[i];
            SkyCoordinates skyCoordinates3 = null;
            SkyCoordinates skyCoordinates4 = skyCoordinates.isOffsetCoordinates() ? skyCoordinates.getAbsoluteCoordinates(targetParameters.getSourceCoordinates()) : skyCoordinates;
            skyCoordinates3 = skyCoordinates2.isOffsetCoordinates() ? skyCoordinates2.getAbsoluteCoordinates(targetParameters2.getSourceCoordinates()) : skyCoordinates2;
            SkyPoint skyPoint = skyCoordinates4.getAbsoluteSkyPointInICRSDeg();
            SkyPoint skyPoint2 = skyCoordinates3.getAbsoluteSkyPointInICRSDeg();
            double d = WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint2.getX(), (double)skyPoint2.getY()) / 60.0;
            if (!(d > angle.getContentInUnits(Angle.UNIT_DEG))) continue;
            return false;
        }
        return true;
    }

    public static class UserRestrictionComparisonNotPossibleException
    extends RuntimeException {
        private static final long serialVersionUID = 5168100468118928986L;

        public UserRestrictionComparisonNotPossibleException(String string) {
            super(string);
        }

        public UserRestrictionComparisonNotPossibleException() {
        }
    }
}

