/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.others;

import alma.entity.xmlbinding.projectstatus.ProjectStatusRefT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnit;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.util.MiscUtils;
import java.util.Arrays;
import java.util.List;

public class TestObjectStatusValidator
extends AbstractValidator {
    private static final String ME = "chk05: ";
    private List<String> projectStatusWithoutReference = Arrays.asList("", ObsProject.STATUS_NEWPHASE1, ObsProject.STATUS_NEWPHASE2);
    private List<String> obsunitStatusWithoutReference = Arrays.asList("", ObsUnit.STATUS_NEWPHASE1, ObsUnit.STATUS_NEWPHASE2);

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        boolean bl;
        boolean bl2;
        ProjectStatusRefT projectStatusRefT;
        String string;
        Object object;
        if (businessObject instanceof ObsProject) {
            object = (ObsProject)businessObject;
            string = object.getStatus();
            projectStatusRefT = object.getCastorObject().getProjectStatusRef();
            bl2 = !this.projectStatusWithoutReference.contains(string);
        } else if (businessObject instanceof ObsUnitSet) {
            object = (ObsUnitSet)businessObject;
            string = object.getStatus();
            projectStatusRefT = object.getCastorObject().getOUSStatusRef();
            bl2 = !this.obsunitStatusWithoutReference.contains(string);
        } else if (businessObject instanceof SchedBlock) {
            object = (SchedBlock)businessObject;
            string = object.getStatus();
            projectStatusRefT = object.getCastorObject().getSBStatusRef();
            bl2 = !this.obsunitStatusWithoutReference.contains(string);
        } else {
            return;
        }
        object = "chk05: Status of this " + businessObject.getShortClassName() + " is '" + string + "'";
        object = projectStatusRefT != null ? (String)object + ", and it references a status object (" + projectStatusRefT.getEntityId() + ")" : (String)object + ", and it does not reference a status object";
        boolean bl3 = bl = projectStatusRefT != null;
        if (bl == bl2) {
            problemListModel.add(DefaultProblem.createSuccess((String)object, MiscUtils.packageClassnameHash(businessObject), (IBusinessObject)businessObject));
        } else {
            problemListModel.add(DefaultProblem.createWarning((String)object, MiscUtils.packageClassnameHash(businessObject), (IBusinessObject)businessObject));
        }
    }
}

