/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.corrconfig;

import alma.ACS.stringSeqHolder;
import alma.CorrConfigModeErr.wrappers.AcsJConstructorFailureEx;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ACASpectrometerCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.corrconfig.ACACorrConfigValidatorWrapper;
import alma.obsprep.ot.valdef.corrconfig.BLCorrConfigValidatorWrapper;
import alma.obsprep.ot.valdef.corrconfig.CorrConfigValidatorWrapper;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import java.util.HashMap;

public class CorrelatorConfigValidator
extends AbstractValidator {
    private final Log.Logger logger = Log.logger((Object)this);

    public CorrelatorConfigValidator() {
        this.setValidatorThreadSafe(true);
    }

    private CorrConfigValidatorWrapper getDelegate(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) throws AcsJConstructorFailureEx {
        if (abstractCorrelatorConfiguration instanceof BLCorrelatorConfiguration) {
            return new BLCorrConfigValidatorWrapper();
        }
        if (abstractCorrelatorConfiguration instanceof ACACorrelatorConfiguration) {
            return new ACACorrConfigValidatorWrapper();
        }
        if (abstractCorrelatorConfiguration instanceof ACASpectrometerCorrelatorConfiguration) {
            return new ACACorrConfigValidatorWrapper();
        }
        throw new IllegalArgumentException("Unexpected BusinessObject : " + String.valueOf(abstractCorrelatorConfiguration.getClass()));
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        CorrConfigValidatorWrapper corrConfigValidatorWrapper;
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = (AbstractCorrelatorConfiguration)businessObject;
        try {
            corrConfigValidatorWrapper = this.getDelegate(abstractCorrelatorConfiguration);
        }
        catch (AcsJConstructorFailureEx acsJConstructorFailureEx) {
            acsJConstructorFailureEx.printStackTrace();
            String string = "Could not create an instance of CorrConfigValidator.Skipped validation for " + abstractCorrelatorConfiguration.getName() + "\nReason : " + acsJConstructorFailureEx.getMessage();
            this.logger.warning(string);
            return;
        }
        int n = corrConfigValidatorWrapper.getMaxNumAntennas(abstractCorrelatorConfiguration);
        stringSeqHolder stringSeqHolder2 = new stringSeqHolder();
        SpectralSpec spectralSpec = abstractCorrelatorConfiguration.getSpectralSpec();
        if (spectralSpec == null) {
            return;
        }
        try {
            corrConfigValidatorWrapper.validateSpectralSpec(spectralSpec, n, stringSeqHolder2);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            problem = DefaultProblem.createError(string, "Unexpected Error. Save the project to an aot file and report the problem to the OT development team.", (IBusinessObject)abstractCorrelatorConfiguration);
            problemListModel.add(problem);
        }
        for (String string : stringSeqHolder2.value) {
            problem = DefaultProblem.createError(string, "Revise the correlator configuration settings", (IBusinessObject)abstractCorrelatorConfiguration);
            problemListModel.add(problem);
        }
        this.validateBaseBandNames(abstractCorrelatorConfiguration, problemListModel);
    }

    private void validateBaseBandNames(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration, ProblemListModel problemListModel) {
        HashMap<String, SideBandUse> hashMap = new HashMap<String, SideBandUse>();
        for (AbstractBaseBandConfig abstractBaseBandConfig : abstractCorrelatorConfiguration.getBaseBandConfig()) {
            String string = abstractBaseBandConfig.getBaseBandName();
            if (hashMap.keySet().contains(string)) {
                String string2 = "Baseband Name " + string + " is duplicated";
                Problem problem = DefaultProblem.createError(string2, "Change Baseband Name", (IBusinessObject)abstractBaseBandConfig);
                problemListModel.add(problem);
                continue;
            }
            hashMap.put(abstractBaseBandConfig.getBaseBandName(), abstractBaseBandConfig.getSideBandUse());
        }
    }
}

