/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.ot.scripting.BatchOT;
import alma.obsprep.ot.scripting.BatchOTXMLUnitMapper;
import alma.obsprep.ot.scripting.P2GActionInterface;
import alma.obsprep.ot.scripting.P2GXMLActionPerformer;
import alma.obsprep.ot.scripting.bindings.CoordinateSystemType;
import alma.obsprep.ot.scripting.bindings.CoordinateType;
import alma.obsprep.ot.scripting.bindings.IntentType;
import alma.obsprep.ot.scripting.bindings.OffsetSBActionType;
import alma.obsprep.ot.scripting.bindings.OffsetType;
import alma.obsprep.ot.scripting.bindings.UpdateOffsetAction;
import alma.obsprep.util.Convert4dp;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class UpdateOffsetActionPerformer
extends P2GXMLActionPerformer
implements P2GActionInterface {
    private final List<UpdateOffsetAction> updateOffsetActions;

    UpdateOffsetActionPerformer(@NonNull BatchOT batchOT, @NonNull List<UpdateOffsetAction> list, boolean bl) throws P2GXMLActionPerformer.InputParameterValidationException {
        super(bl, batchOT);
        if (batchOT == null) {
            throw new NullPointerException("batchOTHelper is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("tpOffsetActions is marked non-null but is null");
        }
        actionName = "<UpdateOffset>";
        this.updateOffsetActions = list;
        this.validateRequestedActions();
    }

    @Override
    public void validateRequestedActions() throws P2GXMLActionPerformer.InputParameterValidationException {
        for (UpdateOffsetAction updateOffsetAction : this.updateOffsetActions) {
            if (!UpdateOffsetActionPerformer.verifyUID(updateOffsetAction.getProjectuid())) {
                throw (P2GXMLActionPerformer)this.new P2GXMLActionPerformer.InputParameterValidationException("The UID " + updateOffsetAction.getProjectuid() + " is not specified correctly");
            }
            for (OffsetSBActionType offsetSBActionType : updateOffsetAction.getSb()) {
                if (StringUtils.isNotEmpty((CharSequence)offsetSBActionType.getSbuid()) && StringUtils.isNotEmpty((CharSequence)offsetSBActionType.getSbname())) {
                    throw (P2GXMLActionPerformer)this.new P2GXMLActionPerformer.InputParameterValidationException("Update offset action for project:  an SB UID and a SB name has been specified, use only one " + offsetSBActionType.getSbuid() + " " + offsetSBActionType.getSbname());
                }
                for (OffsetType offsetType : offsetSBActionType.getOffset()) {
                    boolean bl;
                    if (offsetType.getIntent() == null && StringUtils.isEmpty((CharSequence)offsetType.getSourcename())) {
                        throw (P2GXMLActionPerformer)this.new P2GXMLActionPerformer.InputParameterValidationException("Update offset action for project: " + updateOffsetAction.getProjectuid() + " neither source name or intent has been specified");
                    }
                    boolean bl2 = offsetType.getLatitude() != null && offsetType.getLongitude() != null;
                    boolean bl3 = bl = offsetType.getRA() != null && offsetType.getDec() != null;
                    if (bl2 && bl) {
                        throw (P2GXMLActionPerformer)this.new P2GXMLActionPerformer.InputParameterValidationException("Update offset action for project: " + updateOffsetAction.getProjectuid() + " has a source with both RA/Dec and Lat/Long defined");
                    }
                    if (!bl && !bl2) {
                        throw (P2GXMLActionPerformer)this.new P2GXMLActionPerformer.InputParameterValidationException("Update offset action for project: " + updateOffsetAction.getProjectuid() + " has a source with incomplete coordinates");
                    }
                    if (!bl2 && offsetType.getCoordinatetype().equals((Object)CoordinateType.RELATIVE)) {
                        throw (P2GXMLActionPerformer)this.new P2GXMLActionPerformer.InputParameterValidationException("Update offset action for project: " + updateOffsetAction.getProjectuid() + " has relative coordinates with RA/dec - should be lat/lon");
                    }
                    if (bl2 && offsetType.getUnit() == null) {
                        throw (P2GXMLActionPerformer)this.new P2GXMLActionPerformer.InputParameterValidationException("Update offset action for project: " + updateOffsetAction.getProjectuid() + " lat/lon specified but no unit defined (i.e. unit=[arcsec|arcmin|deg])");
                    }
                    if (!bl) continue;
                    String string = offsetType.getRA();
                    try {
                        Convert4dp.HHMMSSToDeg(string);
                    }
                    catch (InvalidCoordException | NumberFormatException exception) {
                        throw (P2GXMLActionPerformer)this.new P2GXMLActionPerformer.InputParameterValidationException("The RA specified for SB " + offsetSBActionType.getSbuid() + " is invalid " + string);
                    }
                    String string2 = offsetType.getDec();
                    try {
                        Convert4dp.DDMMSSToDeg(string2);
                    }
                    catch (InvalidCoordException | NumberFormatException exception) {
                        throw (P2GXMLActionPerformer)this.new P2GXMLActionPerformer.InputParameterValidationException("The declination specified for SB " + offsetSBActionType.getSbuid() + " is invalid " + string2);
                    }
                }
            }
        }
    }

    @Override
    public void startAction() throws P2GActionInterface.UnableToCompleteActionException {
        for (UpdateOffsetAction updateOffsetAction : this.updateOffsetActions) {
            P2GXMLActionPerformer.ProjectTopLevelEntities projectTopLevelEntities = this.fetchProjectFromArchive(updateOffsetAction.getProjectuid());
            ScienceGoal[] scienceGoalArray = projectTopLevelEntities.getObsProgram().getAbstractScienceGoalScienceGoal();
            for (OffsetSBActionType offsetSBActionType : updateOffsetAction.getSb()) {
                boolean bl;
                ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
                boolean bl2 = bl = StringUtils.isNotEmpty((CharSequence)offsetSBActionType.getSbuid()) || StringUtils.isNotEmpty((CharSequence)offsetSBActionType.getSbname());
                if (StringUtils.isNotEmpty((CharSequence)offsetSBActionType.getSbuid())) {
                    arrayList.addAll(this.getSBsToEditedByUID(updateOffsetAction.getProjectuid(), scienceGoalArray, offsetSBActionType.getSbuid()));
                } else if (StringUtils.isNotEmpty((CharSequence)offsetSBActionType.getSbname())) {
                    arrayList.addAll(this.getSBsToBeEditedUsingSBName(updateOffsetAction.getProjectuid(), scienceGoalArray, offsetSBActionType.getSbname()));
                } else {
                    arrayList.addAll(this.getAllSBs(scienceGoalArray));
                }
                for (OffsetType offsetType : offsetSBActionType.getOffset()) {
                    for (SchedBlock schedBlock : arrayList) {
                        IntentType intentType = offsetType.getIntent();
                        if (intentType != null) {
                            this.updateOffsetForCalibrators(offsetSBActionType, schedBlock, bl, offsetType, intentType);
                            continue;
                        }
                        this.updateOffsetForNamedSource(offsetSBActionType, bl, offsetType, schedBlock);
                    }
                }
            }
            try {
                this.storeProject(projectTopLevelEntities.getObsProject(), "SBs in project " + updateOffsetAction.getProjectuid() + " updated in archive");
            }
            catch (Exception exception) {
                this.consoleOutput("Unable to store project " + updateOffsetAction.getProjectuid() + " : " + exception.getMessage());
                throw new P2GActionInterface.UnableToCompleteActionException(exception.getMessage());
            }
        }
    }

    private void updateOffsetForNamedSource(OffsetSBActionType offsetSBActionType, boolean bl, OffsetType offsetType, SchedBlock schedBlock) throws P2GActionInterface.UnableToCompleteActionException {
        boolean bl2 = false;
        for (FieldSource fieldSource : schedBlock.getFieldSource()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)fieldSource.getSourceName(), (CharSequence)offsetType.getSourcename())) continue;
            this.consoleOutput("Updating offset for " + offsetType.getSourcename());
            bl2 = true;
            this.updateOffsetForSource(fieldSource, offsetType);
        }
        if (!bl2 && bl) {
            throw new P2GActionInterface.UnableToCompleteActionException("Cannot find source " + offsetType.getSourcename() + " in SB " + offsetSBActionType.getSbuid());
        }
    }

    private void updateOffsetForCalibrators(@NonNull OffsetSBActionType offsetSBActionType, @NonNull SchedBlock schedBlock, boolean bl, OffsetType offsetType, @NonNull IntentType intentType) throws P2GActionInterface.UnableToCompleteActionException {
        List<Target> list;
        if (offsetSBActionType == null) {
            throw new NullPointerException("p2gSBsToBeUpdated is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        if (intentType == null) {
            throw new NullPointerException("intent is marked non-null but is null");
        }
        try {
            list = BatchOTXMLUnitMapper.fetchSBTargets(intentType, List.of(schedBlock));
        }
        catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
            throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
        }
        boolean bl2 = false;
        for (Target target : list) {
            this.consoleOutput("Updating offset for intent " + String.valueOf((Object)intentType));
            bl2 = true;
            this.updateOffsetForSource(target.getFieldSource(), offsetType);
        }
        if (!bl2 && bl) {
            throw new P2GActionInterface.UnableToCompleteActionException("Cannot find intent  " + String.valueOf((Object)intentType) + " in SB " + offsetSBActionType.getSbuid());
        }
    }

    private void updateOffsetForSource(@NonNull FieldSource fieldSource, @NonNull OffsetType offsetType) throws P2GActionInterface.UnableToCompleteActionException {
        boolean bl;
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        if (offsetType == null) {
            throw new NullPointerException("offsetUpdate is marked non-null but is null");
        }
        boolean bl2 = bl = offsetType.getRA() != null;
        if (bl) {
            this.setRADecOffsetCoordinates(fieldSource, offsetType);
        } else {
            this.setLonLatOffsetCoordinates(fieldSource, offsetType);
        }
    }

    private void setLonLatOffsetCoordinates(@NonNull FieldSource fieldSource, @NonNull OffsetType offsetType) throws P2GActionInterface.UnableToCompleteActionException {
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        if (offsetType == null) {
            throw new NullPointerException("offsetUpdate is marked non-null but is null");
        }
        SkyCoordinates skyCoordinates = fieldSource.getReference(0).getFieldCenterCoordinates();
        BatchOTXMLUnitMapper.AngleUnits angleUnits = null;
        try {
            angleUnits = BatchOTXMLUnitMapper.mapAngleType(offsetType.getUnit());
        }
        catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
            throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException.getMessage());
        }
        skyCoordinates.setLatitude(Latitude.createLatitude((double)offsetType.getLatitude(), (String)angleUnits.latitudeUnit()));
        skyCoordinates.setLongitude(Longitude.createLongitude((double)offsetType.getLongitude(), (String)angleUnits.latitudeUnit()));
        try {
            skyCoordinates.setType(BatchOTXMLUnitMapper.mapCoordinateType(offsetType.getCoordinatetype()));
        }
        catch (BatchOTXMLUnitMapper.UnitMappingErrorException | IllegalArgumentException exception) {
            throw new P2GActionInterface.UnableToCompleteActionException(exception.getMessage());
        }
        CoordinateSystemType coordinateSystemType = offsetType.getSystem();
        try {
            skyCoordinates.setSystem(BatchOTXMLUnitMapper.mapCoordinateSystemType(coordinateSystemType));
        }
        catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
            throw new P2GActionInterface.UnableToCompleteActionException("Unrecognised coordinate system type: " + String.valueOf((Object)coordinateSystemType));
        }
    }

    private void setRADecOffsetCoordinates(@NonNull FieldSource fieldSource, @NonNull OffsetType offsetType) throws P2GActionInterface.UnableToCompleteActionException {
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        if (offsetType == null) {
            throw new NullPointerException("offsetUpdate is marked non-null but is null");
        }
        String string = offsetType.getRA();
        double d = 0.0;
        try {
            d = Convert4dp.HHMMSSToDeg(string);
        }
        catch (InvalidCoordException | NumberFormatException exception) {
            throw new P2GActionInterface.UnableToCompleteActionException("Illegal RA specified " + string);
        }
        String string2 = offsetType.getDec();
        double d2 = 0.0;
        try {
            d2 = Convert4dp.DDMMSSToDeg(string2);
        }
        catch (InvalidCoordException | NumberFormatException exception) {
            throw new P2GActionInterface.UnableToCompleteActionException("Illegal dec specified " + string2);
        }
        SkyCoordinates skyCoordinates = fieldSource.getReference()[0].getFieldCenterCoordinates();
        skyCoordinates.setLatitude(Latitude.createLatitude((double)d2, (String)Latitude.UNIT_DEG));
        skyCoordinates.setLongitude(Longitude.createLongitude((double)d, (String)Longitude.UNIT_DEG));
        CoordinateSystemType coordinateSystemType = offsetType.getSystem();
        try {
            skyCoordinates.setSystem(BatchOTXMLUnitMapper.mapCoordinateSystemType(coordinateSystemType));
        }
        catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
            throw new P2GActionInterface.UnableToCompleteActionException("Unrecognised coordinate system type: " + String.valueOf((Object)coordinateSystemType));
        }
        try {
            skyCoordinates.setType(BatchOTXMLUnitMapper.mapCoordinateType(offsetType.getCoordinatetype()));
        }
        catch (BatchOTXMLUnitMapper.UnitMappingErrorException | IllegalArgumentException exception) {
            throw new P2GActionInterface.UnableToCompleteActionException(exception.getMessage());
        }
    }
}

