/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.scripting.BatchOT;
import alma.obsprep.ot.scripting.EditSBPerformer;
import alma.obsprep.ot.scripting.EditSBSourcePerformer;
import alma.obsprep.ot.scripting.P2GActionInterface;
import alma.obsprep.ot.scripting.P2GBatchActionXMLReader;
import alma.obsprep.ot.scripting.P2GXMLActionPerformer;
import alma.obsprep.ot.scripting.PythonEnv;
import alma.obsprep.ot.scripting.RegenerateSBPerformer;
import alma.obsprep.ot.scripting.UpdateOffsetActionPerformer;
import alma.obsprep.ot.scripting.bindings.EditSBAction;
import alma.obsprep.ot.scripting.bindings.EditSBSourceAction;
import alma.obsprep.ot.scripting.bindings.P2GBatchAction;
import alma.obsprep.ot.scripting.bindings.RegenerateSBAction;
import alma.obsprep.ot.scripting.bindings.UpdateOffsetAction;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.util.LoggingSetup;
import alma.obsprep.util.MiscUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class P2GBatchProcessor {
    private static final int FAILURE = 1;
    private static final int SUCCESS = 0;
    private static Log.Logger logger = null;
    private BatchOT batchOTHelper = null;
    private boolean isNoStoreEnabled;

    P2GBatchProcessor(@NonNull BatchOT batchOT, boolean bl) {
        if (batchOT == null) {
            throw new NullPointerException("batchOTHelper is marked non-null but is null");
        }
        this.batchOTHelper = batchOT;
        this.isNoStoreEnabled = bl;
    }

    private void processPIRequestedActions(@NonNull File file) throws P2GActionInterface.UnableToCompleteActionException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!RoleDirectoryServiceHelper.isUserP2G()) {
            System.out.println("You must have P2G privileges to use this facility");
            System.exit(1);
        }
        P2GBatchActionXMLReader p2GBatchActionXMLReader = P2GBatchActionXMLReader.getInstance();
        P2GBatchAction p2GBatchAction = null;
        try {
            p2GBatchAction = p2GBatchActionXMLReader.getP2GBatchConfiguration(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        List<Object> list = p2GBatchAction.getRegenerateSBOrUpdateOffsetOrEditSBSource();
        try {
            this.validateAllInputs(list);
        }
        catch (P2GXMLActionPerformer.InputParameterValidationException inputParameterValidationException) {
            System.out.println("Input file validation failed: " + inputParameterValidationException.getMessage());
            System.exit(1);
        }
        this.processEditSBActions(this.fetchEditSBActions(list));
        this.processEditSBSourceActions(this.fetchEditSBSourceActions(list));
        this.processRegenerateSBActions(this.fetchRegenerateSBSourceActions(list));
        this.processOffsetActions(this.fetchUpdateOffsetActions(list));
        System.out.println("P2G Batch Action XML file " + file.getName() + " successfully processed");
    }

    private void processEditSBActions(@NonNull List<EditSBAction> list) throws P2GActionInterface.UnableToCompleteActionException {
        if (list == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (!list.isEmpty()) {
            System.out.println("Updating SB parameters for specified projects");
            EditSBPerformer editSBPerformer = null;
            try {
                editSBPerformer = new EditSBPerformer(this.batchOTHelper, list, this.isNoStoreEnabled);
            }
            catch (P2GXMLActionPerformer.InputParameterValidationException inputParameterValidationException) {
                throw new P2GActionInterface.UnableToCompleteActionException(inputParameterValidationException.getMessage());
            }
            editSBPerformer.startAction();
        }
    }

    private void processEditSBSourceActions(@NonNull List<EditSBSourceAction> list) throws P2GActionInterface.UnableToCompleteActionException {
        if (list == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (!list.isEmpty()) {
            System.out.println("Updating SB parameters for specified projects");
            EditSBSourcePerformer editSBSourcePerformer = null;
            try {
                editSBSourcePerformer = new EditSBSourcePerformer(this.batchOTHelper, list, this.isNoStoreEnabled);
            }
            catch (P2GXMLActionPerformer.InputParameterValidationException inputParameterValidationException) {
                throw new P2GActionInterface.UnableToCompleteActionException(inputParameterValidationException);
            }
            editSBSourcePerformer.startAction();
        }
    }

    private void processOffsetActions(List<UpdateOffsetAction> list) throws P2GActionInterface.UnableToCompleteActionException {
        if (!list.isEmpty()) {
            System.out.println("Updating offset positions for specified projects");
            UpdateOffsetActionPerformer updateOffsetActionPerformer = null;
            try {
                updateOffsetActionPerformer = new UpdateOffsetActionPerformer(this.batchOTHelper, list, this.isNoStoreEnabled);
            }
            catch (P2GXMLActionPerformer.InputParameterValidationException inputParameterValidationException) {
                throw new P2GActionInterface.UnableToCompleteActionException(inputParameterValidationException);
            }
            updateOffsetActionPerformer.startAction();
        }
    }

    private void processRegenerateSBActions(List<RegenerateSBAction> list) throws P2GActionInterface.UnableToCompleteActionException {
        if (!list.isEmpty()) {
            System.out.println("Regenerating SBs for specified projects");
            RegenerateSBPerformer regenerateSBPerformer = null;
            try {
                regenerateSBPerformer = new RegenerateSBPerformer(this.batchOTHelper, list, this.isNoStoreEnabled);
            }
            catch (P2GXMLActionPerformer.InputParameterValidationException inputParameterValidationException) {
                throw new P2GActionInterface.UnableToCompleteActionException(inputParameterValidationException);
            }
            regenerateSBPerformer.startAction();
        }
    }

    private void validateAllInputs(@NonNull List<Object> list) throws P2GXMLActionPerformer.InputParameterValidationException {
        if (list == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
        new EditSBSourcePerformer(this.batchOTHelper, this.fetchEditSBSourceActions(list), this.isNoStoreEnabled).validateRequestedActions();
        new RegenerateSBPerformer(this.batchOTHelper, this.fetchRegenerateSBSourceActions(list), this.isNoStoreEnabled).validateRequestedActions();
        new UpdateOffsetActionPerformer(this.batchOTHelper, this.fetchUpdateOffsetActions(list), this.isNoStoreEnabled).validateRequestedActions();
    }

    @NonNull
    private List<UpdateOffsetAction> fetchUpdateOffsetActions(List<Object> list) {
        return list.stream().filter(UpdateOffsetAction.class::isInstance).map(object -> (UpdateOffsetAction)object).toList();
    }

    @NonNull
    private List<EditSBSourceAction> fetchEditSBSourceActions(@NonNull List<Object> list) {
        if (list == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
        return list.stream().filter(EditSBSourceAction.class::isInstance).map(object -> (EditSBSourceAction)object).toList();
    }

    @NonNull
    private List<EditSBAction> fetchEditSBActions(@NonNull List<Object> list) {
        if (list == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
        return list.stream().filter(EditSBAction.class::isInstance).map(object -> (EditSBAction)object).toList();
    }

    @NonNull
    private List<RegenerateSBAction> fetchRegenerateSBSourceActions(@NonNull List<Object> list) {
        if (list == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
        return list.stream().filter(RegenerateSBAction.class::isInstance).map(object -> (RegenerateSBAction)object).toList();
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        if (Stream.of(stringArray).anyMatch(string -> StringUtils.equals((CharSequence)"-h", (CharSequence)string) || StringUtils.equals((CharSequence)"--help", (CharSequence)string))) {
            P2GBatchProcessor.displayHelpInformation();
            System.exit(0);
        }
        String[] stringArray2 = null;
        if (stringArray.length > 1) {
            n = stringArray.length - 1;
            stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = stringArray[i + 1];
            }
        }
        if (Stream.of(stringArray).anyMatch(string -> StringUtils.equals((CharSequence)"-t", (CharSequence)string) || StringUtils.equals((CharSequence)"--template", (CharSequence)string))) {
            P2GBatchProcessor.displayActionFileXMLTemplate();
            System.exit(0);
        }
        n = 0;
        if (Stream.of(stringArray).anyMatch(string -> StringUtils.equals((CharSequence)"--nostore", (CharSequence)string))) {
            System.out.println("Modified projects will not be resubmitted to the archive.");
            n = 1;
        }
        if (stringArray.length < 2 || Stream.of(stringArray).noneMatch(string -> StringUtils.equals((CharSequence)"-f", (CharSequence)string) || StringUtils.equals((CharSequence)"--file", (CharSequence)string))) {
            System.out.println("A file containing the actions to be performed must be defined");
            System.exit(1);
        }
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-f") && (!stringArray[i].equals("--file") || i >= stringArray.length)) continue;
            string2 = stringArray[i + 1];
            break;
        }
        if (string2 == null) {
            System.out.println("A file containing the actions to be performed must be defined");
            System.exit(1);
        }
        BatchOT batchOT = null;
        try {
            batchOT = new BatchOT();
            LoggingSetup.consoleOutputForWarningsOnly();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        PythonEnv.initialize(null, null, stringArray2);
        PythonEnv pythonEnv = PythonEnv.getInstance(System.out, false, System.getProperties().getProperty("python.ot.libs"));
        batchOT.setHostingEnv(pythonEnv);
        pythonEnv.setVariable("batchOT", batchOT);
        logger = Log.logger(P2GBatchProcessor.class);
        File file = new File(".");
        String string3 = file.getCanonicalPath();
        logger.info("Starting ObservingTool " + InitServices.getUserVersion() + " in batch mode from " + string3);
        P2GBatchProcessor p2GBatchProcessor = new P2GBatchProcessor(batchOT, n != 0);
        try {
            p2GBatchProcessor.processPIRequestedActions(new File(string2));
        }
        catch (P2GActionInterface.UnableToCompleteActionException unableToCompleteActionException) {
            System.out.println("Unable to process input file : " + unableToCompleteActionException.getMessage());
            System.exit(1);
        }
        logger.info("P2GBatchProcessor exiting");
        System.exit(0);
    }

    private static void displayHelpInformation() {
        System.out.println("Usage: batchprocessor [-file <path to command file>] [--nostore] [-h|--help] [-t|--template]\n\nDescription\n\nA batchprocessor which accepts a command file that contains details of various\nupdates that are to be performed on projects located in the specified archive.\n\nIn order to use this script, the ALMA user which you must specify to log onto the archive must\nhave P2G privileges.\n\nArguments\n\n--file,-f <command file name>\n\n\tThe path to the XML command file that contains commands for the various updates\n    that are to be performed on the projects in the archive.\n\n-h,--help\n\n    Display this help information and quit.\n\n-t,--template\n\n   Display a template XML command file on the console and quit.\n\n   This file contains the full details of the various commands that can be used to\n   update projects in the archive and examples of their use. The user may use this\n   file as a starting point to create their own command file.\n\n--nostore\n\n   Do not update the project(s) in the archive after changing them but report the\n   changes that will be made to stdout.\n");
    }

    private static void displayActionFileXMLTemplate() {
        URL uRL = MiscUtils.findResource(new File("idl"), "batchactiontemplate.xml");
        try (Scanner scanner = new Scanner(uRL.openStream());){
            while (scanner.hasNextLine()) {
                System.out.println(scanner.nextLine());
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to find batchactiontemplate.xml file");
        }
    }
}

