/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project;

import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.Overview;
import alma.obsprep.ot.project.ProjectModel;
import alma.obsprep.ot.project.ProjectTree;

public class ProjectTreePanels {
    protected ProjectModel model = new ProjectModel(null);
    protected ProjectTree phase1Tree;
    protected ProjectTree phase2Tree;
    public Overview overview;

    public ProjectTreePanels(ObservingToolGui observingToolGui, boolean bl) {
        this.buildPhaseTrees();
        this.buildOverview(observingToolGui);
        this.phase2Tree.setGuiApi(observingToolGui);
        this.phase1Tree.setGuiApi(observingToolGui);
        if (bl) {
            this.phase1Tree.setDndReadonly(true);
            this.phase2Tree.setDndReadonly(true);
        }
    }

    protected void buildPhaseTrees() {
        this.phase2Tree = new ProjectTree(this.model, 2, true);
        this.phase1Tree = new ProjectTree(this.model, 1, false);
    }

    protected void buildOverview(ObservingToolGui observingToolGui) {
        this.overview = new Overview((Model)this.model, observingToolGui);
    }

    public void setObsProject(ObsProject obsProject) {
        this.model.setDocument(obsProject);
        this.phase2Tree.reloadFromProjectModel();
        this.phase1Tree.reloadFromProjectModel();
    }

    public ObsProject getObsProject() {
        return (ObsProject)this.model.getDocument();
    }

    public ProjectModel getModel() {
        return this.model;
    }

    public ProjectTree getPhase1Tree() {
        return this.phase1Tree;
    }

    public ProjectTree getPhase2Tree() {
        return this.phase2Tree;
    }

    public Overview getOverview() {
        return this.overview;
    }
}

