/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class InstallCert {
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public static void main(String[] stringArray) throws Exception {
        int n;
        Object object;
        if (stringArray.length != 1 && stringArray.length != 2) {
            System.out.println("Usage: java InstallCert <host>[:port] [passphrase]");
            return;
        }
        Object object2 = stringArray[0].split(":");
        String string = object2[0];
        int n2 = ((String[])object2).length == 1 ? 443 : Integer.parseInt(object2[1]);
        Object object3 = stringArray.length == 1 ? "changeit" : stringArray[1];
        char[] cArray = ((String)object3).toCharArray();
        object2 = new File("jssecacerts");
        if (!((File)object2).isFile()) {
            char c = File.separatorChar;
            object = new File(System.getProperty("java.home") + c + "lib" + c + "security");
            object2 = new File((File)object, "jssecacerts");
            if (!((File)object2).isFile()) {
                object2 = new File((File)object, "cacerts");
            }
        }
        System.out.println("Loading KeyStore " + String.valueOf(object2) + "...");
        object3 = new FileInputStream((File)object2);
        object = KeyStore.getInstance(KeyStore.getDefaultType());
        ((KeyStore)object).load((InputStream)object3, cArray);
        ((InputStream)object3).close();
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)object);
        X509TrustManager x509TrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        SavingTrustManager savingTrustManager = new SavingTrustManager(x509TrustManager);
        sSLContext.init(null, new TrustManager[]{savingTrustManager}, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        System.out.println("Opening connection to " + string + ":" + n2 + "...");
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n2);
        sSLSocket.setSoTimeout(10000);
        try {
            System.out.println("Starting SSL handshake...");
            sSLSocket.startHandshake();
            sSLSocket.close();
            System.out.println();
            System.out.println("No errors, certificate is already trusted");
        }
        catch (SSLException sSLException) {
            System.out.println();
            sSLException.printStackTrace(System.out);
        }
        X509Certificate[] x509CertificateArray = savingTrustManager.chain;
        if (x509CertificateArray == null) {
            System.out.println("Could not obtain server certificate chain");
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println();
        System.out.println("Server sent " + x509CertificateArray.length + " certificate(s):");
        System.out.println();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            X509Certificate x509Certificate = x509CertificateArray[i];
            System.out.println(" " + (i + 1) + " Subject " + String.valueOf(x509Certificate.getSubjectDN()));
            System.out.println("   Issuer  " + String.valueOf(x509Certificate.getIssuerDN()));
            messageDigest.update(x509Certificate.getEncoded());
            System.out.println("   sha1    " + InstallCert.toHexString(messageDigest.digest()));
            messageDigest2.update(x509Certificate.getEncoded());
            System.out.println("   md5     " + InstallCert.toHexString(messageDigest2.digest()));
            System.out.println();
        }
        System.out.println("Enter certificate to add to trusted keystore or 'q' to quit: [1]");
        String string2 = bufferedReader.readLine().trim();
        try {
            n = string2.length() == 0 ? 0 : Integer.parseInt(string2) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("KeyStore not changed");
            return;
        }
        X509Certificate x509Certificate = x509CertificateArray[n];
        String string3 = string + "-" + (n + 1);
        ((KeyStore)object).setCertificateEntry(string3, x509Certificate);
        FileOutputStream fileOutputStream = new FileOutputStream("jssecacerts");
        ((KeyStore)object).store(fileOutputStream, cArray);
        ((OutputStream)fileOutputStream).close();
        System.out.println();
        System.out.println(x509Certificate);
        System.out.println();
        System.out.println("Added certificate to keystore 'jssecacerts' using alias '" + string3 + "'");
    }

    private static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 3);
        for (int n : byArray) {
            stringBuilder.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            stringBuilder.append(HEXDIGITS[n & 0xF]);
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager x509TrustManager) {
            this.tm = x509TrustManager;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.chain = x509CertificateArray;
            this.tm.checkServerTrusted(x509CertificateArray, string);
        }
    }
}

