/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.persistence;

import alma.entities.commonentity.EntityRefT;
import alma.entity.xmlbinding.obsproposal.ObsProposal;
import alma.entity.xmlbinding.schedblock.SchedBlock;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.bo.EntityPart;
import alma.hla.runtime.obsprep.bo.EntityPartProxy;
import alma.hla.runtime.obsprep.bo.EntityProxy;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceableProxy;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.hla.runtime.obsprep.util.XmlConversionException;
import alma.hla.runtime.obsprep.util.XmlMarshaller;
import alma.obsprep.bo.obsattachment.DocumentLink;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsreview.ObsReview;
import alma.obsprep.util.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class Apdm_to_BO {
    private static Apdm_to_BO inst = new Apdm_to_BO();
    private final boolean dbg = false;
    private int _dbg_depth = 0;

    public static Apdm_to_BO getInstance() {
        return inst;
    }

    public static BoBundle decompose(ObsProject obsProject) throws UnknownEntityException {
        BoBundle boBundle = new BoBundle();
        alma.obsprep.bo.obsproposal.ObsProposal obsProposal = obsProject.getObsProposal();
        ObsAttachment obsAttachment = null;
        if (obsProposal != null) {
            try {
                obsAttachment = obsProposal.getDocuments();
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
        }
        List<alma.obsprep.bo.schedblock.SchedBlock> list = obsProject.getObsProgram().getObsPlan().findSchedBlocks();
        List<alma.obsprep.bo.schedblock.SchedBlock> list2 = obsProposal != null ? obsProposal.getObsPlan().findSchedBlocks() : Collections.EMPTY_LIST;
        ObsReview obsReview = null;
        try {
            obsReview = obsProject.gettrueObsReview();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        List<alma.obsprep.bo.schedblock.SchedBlock> list3 = Collections.EMPTY_LIST;
        if (obsReview != null && obsReview.gettrueObsPlan() != null) {
            list3 = obsReview.getObsPlan().findSchedBlocks();
        }
        boBundle.boProject = obsProject;
        boBundle.boProposal = obsProposal;
        boBundle.boDocuments = obsAttachment;
        boBundle.boReview = obsReview;
        boBundle.boSchedblocks.addAll(list2);
        boBundle.boSchedblocks.addAll(list);
        boBundle.boSchedblocks.addAll(list3);
        return boBundle;
    }

    public static BoBundle decomposeIncludingFiles(ObsProject obsProject) throws UnknownEntityException, IOException {
        BoBundle boBundle = Apdm_to_BO.decompose(obsProject);
        if (boBundle.boDocuments != null) {
            File file = FileUtilities.getTmpDir();
            for (DocumentLink documentLink : boBundle.boDocuments.getDocumentLink()) {
                boBundle.documents.add(new File(file, documentLink.getFileName()));
            }
        }
        return boBundle;
    }

    public static SoBundle down(BoBundle boBundle) {
        SoBundle soBundle = new SoBundle();
        if (boBundle.boProject != null) {
            soBundle.soProject = boBundle.boProject.getCastorObject();
        }
        if (boBundle.boProposal != null) {
            soBundle.soProposal = boBundle.boProposal.getCastorObject();
        }
        if (boBundle.boDocuments != null) {
            soBundle.soDocuments = boBundle.boDocuments.getCastorObject();
        }
        if (boBundle.boReview != null) {
            soBundle.soReview = boBundle.boReview.getCastorObject();
        }
        for (alma.obsprep.bo.schedblock.SchedBlock schedBlock : boBundle.boSchedblocks) {
            soBundle.soSchedblocks.add(schedBlock.getCastorObject());
        }
        return soBundle;
    }

    public static XmlBundle down(SoBundle soBundle) throws XmlConversionException, IOException {
        XmlBundle xmlBundle = new XmlBundle();
        XmlMarshaller xmlMarshaller = new XmlMarshaller();
        String string = System.getProperty("OTDataModelVersion", "NULL");
        soBundle.soProject.setSchemaVersion(string);
        soBundle.soProject.getObsProjectEntity().setSchemaVersion(string);
        xmlBundle.xmlProj = xmlMarshaller.marshalToString((Object)soBundle.soProject);
        if (soBundle.soProposal != null) {
            soBundle.soProposal.setSchemaVersion(string);
            soBundle.soProposal.getObsProposalEntity().setSchemaVersion(string);
            xmlBundle.xmlProp = xmlMarshaller.marshalToString((Object)soBundle.soProposal);
        }
        if (soBundle.soDocuments != null) {
            soBundle.soDocuments.setSchemaVersion(string);
            soBundle.soDocuments.getObsAttachmentEntity().setSchemaVersion(string);
            xmlBundle.xmlDocs = xmlMarshaller.marshalToString((Object)soBundle.soDocuments);
        }
        if (soBundle.soReview != null) {
            soBundle.soReview.setSchemaVersion(string);
            soBundle.soReview.getObsReviewEntity().setSchemaVersion(string);
            xmlBundle.xmlReview = xmlMarshaller.marshalToString((Object)soBundle.soReview);
        }
        for (SchedBlock schedBlock : soBundle.soSchedblocks) {
            schedBlock.setSchemaVersion(string);
            schedBlock.getSchedBlockEntity().setSchemaVersion(string);
            String string2 = xmlMarshaller.marshalToString((Object)schedBlock);
            xmlBundle.xmlSBs.add(string2);
        }
        return xmlBundle;
    }

    public BoBundle adopt(SoBundle soBundle) {
        return this.adopt(soBundle.soProject, soBundle.soProposal, soBundle.soDocuments, soBundle.soReview, soBundle.soSchedblocks);
    }

    public BoBundle adopt(alma.entity.xmlbinding.obsproject.ObsProject obsProject, ObsProposal obsProposal, alma.entity.xmlbinding.obsattachment.ObsAttachment obsAttachment, alma.entity.xmlbinding.obsreview.ObsReview obsReview, List<SchedBlock> list) {
        Object object;
        BoBundle boBundle = new BoBundle();
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        if (obsProject != null) {
            object = new ObsProject(obsProject);
            boBundle.boProject = object;
            arrayList.add((Entity)object);
        }
        if (obsProposal != null) {
            object = new alma.obsprep.bo.obsproposal.ObsProposal(obsProposal);
            boBundle.boProposal = object;
            arrayList.add((Entity)object);
        }
        if (obsAttachment != null) {
            object = new ObsAttachment(obsAttachment);
            boBundle.boDocuments = object;
            arrayList.add((Entity)object);
        }
        if (obsReview != null) {
            object = new ObsReview(obsReview);
            boBundle.boReview = object;
            arrayList.add((Entity)object);
        }
        if (list != null) {
            for (SchedBlock schedBlock : list) {
                alma.obsprep.bo.schedblock.SchedBlock schedBlock2 = new alma.obsprep.bo.schedblock.SchedBlock(schedBlock);
                boBundle.boSchedblocks.add(schedBlock2);
                arrayList.add((Entity)schedBlock2);
            }
        }
        this.resolveReferences(arrayList);
        for (IBusinessObject iBusinessObject : arrayList) {
            this.establishReferrersBelow(iBusinessObject);
        }
        for (IBusinessObject iBusinessObject : arrayList) {
            this.notifyAdopted(iBusinessObject);
        }
        return boBundle;
    }

    public void resolveReferences(List<Entity> list) {
        ReferenceablesMap referenceablesMap = new ReferenceablesMap();
        ArrayList<ReferenceableProxy<? extends IBusinessObject>> arrayList = new ArrayList<ReferenceableProxy<? extends IBusinessObject>>();
        for (IBusinessObject iBusinessObject : list) {
            this.wrapObjectsBelow(iBusinessObject, referenceablesMap, arrayList);
        }
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ReferenceableProxy referenceableProxy = (ReferenceableProxy)iterator.next();
            EntityRefT entityRefT = referenceableProxy.getEntityRefT();
            if (referenceableProxy instanceof EntityPartProxy) {
                ((EntityPartProxy)referenceableProxy).setReference((EntityPart)referenceablesMap.get(null, entityRefT.getPartId()));
                iterator.remove();
                continue;
            }
            ((EntityProxy)referenceableProxy).setReference((Entity)referenceablesMap.get(entityRefT.getEntityId(), null));
            iterator.remove();
        }
        if (Log.logger(Apdm_to_BO.class).isLoggable(Level.FINE) && arrayList.size() > 0) {
            Log.logger(Apdm_to_BO.class).fine(arrayList.size() + " referrers proxies couldn't resolve their target BOs. This might lead to future UnknownEntityExceptions");
        }
    }

    protected void wrapObjectsBelow(IBusinessObject iBusinessObject, ReferenceablesMap referenceablesMap, List<ReferenceableProxy<? extends IBusinessObject>> list) {
        this._dbg_push(iBusinessObject);
        ((BusinessObject)iBusinessObject).wrapObjects(referenceablesMap, list);
        for (IBusinessObject iBusinessObject2 : iBusinessObject.referencedBOs(new Referring.By[]{Referring.By.UmlComposition, Referring.By.UmlAttribution})) {
            this._dbg_print(iBusinessObject2);
            if (iBusinessObject2 instanceof Entity) continue;
            this.wrapObjectsBelow(iBusinessObject2, referenceablesMap, list);
        }
        this._dbg_pop();
    }

    protected void establishReferrersBelow(IBusinessObject iBusinessObject) {
        this._dbg_push(iBusinessObject);
        for (IBusinessObject iBusinessObject2 : iBusinessObject.referencedBOs(new Referring.By[]{Referring.By.UmlComposition})) {
            this._dbg_print(iBusinessObject2);
            this._dbg_sanity(iBusinessObject2);
            ((BusinessObject)iBusinessObject2).addedTo(iBusinessObject, Referring.By.UmlComposition, -1);
            if (iBusinessObject2 instanceof Entity) continue;
            this.establishReferrersBelow(iBusinessObject2);
        }
        for (IBusinessObject iBusinessObject2 : iBusinessObject.referencedBOs(new Referring.By[]{Referring.By.UmlUnidir})) {
            this._dbg_print(iBusinessObject2);
            this._dbg_sanity(iBusinessObject2, iBusinessObject);
            ((BusinessObject)iBusinessObject2).addedTo(iBusinessObject, Referring.By.UmlUnidir, -1);
        }
        this._dbg_pop();
    }

    protected void notifyAdopted(IBusinessObject iBusinessObject) {
        for (IBusinessObject iBusinessObject2 : iBusinessObject.referencedBOs(new Referring.By[]{Referring.By.UmlComposition, Referring.By.UmlAttribution})) {
            if (iBusinessObject2 instanceof Entity) continue;
            ((BusinessObject)iBusinessObject2).updateLocalReference();
            this.notifyAdopted(iBusinessObject2);
        }
    }

    private void _dbg_sanity(IBusinessObject iBusinessObject) {
    }

    private void _dbg_sanity(IBusinessObject iBusinessObject, IBusinessObject iBusinessObject2) {
    }

    private void _dbg_push(Object object) {
    }

    private void _dbg_print(Object object) {
    }

    private void _dbg_pop() {
    }

    public static class BoBundle {
        public ObsProject boProject;
        public alma.obsprep.bo.obsproposal.ObsProposal boProposal;
        public ObsAttachment boDocuments;
        public ObsReview boReview;
        public List<alma.obsprep.bo.schedblock.SchedBlock> boSchedblocks = new ArrayList<alma.obsprep.bo.schedblock.SchedBlock>();
        public List<File> documents = new ArrayList<File>();

        public List<Entity> entities() {
            ArrayList<Entity> arrayList = new ArrayList<Entity>();
            if (this.boProject != null) {
                arrayList.add((Entity)this.boProject);
            }
            if (this.boProposal != null) {
                arrayList.add((Entity)this.boProposal);
            }
            if (this.boDocuments != null) {
                arrayList.add((Entity)this.boDocuments);
            }
            if (this.boReview != null) {
                arrayList.add((Entity)this.boReview);
            }
            for (alma.obsprep.bo.schedblock.SchedBlock schedBlock : this.boSchedblocks) {
                arrayList.add((Entity)schedBlock);
            }
            return arrayList;
        }

        public String toString() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (alma.obsprep.bo.schedblock.SchedBlock schedBlock : this.boSchedblocks) {
                arrayList.add(schedBlock.getEntityID());
            }
            return "SoBundle(ObsProject=" + (this.boProject == null ? "null" : this.boProject.getEntityID()) + ", ObsProposal=" + (this.boProposal == null ? "null" : this.boProposal.getEntityID()) + ", ObsAttachment=" + (this.boDocuments == null ? "null" : this.boDocuments.getEntityID()) + ", ObsReview=" + (this.boReview == null ? "null" : this.boReview.getEntityID()) + ", SchedBlocks=" + ((Object)arrayList).toString() + ", Documents=" + this.documents.toString() + ")";
        }
    }

    public static class SoBundle {
        public alma.entity.xmlbinding.obsproject.ObsProject soProject;
        public ObsProposal soProposal;
        public alma.entity.xmlbinding.obsattachment.ObsAttachment soDocuments;
        public alma.entity.xmlbinding.obsreview.ObsReview soReview;
        public List<SchedBlock> soSchedblocks = new ArrayList<SchedBlock>();

        public String toString() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SchedBlock schedBlock : this.soSchedblocks) {
                arrayList.add(schedBlock.getSchedBlockEntity().getEntityId());
            }
            return "SoBundle(ObsProject=" + (this.soProject == null ? "null" : this.soProject.getObsProjectEntity().getEntityId()) + ", ObsProposal=" + (this.soProposal == null ? "null" : this.soProposal.getObsProposalEntity().getEntityId()) + ", ObsAttachment=" + (this.soDocuments == null ? "null" : this.soDocuments.getObsAttachmentEntity().getEntityId()) + ", ObsReview=" + (this.soReview == null ? "null" : this.soReview.getObsReviewEntity().getEntityId()) + ", SchedBlocks=" + ((Object)arrayList).toString() + ")";
        }
    }

    public static class XmlBundle {
        public String xmlProj;
        public String xmlProp;
        public String xmlDocs;
        public String xmlReview;
        public List<String> xmlSBs = new ArrayList<String>();
    }
}

