/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.obsprep.bo.obsproject.DataProcessingParameters;
import alma.obsprep.bo.obsproject.ObsUnit;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.models.obsproject.ObsUnitModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.VelocityModel;
import alma.valuetypes.Angle;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Temperature;
import alma.valuetypes.Velocity;

public class ObsUnitSetModel
extends ObsUnitModel {
    private ValueUnitPairModel angularResolutionModel = new ValueUnitPairModel(null, FieldIDs.angularResolutionValueFID, FieldIDs.angularResolutionUnitsFID);
    private VelocityModel velocityResolutionModel = new VelocityModel(null, FieldIDs.velocityResolutionValueFID, FieldIDs.velocityResolutionUnitsFID, FieldIDs.velocityResolutionSystemFID, FieldIDs.velocityResolutionDopplerFID, FieldIDs.velocityResolutionRedshiftFID);
    private ValueUnitPairModel tbSensitivityGoalModel = new ValueUnitPairModel(null, FieldIDs.tbSensitivityValueFID, FieldIDs.tbSensitivityUnitsFID);
    private ValueUnitPairModel rmsGoalModel = new ValueUnitPairModel(null, FieldIDs.rmsGoalValueFID, FieldIDs.rmsGoalUnitsFID);

    public ObsUnitSetModel(ObsUnitSet obsUnitSet) {
        super((ObsUnit)((Object)obsUnitSet));
    }

    private ObsUnitSet getObsUnitSet() {
        return (ObsUnitSet)this.getDocument();
    }

    public ValueUnitPairModel getTBSensitivityModel() {
        return this.tbSensitivityGoalModel;
    }

    public ValueUnitPairModel getRMSGoalModel() {
        return this.rmsGoalModel;
    }

    @Override
    public void publish() {
        ObsUnitSet obsUnitSet = this.getObsUnitSet();
        if (obsUnitSet == null) {
            return;
        }
        super.publish();
        this.publish(FieldIDs.controlScriptFID, obsUnitSet.getFlowControl().getControlScript());
        this.publish(FieldIDs.scienceProcessingScriptFID, obsUnitSet.getScienceProcessingScript());
        this.publish(FieldIDs.projectTypeFID, obsUnitSet.getDataProcessingParameters().getProjectType());
        this.publish(FieldIDs.runSciencePipelineFID, obsUnitSet.getRunSciencePipeline());
        this.getAngularResolutionModel().publish();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        String string = object.toString();
        ObsUnitSet obsUnitSet = this.getObsUnitSet();
        obsUnitSet.getFlowControl();
        Object object2 = object;
        if (fieldID.equals(FieldIDs.controlScriptFID)) {
            obsUnitSet.getFlowControl().setControlScript(string);
        } else if (fieldID.equals(FieldIDs.scienceProcessingScriptFID)) {
            obsUnitSet.setScienceProcessingScript(string);
        } else if (fieldID.equals(FieldIDs.projectTypeFID)) {
            obsUnitSet.getDataProcessingParameters().setProjectType(string);
        } else if (fieldID.equals(FieldIDs.runSciencePipelineFID)) {
            obsUnitSet.setRunSciencePipeline((Boolean)object);
        } else {
            object2 = fieldID.equals(FieldIDs.angularResolutionValueFID) || fieldID.equals(FieldIDs.angularResolutionUnitsFID) ? this.getAngularResolutionModel().update(editor, fieldID, object) : (fieldID.equals(FieldIDs.velocityResolutionValueFID) || fieldID.equals(FieldIDs.velocityResolutionUnitsFID) ? this.getVelocityResolutionModel().update(editor, fieldID, object) : (fieldID.equals(FieldIDs.tbSensitivityValueFID) || fieldID.equals(FieldIDs.tbSensitivityUnitsFID) ? this.getTBSensitivityModel().update(editor, fieldID, object) : (fieldID.equals(FieldIDs.rmsGoalValueFID) || fieldID.equals(FieldIDs.rmsGoalUnitsFID) ? this.getRMSGoalModel().update(editor, fieldID, object) : super.update(editor, fieldID, object))));
        }
        return object2;
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        DataProcessingParameters dataProcessingParameters = this.getObsUnitSet().getDataProcessingParameters();
        Angle angle = dataProcessingParameters.getAngularResolution();
        this.angularResolutionModel.setDocument((Object)angle);
        Velocity velocity = dataProcessingParameters.getVelocityResolution();
        this.velocityResolutionModel.setDocument((Object)velocity);
        Temperature temperature = dataProcessingParameters.getTBSensitivityGoal();
        this.tbSensitivityGoalModel.setDocument((Object)temperature);
        Sensitivity sensitivity = dataProcessingParameters.getRMSGoal();
        this.rmsGoalModel.setDocument((Object)sensitivity);
    }

    public ValueUnitPairModel getAngularResolutionModel() {
        return this.angularResolutionModel;
    }

    public VelocityModel getVelocityResolutionModel() {
        return this.velocityResolutionModel;
    }
}

