/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.misc;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.misc.ExpertParametersEditor;
import alma.obsprep.ot.models.misc.ExpertParametersTableModel;
import alma.valuetypes.KeywordValue;
import java.util.Arrays;
import java.util.List;

public class ExpertParametersModel
extends Model
implements ModelChangeSubscriber {
    private ExpertParametersTableModel epTableModel = new ExpertParametersTableModel(this);

    public ExpertParametersModel(Object object) {
        super(object);
    }

    public ExpertParametersTableModel getExpertParametersTableModel() {
        return this.epTableModel;
    }

    public List<KeywordValue> getKeywordValuePairs() {
        if (this.document instanceof ObservingParameters) {
            return Arrays.asList(((ObservingParameters)this.document).getExpertParameter());
        }
        if (this.document instanceof SchedBlock) {
            return Arrays.asList(((SchedBlock)this.document).getExpertParameter());
        }
        if (this.document instanceof ScienceGoal) {
            return Arrays.asList(((ScienceGoal)this.document).getExpertParameters());
        }
        return null;
    }

    @Override
    public void publish() {
        List<KeywordValue> list = this.getKeywordValuePairs();
        if (list != null) {
            this.publish(ExpertParametersEditor.KEYWORDVALUE_TABLE_FID, list);
        }
    }

    public KeywordValue addKeywordValuePair(int n) {
        KeywordValue keywordValue = KeywordValue.createKeywordValue();
        keywordValue.setKeyword("Enter keyword");
        keywordValue.setValue("Enter value");
        if (n == -1) {
            n = this.getKeywordValuePairCount();
        }
        if (this.getDocument() instanceof ObservingParameters) {
            ((ObservingParameters)this.getDocument()).addExpertParameter(n, keywordValue);
        } else if (this.getDocument() instanceof SchedBlock) {
            ((SchedBlock)this.getDocument()).addExpertParameter(n, keywordValue);
        } else if (this.getDocument() instanceof ScienceGoal) {
            ((ScienceGoal)this.getDocument()).addExpertParameters(n, keywordValue);
        }
        this.getExpertParametersTableModel().fireTableRowsInserted(n, n);
        return keywordValue;
    }

    public void deleteKeywordValuePair(int n) {
        List<KeywordValue> list = this.getKeywordValuePairs();
        if (list == null) {
            return;
        }
        if (n != -1) {
            KeywordValue keywordValue = list.get(n);
            if (this.getDocument() instanceof ObservingParameters) {
                ((ObservingParameters)this.getDocument()).removeExpertParameter(keywordValue);
            } else if (this.getDocument() instanceof SchedBlock) {
                ((SchedBlock)this.getDocument()).removeExpertParameter(keywordValue);
            } else if (this.getDocument() instanceof ScienceGoal) {
                ((ScienceGoal)this.getDocument()).removeExpertParameters(keywordValue);
            }
            this.getExpertParametersTableModel().fireTableRowsDeleted(n, n);
        }
    }

    public int getKeywordValuePairCount() {
        ExpertParametersTableModel expertParametersTableModel = this.getExpertParametersTableModel();
        return expertParametersTableModel == null ? 0 : expertParametersTableModel.getRowCount();
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        this.epTableModel.fireTableStructureChanged();
        this.publish();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return null;
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
    }
}

