/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.obsprep.ot.gui.toplevel.OTOperationsTableModel;
import alma.obsprep.roledirectory.DenyAllRoleDirectory;
import alma.obsprep.roledirectory.OTOperation;
import alma.obsprep.roledirectory.RoleDirectory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.layout.GroupLayout;

public class OTOperationsDialog
extends JDialog {
    private static Collection<OTOperation> IGNORED_OPERATIONS;
    private JButton dismissButton;
    private JLabel label;
    private JScrollPane scrollPane;
    private JTable table;
    private OTOperationsTableModel tableModel = new OTOperationsTableModel();

    public OTOperationsDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    public void setRoleDirectory(RoleDirectory roleDirectory) {
        Set<OTOperation> set = this.getAllowedOTOperations(roleDirectory);
        this.tableModel.setOTOperations(set);
    }

    private Set<OTOperation> getAllowedOTOperations(RoleDirectory roleDirectory) {
        LinkedHashSet<OTOperation> linkedHashSet = new LinkedHashSet<OTOperation>();
        for (OTOperation oTOperation : OTOperation.ALL_OPERATIONS) {
            try {
                if (!roleDirectory.canExecute(oTOperation)) continue;
                linkedHashSet.add(oTOperation);
            }
            catch (IOException iOException) {}
        }
        linkedHashSet.removeAll(IGNORED_OPERATIONS);
        return linkedHashSet;
    }

    private void initComponents() {
        this.label = new JLabel();
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.dismissButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.label.setText("You can perform the following operations:");
        this.table.setModel(this.tableModel);
        this.scrollPane.setViewportView(this.table);
        this.dismissButton.setText("Dismiss");
        this.dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OTOperationsDialog.this.dismissButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.label).add(0, 107, Short.MAX_VALUE)).add((Component)this.scrollPane, -2, 0, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.dismissButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.label).addPreferredGap(0).add((Component)this.scrollPane, -1, 222, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.dismissButton).addContainerGap()));
        this.pack();
    }

    private void dismissButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public static void main(String[] stringArray) {
        try {
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(lookAndFeelInfo.getName())) continue;
                UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(OTOperationsDialog.class.getName()).log(Level.SEVERE, null, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Logger.getLogger(OTOperationsDialog.class.getName()).log(Level.SEVERE, null, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(OTOperationsDialog.class.getName()).log(Level.SEVERE, null, illegalAccessException);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            Logger.getLogger(OTOperationsDialog.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OTOperationsDialog oTOperationsDialog = new OTOperationsDialog((Frame)new JFrame(), true);
                oTOperationsDialog.addWindowListener(new WindowAdapter(this){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                oTOperationsDialog.setRoleDirectory(new DenyAllRoleDirectory());
                oTOperationsDialog.setVisible(true);
            }
        });
    }

    static {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, OTOperation.SERVICE_PING, OTOperation.IS_AUTHENTICATED);
        IGNORED_OPERATIONS = Collections.unmodifiableCollection(arrayList);
    }
}

