/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class FoldTextPane
extends JEditorPane
implements HyperlinkListener {
    private final String collapseHandle;
    private final String expandHandle;
    private final String messageDescription;
    private final String messageTitle;

    FoldTextPane(String string, String string2) {
        this.messageTitle = string;
        this.messageDescription = string2;
        this.expandHandle = "<a href='file://expand'><em>(click for details)</em></a>";
        this.collapseHandle = "<a href='file://collapse'><em>(hide details)</em></a>";
        this.setEditable(false);
        this.setContentType("text/html");
        this.addHyperlinkListener(this);
        this.showShortDescription();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        String string = hyperlinkEvent.getURL().toString().substring(7);
        if ("expand".equals(string)) {
            this.showLongDescription();
        }
        if ("collapse".equals(string)) {
            this.showShortDescription();
        }
    }

    private void showLongDescription() {
        this.setText(this.messageTitle + "&nbsp;&nbsp;" + this.collapseHandle + "<br>" + this.messageDescription);
    }

    private void showShortDescription() {
        this.setText(this.messageTitle + "&nbsp;&nbsp;" + this.expandHandle);
    }

    public String getMessageDescription() {
        return this.messageDescription;
    }

    public String getMessageTitle() {
        return this.messageTitle;
    }
}

