/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.preferences;

import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.obstooluserprefs.types.BLCorrelatorType;
import alma.obsprep.obstooluserprefs.types.TelescopeType;
import alma.obsprep.ot.gui.preferences.AbstractPanel;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.PreferencesReadWrite;
import java.util.Enumeration;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TelescopePanel
extends AbstractPanel
implements PreferencesReadWrite {
    JPanel pnlStripe1 = new JPanel();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JRadioButton btnTelescopeAlma = new JRadioButton();
    JRadioButton btnTelescopeAtf = new JRadioButton();
    JRadioButton btnTelescopeEsAlma = new JRadioButton();
    JLabel lblCaption1 = new JLabel();
    JPanel pnlStripe2 = new JPanel();
    ButtonGroup buttonGroup2 = new ButtonGroup();
    JRadioButton btnCorr4Quad = new JRadioButton();
    JRadioButton btnCorr2Quad = new JRadioButton();
    JRadioButton btnCorr1Quad = new JRadioButton();
    JRadioButton btnCorr2Ants = new JRadioButton();

    public TelescopePanel(ObservingToolGui observingToolGui) {
        this.initialize();
    }

    void initialize() {
        this.setName("TelescopePrefs");
        this.btnTelescopeAlma.setName("TelescopePrefs.btnTelescopeAlma");
        this.btnTelescopeAtf.setName("TelescopePrefs.btnTelescopeAtf");
        this.btnTelescopeEsAlma.setName("TelescopePrefs.btnTelescopeEsAlma");
        this.btnCorr4Quad.setName("TelescopePrefs.btnCorr4Quad");
        this.btnCorr2Quad.setName("TelescopePrefs.btnCorr2Quad");
        this.btnCorr1Quad.setName("TelescopePrefs.btnCorr1Quad");
        this.btnCorr2Ants.setName("TelescopePrefs.btnCorr2Ants");
        this.btnTelescopeAlma.setText("ALMA - The full featured ALMA");
        this.buttonGroup1.add(this.btnTelescopeAlma);
        this.btnTelescopeAlma.setEnabled(false);
        this.btnTelescopeEsAlma.setText("ES ALMA - Early Science ALMA");
        this.buttonGroup1.add(this.btnTelescopeEsAlma);
        this.btnTelescopeEsAlma.setEnabled(false);
        this.pnlStripe1.setLayout(new BoxLayout(this.pnlStripe1, 1));
        this.pnlStripe1.add(new JLabel("This will modify the telescope characteristics that the Observing Tool uses"));
        this.pnlStripe1.add(new JLabel("Early Science Version still in development"));
        this.pnlStripe1.add(new JLabel(" "));
        this.pnlStripe1.add(new JLabel("These choices currently disabled - to use a different setup run the specific ALMA OT version"));
        this.pnlStripe1.add(new JLabel(" "));
        this.pnlStripe1.add(this.btnTelescopeAlma);
        this.pnlStripe1.add(this.btnTelescopeEsAlma);
        super.addStripe("Select Telescope", this.pnlStripe1, false);
        this.btnCorr4Quad.setText("The full featured BL correlator ( 4 Quadrants )");
        this.buttonGroup2.add(this.btnCorr4Quad);
        this.btnCorr2Quad.setText("Limited capability of BL correlator ( 2 Quadrants )");
        this.buttonGroup2.add(this.btnCorr2Quad);
        this.btnCorr1Quad.setText("Limited capability of BL correlator ( 1 Quadrant )");
        this.buttonGroup2.add(this.btnCorr1Quad);
        this.btnCorr2Ants.setText("Limited capability of BL correlator ( 2 Antennas )");
        this.buttonGroup2.add(this.btnCorr2Ants);
        this.pnlStripe2.setLayout(new BoxLayout(this.pnlStripe2, 1));
        this.pnlStripe2.add(new JLabel("This allows the selection of restricted BL correlator features."));
        this.pnlStripe2.add(new JLabel("Currently it only affects the validation of SBs, it does not restrict"));
        this.pnlStripe2.add(new JLabel("the creation of configurations."));
        this.pnlStripe2.add(new JLabel("This feature is under testing: please report any problems"));
        this.pnlStripe2.add(new JLabel(" "));
        this.pnlStripe2.add(this.btnCorr4Quad);
        this.pnlStripe2.add(this.btnCorr2Quad);
        this.pnlStripe2.add(this.btnCorr1Quad);
        this.pnlStripe2.add(this.btnCorr2Ants);
        super.addStripe("Select BL Correlator Type", this.pnlStripe2, false);
    }

    @Override
    public void readPreferences(ObsToolUserPrefs obsToolUserPrefs) {
        TelescopeType telescopeType;
        Enumeration enumeration;
        String string;
        if (obsToolUserPrefs.getTelescope() == null) {
            string = System.getProperty("Telescope", "ALMA");
            enumeration = TelescopeType.enumerate();
            while (enumeration.hasMoreElements()) {
                telescopeType = (TelescopeType)enumeration.nextElement();
                if (!string.equals(telescopeType.toString())) continue;
                obsToolUserPrefs.setTelescope(telescopeType);
            }
        }
        this.btnTelescopeAlma.setSelected(obsToolUserPrefs.getTelescope().equals(TelescopeType.ALMA));
        this.btnTelescopeEsAlma.setSelected(obsToolUserPrefs.getTelescope().equals(TelescopeType.ESALMA));
        if (obsToolUserPrefs.getBLCorrelator() == null) {
            string = System.getProperty("BLCorrelator", BLCorrelatorType.CORRELATOR_12M_4QUADRANT.toString());
            enumeration = BLCorrelatorType.enumerate();
            while (enumeration.hasMoreElements()) {
                telescopeType = (BLCorrelatorType)enumeration.nextElement();
                if (!string.equals(telescopeType.toString())) continue;
                obsToolUserPrefs.setBLCorrelator((BLCorrelatorType)telescopeType);
            }
        }
        this.btnCorr4Quad.setSelected(obsToolUserPrefs.getBLCorrelator().equals(BLCorrelatorType.CORRELATOR_12M_4QUADRANT));
        this.btnCorr2Quad.setSelected(obsToolUserPrefs.getBLCorrelator().equals(BLCorrelatorType.CORRELATOR_12M_2QUADRANT));
        this.btnCorr1Quad.setSelected(obsToolUserPrefs.getBLCorrelator().equals(BLCorrelatorType.CORRELATOR_12M_1QUADRANT));
        this.btnCorr2Ants.setSelected(obsToolUserPrefs.getBLCorrelator().equals(BLCorrelatorType.CORRELATOR_12M_2ANTS));
    }

    @Override
    public void writePreferences(ObsToolUserPrefs obsToolUserPrefs) {
        BLCorrelatorType bLCorrelatorType = BLCorrelatorType.CORRELATOR_12M_4QUADRANT;
        if (this.btnCorr2Quad.isSelected()) {
            bLCorrelatorType = BLCorrelatorType.CORRELATOR_12M_2QUADRANT;
        } else if (this.btnCorr1Quad.isSelected()) {
            bLCorrelatorType = BLCorrelatorType.CORRELATOR_12M_1QUADRANT;
        } else if (this.btnCorr2Ants.isSelected()) {
            bLCorrelatorType = BLCorrelatorType.CORRELATOR_12M_2ANTS;
        }
        obsToolUserPrefs.setBLCorrelator(bLCorrelatorType);
        System.setProperty("BLCorrelator", bLCorrelatorType.toString());
        SiteCharacteristics.refreshCharacteristics();
        AlmaCapabilities.refreshCapabilities();
        AlmaPolicies.refreshPolicies();
    }
}

