/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.preferences;

import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.obstooluserprefs.types.WebSubmissionHostType;
import alma.obsprep.ot.gui.preferences.AbstractPanel;
import alma.obsprep.ot.gui.toplevel.OTOperationsDialog;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.PreferencesReadWrite;
import alma.obsprep.ot.gui.toplevel.UserAuthenticator;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.VerticalFlowLayout;
import alma.obsprep.util.job.AbstractJob;
import alma.obsprep.util.job.JobUtility;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConnectionPanel
extends AbstractPanel
implements PreferencesReadWrite {
    private final ObservingToolController controller;
    UserAuthenticator.CredentialPanel credPanel;
    JPanel userAuth;
    JPanel pnlStripe1;
    JButton btnTestLogin;
    JButton btnTestConnection;
    JLabel lblSimulationReminder;
    JButton rolesButton = new JButton("Show Permissions...");
    JPanel projRep = new JPanel();
    JComboBox<String> cmbSubmissionUrl = new JComboBox();
    JPanel pnlStripe2;

    public ConnectionPanel(ObservingToolController observingToolController) {
        this.controller = observingToolController;
        this.setName("ConnectionPrefs");
        this.initialize();
    }

    void initialize() {
        this.cmbSubmissionUrl.setName("ConnectionPrefs.cmbSubmissionUrl");
        this.userAuth = new JPanel();
        this.userAuth.setLayout(new VerticalFlowLayout());
        this.btnTestLogin = new JButton(new AbstractAction("<html>Change&nbsp;Account&nbsp;/<br>Login&nbsp;to&nbsp;ALMA"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ConnectionPanel.this.controller.getUserAuthenticator().getServerUrl();
                this.setEnabled(false);
                new AbstractJob("connect to " + string, false, JobUtility.otqueue){

                    @Override
                    public void job() throws Exception {
                        try {
                            RoleDirectoryService.ExternalState externalState = ConnectionPanel.this.controller.getRoleDirectory().attemptConnectionAndLogin();
                            if (externalState != null) {
                                switch (externalState.code) {
                                    case offline_badurl: 
                                    case offline_notfound: {
                                        GUIUtilities.error(null, "Could not log you in.\nServer not found at " + externalState.url + "\n");
                                        break;
                                    }
                                    case online_loggedin: {
                                        GUIUtilities.info(null, "You are logged in.\n");
                                        break;
                                    }
                                    case offline_default: 
                                    case online_loggedout: {
                                        GUIUtilities.info(null, "Login not done\n");
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            new AbstractJob("", false, JobUtility.swing){

                                @Override
                                public void job() {
                                    this.setEnabled(true);
                                }
                            }.go();
                            throw throwable;
                        }
                        new /* invalid duplicate definition of identical inner class */.go();
                    }
                }.go();
            }
        });
        this.btnTestConnection = new JButton(new AbstractAction("Test Connection"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ConnectionPanel.this.controller.getUserAuthenticator().getServerUrl();
                this.setEnabled(false);
                this.putValue("Name", "Connecting...");
                new AbstractJob("connect to " + string, false, JobUtility.otqueue){

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    public void job() throws Exception {
                        try {
                            var1_1 = ConnectionPanel.this.controller.getRoleDirectory().attemptConnection();
                            switch (3.$SwitchMap$alma$obsprep$services$network$roledirectory$RoleDirectoryService$ExternalState$Code[var1_1.code.ordinal()]) {
                                case 1: 
                                case 2: {
                                    GUIUtilities.error(null, "Connection check failed.\nServer not found at " + var1_1.url + "\n");
                                    ** break;
                                }
                                case 3: 
                                case 5: {
                                    GUIUtilities.info(null, "Connection check succeeded.\nServer found at " + var1_1.url + "\n");
                                    ** break;
                                }
                            }
                        }
                        catch (Throwable var2_2) {
                            new AbstractJob("", false, JobUtility.swing){

                                @Override
                                public void job() {
                                    this.putValue("Name", "Test Connection");
                                    this.setEnabled(true);
                                }
                            }.go();
                            throw var2_2;
                        }
lbl15:
                        // 3 sources

                        new /* invalid duplicate definition of identical inner class */.go();
                    }
                }.go();
            }
        });
        Box box = Box.createHorizontalBox();
        this.credPanel = this.controller.getUserAuthenticator().getCredentialPanel(true);
        box.add(this.credPanel);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.btnTestLogin);
        this.btnTestLogin.setMaximumSize(this.btnTestLogin.getPreferredSize());
        this.btnTestLogin.setAlignmentY(0.8f);
        this.userAuth.add((Component)box, "Stretch Width");
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 10, 5));
        this.rolesButton.setName("ConnectionPanel.rolesButton");
        this.rolesButton.setText("Show Permissions");
        this.rolesButton.setToolTipText("Show permissions for your current login");
        this.rolesButton.addActionListener(actionEvent -> this.rolesButtonActionPerformed(actionEvent));
        jPanel.add(this.btnTestConnection);
        jPanel.add(this.rolesButton);
        this.userAuth.add(jPanel);
        this.lblSimulationReminder = new JLabel();
        this.userAuth.add(this.lblSimulationReminder);
        this.pnlStripe1 = this.addStripe("User Authentication", this.userAuth, true);
        this.projRep.setLayout(new VerticalFlowLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel("Location of Service"));
        jPanel2.add(this.cmbSubmissionUrl);
        this.projRep.add((Component)jPanel2, "Stretch Width");
        ArrayList<WebSubmissionHostType> arrayList = Collections.list(WebSubmissionHostType.enumerate());
        Collections.sort(arrayList, (webSubmissionHostType, webSubmissionHostType2) -> String.valueOf(webSubmissionHostType).compareTo(String.valueOf(webSubmissionHostType2)));
        for (WebSubmissionHostType webSubmissionHostType3 : arrayList) {
            this.cmbSubmissionUrl.addItem(webSubmissionHostType3.toString());
        }
        this.cmbSubmissionUrl.setEditable(true);
        this.projRep.add(new JLabel("<html>Please note that changes to this setting will not be remembered. Switching<br>to a different https-service is not possible, unless it is an official ALMA server.<br>If you need any of the above, talk to the computing support group.<html>"));
        this.pnlStripe2 = this.addStripe("Connection to Project Repository", this.projRep, false);
        this.pnlStripe2.setVisible(false);
    }

    @Override
    public void readPreferences(ObsToolUserPrefs obsToolUserPrefs) {
        this.controller.getUserAuthenticator().fillCredentialPanel(this.credPanel);
        String string = this.controller.getRoleDirectory().isSimulation() ? "<html><br><font color=blue><b>Note:</b> You are in <b>privilege simulation</b> mode.<br>The OT is running against a simulated permission server, and so<br>you have all permissions, locally in this OT (not in the real servers)." : "";
        this.lblSimulationReminder.setText(string);
        String string2 = this.controller.getUserAuthenticator().getServerUrl();
        this.cmbSubmissionUrl.getEditor().setItem(string2);
        this.cmbSubmissionUrl.setSelectedItem(string2);
        this.readAdvancedOptions(this.controller.advancedOptions());
    }

    public void readAdvancedOptions(ObservingToolController.AdvancedOptions advancedOptions) {
        boolean bl = advancedOptions.isShowStaffActions();
        this.pnlStripe2.setVisible(bl);
    }

    @Override
    public void writePreferences(ObsToolUserPrefs obsToolUserPrefs) {
        String string = (String)this.cmbSubmissionUrl.getEditor().getItem();
        this.cmbSubmissionUrl.setSelectedItem(string);
        this.controller.getUserAuthenticator().copyNewServerSettingOverToCredentialPanel(string, this.credPanel);
        this.controller.getUserAuthenticator().consumeCredentialPanel(this.credPanel);
    }

    private void rolesButtonActionPerformed(ActionEvent actionEvent) {
        Frame frame = null;
        OTOperationsDialog oTOperationsDialog = new OTOperationsDialog(frame, true);
        oTOperationsDialog.setTitle("Account Permissions");
        oTOperationsDialog.setRoleDirectory(this.controller.getRoleDirectory());
        oTOperationsDialog.setVisible(true);
    }
}

