/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.dnd;

import alma.obsprep.ot.gui.dnd.DNDClient;
import alma.obsprep.ot.gui.dnd.DNDDescriptor;
import alma.obsprep.ot.gui.dnd.MousePoint;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public abstract class DNDAdapter
extends MouseInputAdapter {
    private DNDClient client;
    private DNDDescriptor descriptor;

    public DNDAdapter(DNDClient dNDClient) {
        this.client = dNDClient;
    }

    protected abstract void domainSpecificPickup();

    protected abstract void domainSpecificDrop();

    private boolean active() {
        return this.descriptor != null;
    }

    private void deactivate() {
        this.client.destroyDescriptor(this.descriptor);
        this.descriptor = null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        MousePoint mousePoint = new MousePoint(mouseEvent.getX(), mouseEvent.getY());
        super.mousePressed(mouseEvent);
        this.descriptor = this.client.createDescriptor(mousePoint);
        if (this.active()) {
            this.descriptor.setDelta(mousePoint.minus(this.descriptor.getOriginalObjectPosition()));
            this.domainSpecificPickup();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (this.active()) {
            MousePoint mousePoint = new MousePoint(mouseEvent.getX(), mouseEvent.getY());
            mousePoint = mousePoint.minus(this.descriptor.getDelta());
            this.client.drag(this.descriptor, mousePoint);
            if (this.descriptor.getPublishesWhileDragging()) {
                this.client.publish();
            }
            this.client.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.active()) {
            this.domainSpecificDrop();
            this.mouseDragged(mouseEvent);
            this.deactivate();
        }
    }
}

