/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.entity.xmlbinding.valuetypes.types.VelocityTReferenceSystemType;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.CorrBits;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrFraction;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.SpectralAverage;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.ConfigModeComparator;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.ot.editors.misc.ComboBoxCellEditor;
import alma.obsprep.ot.editors.misc.OTTextCellEditor;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.editors.spectralvisual.BooleanColumnRenderer;
import alma.obsprep.ot.editors.spectralvisual.ResourceColumnRenderer;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.MultiResolutionElementTableModel;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MultiResolutionElementTable
extends Table {
    private static final long serialVersionUID = 6546228221509150101L;
    protected JComboBox<CorrFraction> corrFractionComboBox;
    protected DescriptionComboBox descCombo;
    protected JComboBox<SpectralAverage> spectralAveragingComboBox;
    private static final Map<Integer, String> columnToolTips;
    public static final int DEFAULT_WIDTH = 550;

    public MultiResolutionElementTable(TableModel tableModel) {
        super(tableModel);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoResizeMode(4);
        this.setupEditorsAndRenderers();
    }

    private MultiResolutionElementTableModel getMyModel() {
        return (MultiResolutionElementTableModel)this.dataModel;
    }

    protected boolean isAdvancedMode() {
        return true;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnModel.getColumnIndexAtX(point.x);
                int n2 = this.columnModel.getColumn(n).getModelIndex();
                if (columnToolTips.containsKey(n2)) {
                    return columnToolTips.get(n2);
                }
                return null;
            }
        };
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = this.getSelectedRow();
        super.tableChanged(tableModelEvent);
        if (n < this.getRowCount() && n >= 0) {
            this.setRowSelectionInterval(n, n);
        }
        this.setFrequencyColumnHeaders();
    }

    private void setFrequencyColumnHeaders() {
        if (this.getMyModel() != null && this.getMyModel().getSSP() != null) {
            TableColumn tableColumn;
            TableColumn tableColumn2;
            Object object;
            SpectralSetupParameters spectralSetupParameters = this.getMyModel().getSSP();
            try {
                if (this.getTableHeader() == null) {
                    return;
                }
                object = this.getTableHeader().getColumnModel();
                tableColumn2 = object.getColumn(MultiResolutionElementTableModel.ColumnDescriptor.CENTERFREQREST.getColumnIndex());
                tableColumn = object.getColumn(MultiResolutionElementTableModel.ColumnDescriptor.CENTERFREQSKY.getColumnIndex());
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            assert (tableColumn2 != null && tableColumn != null);
            object = null;
            String string = null;
            switch (spectralSetupParameters.getSpectralType()) {
                case SINGLECONTINUUM: {
                    object = VelocityTReferenceSystemType.TOPO.toString().toLowerCase();
                    string = object;
                    break;
                }
                case SPECTRALLINE: {
                    TargetParameters targetParameters;
                    ScienceGoal scienceGoal = spectralSetupParameters.getScienceGoal();
                    if (scienceGoal == null || (targetParameters = scienceGoal.getKeyTargetParameters()) == null) break;
                    String string2 = targetParameters.getSourceVelocity().getReferenceSystem();
                    if (VelocityTReferenceSystemType.TOPO.toString().equalsIgnoreCase(string2)) {
                        object = VelocityTReferenceSystemType.TOPO.toString().toLowerCase();
                        string = object;
                    } else if (VelocityTReferenceSystemType.LSR.toString().equalsIgnoreCase(string2)) {
                        object = VelocityTReferenceSystemType.LSR.toString().toLowerCase();
                        string = VelocityTReferenceSystemType.BAR.toString().toLowerCase();
                    } else if (VelocityTReferenceSystemType.LSRK.toString().equalsIgnoreCase(string2)) {
                        object = VelocityTReferenceSystemType.LSRK.toString().toLowerCase();
                        string = VelocityTReferenceSystemType.BAR.toString().toLowerCase();
                    } else if (VelocityTReferenceSystemType.HEL.toString().equalsIgnoreCase(string2)) {
                        object = VelocityTReferenceSystemType.HEL.toString().toLowerCase();
                        string = object;
                    } else if (VelocityTReferenceSystemType.BAR.toString().equalsIgnoreCase(string2)) {
                        object = VelocityTReferenceSystemType.BAR.toString().toLowerCase();
                        string = object;
                    } else {
                        tableColumn2.setHeaderValue("<html>Centre Freq (rest)</html>");
                        tableColumn.setHeaderValue("<html>Centre Freq (sky)</html>");
                        Log.logger(MultiResolutionElementTable.class).warning(String.format("Unknown velocity reference system found : %s", string2));
                    }
                    boolean bl = VLBIExpert.isScienceGoalLegalVLBISpectralLine(scienceGoal);
                    if (!bl) break;
                    string = VelocityTReferenceSystemType.TOPO.toString().toLowerCase();
                    break;
                }
                case SPECTRALSCAN: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown spectral type detected: " + String.valueOf((Object)spectralSetupParameters.getSpectralType()));
                }
            }
            if (object != null && string != null) {
                tableColumn2.setHeaderValue(String.format("<html><center>Centre Freq <P>(rest,%s)</center></html>", object));
                tableColumn.setHeaderValue(String.format("<html><center>Centre Freq <P>(sky,%s)</center></html>", string));
            }
        }
    }

    private void setupEditorsAndRenderers() {
        Object object2;
        this.setDefaultRenderer(Object.class, new ResourceColumnRenderer());
        this.setDefaultRenderer(Boolean.class, new BooleanColumnRenderer());
        this.setDefaultRenderer(Frequency.class, new ResourceColumnRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Frequency frequency = (Frequency)((Object)object);
                String string = TextUtils.format(frequency, 5);
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        ValueUnitPairCellEditor.FrequencyEditor frequencyEditor = new ValueUnitPairCellEditor.FrequencyEditor(false);
        frequencyEditor.setClickCountToStart(2);
        this.setDefaultRenderer(SpectralAverage.class, new ResourceColumnRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                SpectralAverage spectralAverage = (SpectralAverage)((Object)object);
                return super.getTableCellRendererComponent(jTable, spectralAverage.getLabel(), bl, bl2, n, n2);
            }
        });
        this.spectralAveragingComboBox = new JComboBox<SpectralAverage>(SpectralAverage.values());
        this.spectralAveragingComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setText(((SpectralAverage)((Object)object)).getSpectralAveragingFactor().toString());
                return this;
            }
        });
        ArrayList<CorrFraction> arrayList = new ArrayList<CorrFraction>();
        int n = 128 / AlmaCapabilities.getInstance().getMaxNumberSw();
        for (Object object2 : CorrFraction.values()) {
            if (object2.getUnits() < n) continue;
            arrayList.add((CorrFraction)((Object)object2));
        }
        this.corrFractionComboBox = new JComboBox<CorrFraction>(arrayList.toArray(new CorrFraction[arrayList.size()]));
        this.corrFractionComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setText(((CorrFraction)((Object)object)).getLabel());
                return this;
            }
        });
        OTTextCellEditor oTTextCellEditor = new OTTextCellEditor();
        oTTextCellEditor.setClickCountToStart(2);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(this.corrFractionComboBox);
        defaultCellEditor.setClickCountToStart(2);
        DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(this.spectralAveragingComboBox);
        defaultCellEditor2.setClickCountToStart(2);
        this.descCombo = new DescriptionComboBox();
        object2 = new DescriptionCellEditor(this.descCombo);
        ((DefaultCellEditor)object2).setClickCountToStart(2);
        ResourceColumnRenderer resourceColumnRenderer = new ResourceColumnRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                ScienceSpectralWindow scienceSpectralWindow = MultiResolutionElementTable.this.getMyModel().getRow(n);
                if (scienceSpectralWindow.promptsUpdate()) {
                    object = "Please select a correlator mode";
                }
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (scienceSpectralWindow.promptsUpdate()) {
                    component.setForeground(Colors.OT_RED);
                } else {
                    component.setForeground(Color.BLACK);
                }
                return component;
            }
        };
        TableColumn tableColumn = this.getColumnModel().getColumn(MultiResolutionElementTableModel.ColumnDescriptor.CENTERFREQREST.getColumnIndex());
        tableColumn.setCellEditor(frequencyEditor);
        tableColumn = this.getColumnModel().getColumn(MultiResolutionElementTableModel.ColumnDescriptor.CENTERFREQSKY.getColumnIndex());
        tableColumn.setCellEditor(frequencyEditor);
        tableColumn = this.getColumnModel().getColumn(MultiResolutionElementTableModel.ColumnDescriptor.TRANSITION.getColumnIndex());
        tableColumn.setCellEditor(oTTextCellEditor);
        tableColumn = this.getColumnModel().getColumn(MultiResolutionElementTableModel.ColumnDescriptor.MODEDESCRIPTION.getColumnIndex());
        tableColumn.setCellEditor((TableCellEditor)object2);
        tableColumn.setCellRenderer(resourceColumnRenderer);
        tableColumn = this.getColumnModel().getColumn(MultiResolutionElementTableModel.ColumnDescriptor.SETREPFREQ.getColumnIndex());
        tableColumn.setCellEditor(new RadioButtonEditor(new JCheckBox()));
        tableColumn.setCellRenderer(new RadioButtonRenderer(this));
        ColumnResizer.initColumnSizes(this, this.getMyModel().getLongValues());
        tableColumn = this.getColumnModel().getColumn(MultiResolutionElementTableModel.ColumnDescriptor.FRACTION.getColumnIndex());
        if (this.isAdvancedMode()) {
            tableColumn.setCellEditor(defaultCellEditor);
        } else {
            this.getColumnModel().removeColumn(tableColumn);
        }
        tableColumn = this.getColumnModel().getColumn(MultiResolutionElementTableModel.ColumnDescriptor.SPECTRALAVG.getColumnIndex());
        tableColumn.setCellEditor(defaultCellEditor2);
    }

    private void resetDescriptionCombo(int n) {
        MultiResolutionElementTableModel multiResolutionElementTableModel = this.getMyModel();
        ScienceSpectralWindow scienceSpectralWindow = multiResolutionElementTableModel.getRow(n);
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        int n2 = MultiResolutionElementTableModel.ColumnDescriptor.FRACTION.getColumnIndex();
        CorrFraction corrFraction = CorrFraction.getCorrFraction((String)multiResolutionElementTableModel.getValueAt(n, n2));
        if (!this.isAdvancedMode() || corrFraction == null) {
            corrFraction = CorrFraction.FULL;
        }
        boolean bl = scienceSpectralWindow.getAdvancedWindowSetup().getOversampling();
        Set<CorrConfigMode> set = oTConfigModeDecoder.findMode(bl, multiResolutionElementTableModel.getPolarization());
        boolean bl2 = scienceSpectralWindow.getAdvancedWindowSetup().getAddedSensitivity();
        Set<CorrConfigMode> set2 = oTConfigModeDecoder.findMode(corrFraction, bl2, set);
        multiResolutionElementTableModel.getDominantCorrelatorMode().filter(corrBits -> multiResolutionElementTableModel.getSpectralWindow().length > 1).ifPresentOrElse(corrBits -> {
            Set<CorrConfigMode> set2 = oTConfigModeDecoder.findMode((CorrBits)((Object)corrBits), set2);
            this.descCombo.setModeList(set2);
        }, () -> this.descCombo.setModeList(set2));
        int n3 = MultiResolutionElementTableModel.ColumnDescriptor.CENTERFREQSKY.getColumnIndex();
        Frequency frequency = (Frequency)((Object)multiResolutionElementTableModel.getValueAt(n, n3));
        this.descCombo.setFrequency(frequency);
        this.descCombo.setScienceSpectralWindow(scienceSpectralWindow);
        this.descCombo.reset(scienceSpectralWindow.getCorrConfigMode());
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("MultiResolutionElementTable Test");
        jFrame.setPreferredSize(new Dimension(800, 400));
        jFrame.setDefaultCloseOperation(3);
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        spectralSetupParameters.setPolarisation(CorrPolarization.SINGLE_X.polarization);
        MultiResolutionElementTableModel multiResolutionElementTableModel = new MultiResolutionElementTableModel(spectralSetupParameters);
        MultiResolutionElementTable multiResolutionElementTable = new MultiResolutionElementTable(multiResolutionElementTableModel);
        spectralSetupParameters.addNewSpectralWindow();
        ScienceSpectralWindow scienceSpectralWindow = spectralSetupParameters.addNewSpectralWindow();
        scienceSpectralWindow.setCorrConfigMode(4);
        scienceSpectralWindow.getCenterFrequency().setContentInGHz(230.0);
        scienceSpectralWindow.setCorrConfigMode(4);
        scienceSpectralWindow.setGroupResourceUse(ScienceSpectralWindow.GROUPRESOURCEUSE_HALF);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(multiResolutionElementTable);
        jFrame.getContentPane().add(scrollWhenFocusedPane);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(MultiResolutionElementTableModel.ColumnDescriptor.FRACTION.getColumnIndex(), "Fraction of correlator used");
        hashMap.put(MultiResolutionElementTableModel.ColumnDescriptor.CENTERFREQREST.getColumnIndex(), "Frequency in source rest-frame");
        hashMap.put(MultiResolutionElementTableModel.ColumnDescriptor.CENTERFREQSKY.getColumnIndex(), "Frequency in observed frame");
        hashMap.put(MultiResolutionElementTableModel.ColumnDescriptor.TRANSITION.getColumnIndex(), "Label to identify this spectral window");
        hashMap.put(MultiResolutionElementTableModel.ColumnDescriptor.MODEDESCRIPTION.getColumnIndex(), "Bandwidth and Spectral resolution after application of Hanning smoothing and spectral averaging");
        hashMap.put(MultiResolutionElementTableModel.ColumnDescriptor.SPECTRALAVG.getColumnIndex(), "Spectral averaging to be applied to the spectral window ");
        hashMap.put(MultiResolutionElementTableModel.ColumnDescriptor.WALSHSWITCH.getColumnIndex(), "Whether 90-degree Walsh switching is enabled");
        hashMap.put(MultiResolutionElementTableModel.ColumnDescriptor.SETREPFREQ.getColumnIndex(), "Window of greatest interest. Sets Representative Frequency");
        columnToolTips = Collections.unmodifiableMap(hashMap);
    }

    private class DescriptionComboBox
    extends JComboBox {
        private List<CorrConfigMode> modeList = new ArrayList<CorrConfigMode>();
        private Comparator<CorrConfigMode> comparator;
        private Frequency frequency;
        private ScienceSpectralWindow scienceSpectralWindow;

        DescriptionComboBox() {
            Font font = this.getFont();
            this.setFont(new Font("Monospaced", font.getSize(), font.getSize()));
            this.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    if (object != null) {
                        CorrConfigMode corrConfigMode = (CorrConfigMode)object;
                        Object object2 = "<html>";
                        boolean bl3 = corrConfigMode.getFilter().equals((Object)CorrFilter.TDM);
                        if (bl3) {
                            object2 = (String)object2 + "<b>";
                        }
                        object2 = (String)object2 + corrConfigMode.formatWindowDescription(DescriptionComboBox.this.frequency, DescriptionComboBox.this.scienceSpectralWindow.getAdvancedWindowSetup()).replace(" ", "&nbsp;");
                        if (bl3) {
                            object2 = (String)object2 + "</b>";
                        }
                        object2 = (String)object2 + "</html>";
                        this.setText((String)object2);
                    }
                    return this;
                }
            });
            ConfigModeComparator.Column[] columnArray = new ConfigModeComparator.Column[]{ConfigModeComparator.Column.BANDWIDTH, ConfigModeComparator.Column.RESOLUTION};
            this.comparator = new ConfigModeComparator(columnArray);
        }

        void setModeList(Set<CorrConfigMode> set) {
            CorrConfigMode[] corrConfigModeArray = new CorrConfigMode[set.size()];
            this.setModeList(Arrays.asList(set.toArray(corrConfigModeArray)));
        }

        void setModeList(List<CorrConfigMode> list) {
            this.modeList = list;
            Collections.sort(list, this.comparator);
        }

        void reset(CorrConfigMode corrConfigMode) {
            int n = 0;
            DefaultComboBoxModel<CorrConfigMode> defaultComboBoxModel = new DefaultComboBoxModel<CorrConfigMode>();
            for (int i = 0; i < this.modeList.size(); ++i) {
                CorrConfigMode corrConfigMode2 = this.modeList.get(i);
                defaultComboBoxModel.addElement(corrConfigMode2);
                if (corrConfigMode2 != corrConfigMode) continue;
                n = i;
            }
            if (!this.modeList.isEmpty()) {
                this.setModel(defaultComboBoxModel);
                this.setSelectedIndex(n);
            }
        }

        public void setFrequency(Frequency frequency) {
            this.frequency = frequency;
        }

        public void setScienceSpectralWindow(ScienceSpectralWindow scienceSpectralWindow) {
            this.scienceSpectralWindow = scienceSpectralWindow;
        }
    }

    private class DescriptionCellEditor
    extends ComboBoxCellEditor
    implements PopupMenuListener {
        public DescriptionCellEditor(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            MultiResolutionElementTable.this.resetDescriptionCombo(n);
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    private class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener {
        public final JRadioButton btn;

        public RadioButtonEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
            this.btn = new JRadioButton();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                return null;
            }
            this.btn.addItemListener(this);
            if (((Boolean)object).booleanValue()) {
                this.btn.setSelected(true);
            } else {
                this.btn.setSelected(false);
            }
            return this.btn;
        }

        @Override
        public Object getCellEditorValue() {
            return this.btn.isSelected();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            super.fireEditingStopped();
        }
    }

    private class RadioButtonRenderer
    implements TableCellRenderer {
        public final JRadioButton btn = new JRadioButton();

        private RadioButtonRenderer(MultiResolutionElementTable multiResolutionElementTable) {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return null;
            }
            if (((Boolean)object).booleanValue()) {
                this.btn.setSelected(true);
            } else {
                this.btn.setSelected(false);
            }
            if (jTable.getSelectedRow() == n) {
                this.btn.setForeground(jTable.getSelectionForeground());
                this.btn.setBackground(jTable.getSelectionBackground());
            } else {
                this.btn.setForeground(jTable.getForeground());
                this.btn.setBackground(jTable.getBackground());
            }
            return this.btn;
        }
    }
}

