/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.ot.editors.schedblock.PointingPatternEditor;
import alma.obsprep.ot.editors.valuetypes.SkyCoordsEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;

public class MultiPointEditorTestMain {
    public static void main(String[] stringArray) throws Exception {
        InitServices.init();
        SkyCoordinates skyCoordinates = SkyCoordinates.createAbsoluteCoordinates();
        skyCoordinates.getLongitude().setContent(15.0);
        TargetParameters targetParameters = TargetParameters.createTargetParameters();
        targetParameters.setSourceCoordinates(skyCoordinates);
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createOffsetCoordinates();
        SkyCoordinates skyCoordinates3 = SkyCoordinates.createOffsetCoordinates();
        skyCoordinates2.getLongitude().setContentAndUnit(60.0, Longitude.UNIT_ARCSEC);
        skyCoordinates3.getLongitude().setContentAndUnit(120.0, Longitude.UNIT_ARCSEC);
        SinglePoint singlePoint = SinglePoint.createSinglePoint(skyCoordinates2);
        SinglePoint singlePoint2 = SinglePoint.createSinglePoint(skyCoordinates3);
        PointingPatternModel pointingPatternModel = new PointingPatternModel(null);
        PointingPatternEditor pointingPatternEditor = new PointingPatternEditor(pointingPatternModel);
        pointingPatternModel.setDocument(targetParameters);
        pointingPatternEditor.setBorder(BorderFactory.createTitledBorder("Pointing Pattern Editor"));
        SkyCoordsModel skyCoordsModel = new SkyCoordsModel(skyCoordinates);
        SkyCoordsEditor skyCoordsEditor = new SkyCoordsEditor(skyCoordsModel);
        skyCoordsEditor.setBorder(BorderFactory.createTitledBorder("Phase Center Coordinates"));
        JFrame jFrame = new JFrame("PointingPatternEditor");
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        container.setLayout(new BoxLayout(container, 3));
        container.add(skyCoordsEditor);
        container.add(pointingPatternEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

