/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.AbstractInstrumentSpec;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.FieldSourceEditor;
import alma.obsprep.ot.editors.schedblock.NoFieldSourcePanel;
import alma.obsprep.ot.editors.schedblock.NoObservingParameterPanel;
import alma.obsprep.ot.editors.schedblock.NoSpectralSpecPanel;
import alma.obsprep.ot.editors.schedblock.OpticalCameraSpecEditor;
import alma.obsprep.ot.editors.schedblock.SpectralSpecFormEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.ObservingParameterTabEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.schedblock.TargetModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.help.CSH;
import javax.swing.JPanel;

public class TargetEditor
extends EditorWithGridBagLayout {
    protected FieldSourceEditor fieldSourceEditor = null;
    protected NoFieldSourcePanel noFieldSourcePanel = null;
    protected ObservingParameterTabEditor observingParameterTab = null;
    protected NoObservingParameterPanel noObservingParameterPanel = null;
    protected SpectralSpecFormEditor spectralSpecEditor = null;
    protected OpticalCameraSpecEditor opticalCameraSpecEditor = null;
    protected NoSpectralSpecPanel noSpectralSpecPanel = null;
    protected final ObservingToolController otc;
    public static final FieldID DOCUMENT_FID = new FieldID("TargetEditor.document");

    public TargetEditor(Model model, ObservingToolController observingToolController) {
        this.otc = observingToolController;
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public TargetModel getModel() {
        return (TargetModel)super.getModel();
    }

    @Override
    protected void addComponents(String string) {
        this.constraints.anchor = 11;
        this.constraints.gridy = 0;
        this.constraints.gridx = 0;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.fieldSourceEditor = new FieldSourceEditor(this.getModel().getFieldSourceModel());
        this.noFieldSourcePanel = new NoFieldSourcePanel(this.getModel());
        this.observingParameterTab = new ObservingParameterTabEditor(this.getModel().getObservingParameterTabModel());
        this.noObservingParameterPanel = new NoObservingParameterPanel(this.getModel());
        CSH.setHelpIDString((Component)this.fieldSourceEditor, (String)"TOC-Phase 2 Program Scheduling Blocks-Field Sources");
        CSH.setHelpIDString((Component)this.observingParameterTab, (String)"TOC-Phase 2 Program Scheduling Blocks-Observing Parameters-Science Parameters");
        this.registerSubView(this.fieldSourceEditor);
        this.registerSubView(this.noFieldSourcePanel);
        this.registerSubView(this.observingParameterTab);
        this.registerSubView(this.noObservingParameterPanel);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.fieldSourceEditor);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.noFieldSourcePanel);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.observingParameterTab);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.noObservingParameterPanel);
        this.layout.setConstraints(jPanel, this.constraints);
        this.add(jPanel);
        this.constraints.gridy = 0;
        this.constraints.gridx = 1;
        JPanel jPanel2 = new JPanel();
        gridBagLayout = this.createNewLayout(jPanel2);
        gridBagConstraints = this.createNewConstraints();
        this.spectralSpecEditor = new SpectralSpecFormEditor((Model)this.getModel().getSpectralSpecModel(), this.otc);
        this.opticalCameraSpecEditor = new OpticalCameraSpecEditor(this.getModel().getOpticalCameraSpecModel());
        this.noSpectralSpecPanel = new NoSpectralSpecPanel(this.getModel());
        CSH.setHelpIDString((Component)this.spectralSpecEditor, (String)"TOC-Phase 2 Program Scheduling Blocks-Instrument Setup");
        this.registerSubView(this.spectralSpecEditor);
        this.registerSubView(this.opticalCameraSpecEditor);
        this.registerSubView(this.noSpectralSpecPanel);
        this.addComponent(jPanel2, gridBagLayout, gridBagConstraints, this.spectralSpecEditor);
        this.addComponent(jPanel2, gridBagLayout, gridBagConstraints, this.opticalCameraSpecEditor);
        this.addComponent(jPanel2, gridBagLayout, gridBagConstraints, this.noSpectralSpecPanel);
        this.layout.setConstraints(jPanel2, this.constraints);
        this.add(jPanel2);
    }

    @Override
    protected void build() {
        super.build("Target");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == DOCUMENT_FID) {
            Target target = (Target)object;
            if (target == null) {
                return;
            }
            FieldSource fieldSource = target.getFieldSource();
            this.fieldSourceEditor.setVisible(fieldSource != null);
            this.noFieldSourcePanel.setVisible(fieldSource == null);
            AbstractInstrumentSpec abstractInstrumentSpec = target.getAbstractInstrumentSpec();
            this.noSpectralSpecPanel.setVisible(abstractInstrumentSpec == null);
            SpectralSpec spectralSpec = target.getSpectralSpec();
            this.spectralSpecEditor.setVisible(spectralSpec != null);
            OpticalCameraSpec opticalCameraSpec = target.getOpticalCameraSpec();
            this.opticalCameraSpecEditor.setVisible(opticalCameraSpec != null);
            ObservingParameters[] observingParametersArray = target.getObservingParameters();
            this.noObservingParameterPanel.setVisible(observingParametersArray == null || observingParametersArray.length == 0);
            this.observingParameterTab.setVisible(observingParametersArray != null && observingParametersArray.length > 0);
        } else {
            super.update(fieldID, object);
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        ObservingToolController observingToolController = new ObservingToolController();
        TargetModel targetModel = new TargetModel(null, observingToolController);
        TargetEditor targetEditor = new TargetEditor((Model)targetModel, observingToolController);
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        FieldSource fieldSource = FieldSource.createFieldSource();
        OpticalCameraSpec.createOpticalCameraSpec();
        ScienceParameters scienceParameters = ScienceParameters.createScienceParameters();
        PointingCalParameters pointingCalParameters = PointingCalParameters.createPointingCalParameters();
        schedBlock.addFieldSource(fieldSource);
        schedBlock.addObservingParameters((ObservingParameters)((Object)scienceParameters));
        schedBlock.addObservingParameters((ObservingParameters)((Object)pointingCalParameters));
        Target target = schedBlock.createTarget();
        targetModel.setDocument(target);
        TargetEditor.runTestApp(targetEditor, 1024, 800);
    }
}

