/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.ot.editors.misc.ComboBoxCellEditor;
import alma.obsprep.ot.editors.misc.ValueCellEditor;
import alma.obsprep.ot.editors.schedblock.SpectralWindowComboBoxPair;
import alma.obsprep.ot.editors.spectralvisual.BooleanColumnRenderer;
import alma.obsprep.ot.editors.spectralvisual.ResourceColumnRenderer;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.models.schedblock.SpectralWindowTableModel;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SpectralWindowTable
extends Table {
    private static final long serialVersionUID = 8600516848199003211L;
    public static final int TABLE_WIDTH = 800;
    private SpectralWindowComboBoxPair bwAndChannelComboPair;
    private TableCellEditor bandWidthCellEditor;
    private TableCellEditor channelCellEditor;

    public SpectralWindowTable(TableModel tableModel) {
        super(tableModel);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setToolTipText("Up to " + AbstractBaseBandConfig.maxSpectralWindowCount() + " Windows may be added");
        Dimension dimension = new Dimension(800, 80);
        this.setPreferredScrollableViewportSize(dimension);
        this.setupTableEditors();
    }

    private TableColumn getColumn(SpectralWindowTableModel.SpectralWindowTableColumnDescriptor spectralWindowTableColumnDescriptor) {
        return this.getColumnModel().getColumn(spectralWindowTableColumnDescriptor.ordinal());
    }

    private void setupTableEditors() {
        this.getColumn(SpectralWindowTableModel.SpectralWindowTableColumnDescriptor.OFFSET).setCellEditor(new ValueCellEditor.Double());
        this.setDefaultRenderer(Boolean.class, new BooleanColumnRenderer());
        this.setDefaultRenderer(Object.class, new ResourceColumnRenderer());
        ResourceColumnRenderer resourceColumnRenderer = new ResourceColumnRenderer(){
            private static final long serialVersionUID = 1561872349984221711L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Frequency frequency = (Frequency)((Object)object);
                String string = frequency == null ? "---" : TextUtils.format(frequency, 3);
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        };
        this.getColumn(SpectralWindowTableModel.SpectralWindowTableColumnDescriptor.FSKY_LSB).setCellRenderer(resourceColumnRenderer);
        this.getColumn(SpectralWindowTableModel.SpectralWindowTableColumnDescriptor.FSKY_USB).setCellRenderer(resourceColumnRenderer);
        resourceColumnRenderer = new ResourceColumnRenderer(){
            private static final long serialVersionUID = -1963449506559759572L;
            final double lowerBBOffsetFreq = 2.0;
            final double upperBBOffsetFreq = 4.0;
            final Range wholeBBFreqRange = new Range(2.0, 4.0);

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                double d;
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                Frequency frequency = Frequency.createFrequencyMHZ((Double)object);
                SpectralWindowI spectralWindowI = SpectralWindowTable.this.getMyModel().getBaseBandConfig().getSpectralWindow(n);
                Frequency frequency2 = spectralWindowI.getEffectiveBandwidth();
                Range range = new Range(((Frequency)frequency.minus((AbstractDoubleWithUnit)((Frequency)frequency2.half()))).getContentInGHz(), ((Frequency)frequency.plus((AbstractDoubleWithUnit)((Frequency)frequency2.half()))).getContentInGHz());
                Color color = Color.black;
                if (!this.wholeBBFreqRange.contains(range) && (d = this.wholeBBFreqRange.min() > range.min() ? this.wholeBBFreqRange.min() - range.min() : range.max() - this.wholeBBFreqRange.max()) > 3.814697265625E-6) {
                    color = Color.red;
                }
                component.setForeground(color);
                return component;
            }
        };
        this.getColumn(SpectralWindowTableModel.SpectralWindowTableColumnDescriptor.OFFSET).setCellRenderer(resourceColumnRenderer);
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        JComboBox<String> jComboBox = new JComboBox<String>(oTConfigModeDecoder.getKnownNominalBandwidthLabels());
        JComboBox<String> jComboBox2 = new JComboBox<String>(oTConfigModeDecoder.getKnownNominalChannelLabels());
        this.bwAndChannelComboPair = new SpectralWindowComboBoxPair(null, jComboBox, jComboBox2){

            @Override
            public SpectralWindowI getSpectralWindow() {
                AbstractBaseBandConfig abstractBaseBandConfig = SpectralWindowTable.this.getMyModel().getBaseBandConfig();
                int n = SpectralWindowTable.this.getSelectedRow();
                if (n == -1) {
                    return null;
                }
                return abstractBaseBandConfig.getSpectralWindow(n);
            }
        };
        this.bandWidthCellEditor = new ComboBoxCellEditor(jComboBox){
            private static final long serialVersionUID = -5909251420670918704L;

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                SpectralWindowTable.this.setRowSelectionInterval(n, n);
                SpectralWindowTable.this.bwAndChannelComboPair.reset();
                return this.getComponent();
            }
        };
        ((DefaultCellEditor)this.bandWidthCellEditor).setClickCountToStart(2);
        this.channelCellEditor = new ComboBoxCellEditor(jComboBox2){
            private static final long serialVersionUID = -157569283627645884L;

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                SpectralWindowTable.this.setRowSelectionInterval(n, n);
                SpectralWindowTable.this.bwAndChannelComboPair.reset();
                return this.getComponent();
            }
        };
        ((DefaultCellEditor)this.channelCellEditor).setClickCountToStart(2);
        this.setupPairCellEditors(true);
        TableColumn tableColumn = this.getColumn(SpectralWindowTableModel.SpectralWindowTableColumnDescriptor.POLARIZATION);
        String[] stringArray = AbstractSpectralWindow.getKnownPolnProductsList();
        JComboBox<String> jComboBox3 = new JComboBox<String>(stringArray);
        ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor((JComboBox)jComboBox3);
        ((DefaultCellEditor)comboBoxCellEditor).setClickCountToStart(2);
        tableColumn.setCellEditor(comboBoxCellEditor);
        ColumnResizer.initColumnSizes(this, this.getMyModel().getLongValues());
        this.getColumn(SpectralWindowTableModel.SpectralWindowTableColumnDescriptor.OFFSET).setMinWidth(100);
        ResourceColumnRenderer resourceColumnRenderer2 = new ResourceColumnRenderer();
        resourceColumnRenderer2.setToolTipText("Correlator total output rate : " + this.getToolTipText());
        this.getColumn(SpectralWindowTableModel.SpectralWindowTableColumnDescriptor.DATARATE).setCellRenderer(resourceColumnRenderer2);
    }

    protected void setupPairCellEditors(boolean bl) {
        TableColumn tableColumn = this.getColumn(SpectralWindowTableModel.SpectralWindowTableColumnDescriptor.BANDWIDTH);
        tableColumn.setCellEditor(bl ? this.bandWidthCellEditor : null);
        tableColumn = this.getColumn(SpectralWindowTableModel.SpectralWindowTableColumnDescriptor.CHANNELS);
        tableColumn.setCellEditor(bl ? this.channelCellEditor : null);
    }

    public SpectralWindowTableModel getMyModel() {
        return (SpectralWindowTableModel)this.getModel();
    }
}

