/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.SpectralLine;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowBand;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.misc.TabbedEditorWithSummaryTable;
import alma.obsprep.ot.editors.schedblock.DebugSpectralWindowTable;
import alma.obsprep.ot.editors.schedblock.SpectralWindowEditor;
import alma.obsprep.ot.editors.schedblock.SpectralWindowTable;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.misc.TabbedEditorModel;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.obsprep.ot.models.schedblock.SpectralWindowTabbedModel;
import alma.obsprep.ot.models.schedblock.SpectralWindowTableModel;
import alma.obsprep.services.experts.spectralline.DialogSpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLinePublisher;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class SpectralWindowTabbedEditor
extends TabbedEditorWithSummaryTable {
    protected FieldID addButtonFID = new FieldID("SpectralWindowTabbedEditor.addBtn");
    protected FieldID addFromCatalogFID = new FieldID("SpectralWindowTabbedEditor.addFromBtn");
    protected FieldID copyButtonFID = new FieldID("SpectralWindowTabbedEditor.copyBtn");
    protected FieldID delButtonFID = new FieldID("SpectralWindowTabbedEditor.delBtn");
    protected FieldID printButtonFID = new FieldID("SpectralWindowTabbedEditor.printBtn");
    public static final FieldID documentFID = new FieldID("SpectralWindowTabbedEditor.document");
    protected static final FieldID ACASPECIFICMODE_FID = new FieldID("SpectralWindowTabbedEditor.ACASpecificMode");
    private final JButton addFromCatalogButton = new JButton("Add From Catalog");
    private final SpectralLineChooser lineChooser;
    private final Frequency SIX_GHZ;
    private Set<Component> acaComponents = new HashSet<Component>();
    private Set<Component> blComponents = new HashSet<Component>();

    public SpectralWindowTabbedEditor(TabbedEditorModel tabbedEditorModel, SpectralWindowEditor spectralWindowEditor, SpectralLineChooser spectralLineChooser) {
        this.setModel(tabbedEditorModel);
        this.subEditor = spectralWindowEditor;
        this.registerSubView(spectralWindowEditor);
        this.lineChooser = spectralLineChooser;
        this.SIX_GHZ = Frequency.createFrequencyGHZ(6.0);
        SpectralWindowTableModel spectralWindowTableModel = this.getMyModel().getSpectralWindowTableModel();
        this.setTable(new SpectralWindowTable(spectralWindowTableModel));
        this.build();
        tabbedEditorModel.publish();
        this.setMaxNumberOfSubBO(10);
    }

    public SpectralWindowTabbedEditor(TabbedEditorModel tabbedEditorModel, SpectralWindowEditor spectralWindowEditor) {
        this(tabbedEditorModel, spectralWindowEditor, DialogSpectralLineChooser.getInstance());
    }

    public SpectralWindowTabbedModel getMyModel() {
        return (SpectralWindowTabbedModel)this.getModel();
    }

    @Override
    protected JTable getTable() {
        return super.getTable();
    }

    @Override
    protected void build() {
        Object object;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        if (this.getTable() != null) {
            object = new ScrollWhenFocusedPane(this.getTable());
            ((JComponent)object).setMinimumSize(this.getTable().getPreferredScrollableViewportSize());
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            this.add((Component)object);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
        }
        object = "Check if you are going to set Bandwidth/Channels unbounded to BL Specific TFB parameters.";
        JCheckBox jCheckBox = new JCheckBox("Allows ACA specific modes");
        jCheckBox.setToolTipText((String)object);
        this.initEvents(jCheckBox, ACASPECIFICMODE_FID);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jCheckBox, gridBagConstraints);
        this.add(jCheckBox);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        this.acaComponents.add(jCheckBox);
        JPanel jPanel = this.getButtons();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(this.getButtons());
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.tabbedPane, gridBagConstraints);
        this.add(this.tabbedPane);
    }

    private void addFromCatalogAction() {
        if (!this.addFromCatalogButton.isEnabled()) {
            return;
        }
        this.addFromCatalogButton.setEnabled(false);
        SpectralWindowTabbedModel spectralWindowTabbedModel = this.getMyModel();
        SpectralSpecModel spectralSpecModel = spectralWindowTabbedModel.getSpectralSpecModel();
        Velocity velocity = spectralSpecModel.getSourceVelocity();
        Frequency frequency = null;
        Frequency frequency2 = null;
        Frequency[] frequencyArray = spectralWindowTabbedModel.getBaseBandConfig().getLOFrequencies();
        if (frequencyArray != null) {
            frequency = frequencyArray[0];
            frequency2 = frequencyArray[1];
        }
        AbstractBaseBandConfig abstractBaseBandConfig = spectralWindowTabbedModel.getBaseBandConfig();
        boolean bl = abstractBaseBandConfig.getSideBandUse().usesUSB();
        SpectralLinePublisher spectralLinePublisher = this.lineChooser.createPublisher(this, this.addFromCatalogFID, this.addFromCatalogButton);
        this.lineChooser.chooseSingleLine(spectralLinePublisher, velocity, frequency, frequency2, bl);
    }

    public JPanel getButtons() {
        JButton jButton = new JButton("Add");
        this.initEvents(jButton, this.addButtonFID);
        jButton.setToolTipText("Add a Window");
        this.initEvents(this.addFromCatalogButton, this.addFromCatalogFID);
        this.addFromCatalogButton.setToolTipText("Add a spectral window centered on a selection from the ALMA spectral line catalog");
        this.addFromCatalogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpectralWindowTabbedEditor.this.addFromCatalogAction();
            }
        });
        JButton jButton2 = new JButton("Duplicate Selected");
        this.initEvents(jButton2, this.copyButtonFID);
        jButton2.setToolTipText("Duplicate the selected spectral window");
        JButton jButton3 = new JButton("Delete");
        this.initEvents(jButton3, this.delButtonFID);
        jButton3.setToolTipText("Delete a Window");
        JButton jButton4 = new JButton("Print");
        this.initEvents(jButton4, this.printButtonFID);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(this.addFromCatalogButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        JButton jButton5 = new JButton("DebugTable");
        jButton5.addActionListener(new ActionListener(){
            JFrame win;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.win == null) {
                    this.win = new DebugSpectralWindowTable(SpectralWindowTabbedEditor.this.getMyModel().getBaseBandConfig());
                }
                this.win.setVisible(true);
            }
        });
        return jPanel;
    }

    @Override
    protected void updateButtons() {
        if (!this.isEnabled()) {
            return;
        }
        int n = this.getMyModel().getBOCount();
        int n2 = AbstractBaseBandConfig.maxSpectralWindowCount();
        AbstractBaseBandConfig abstractBaseBandConfig = this.getMyModel().getBaseBandConfig();
        if (abstractBaseBandConfig != null && abstractBaseBandConfig.isPairMode()) {
            n2 /= 2;
        }
        this.setEnabled(this.getComponent(this.addButtonFID), n < n2);
        this.setEnabled(this.addFromCatalogButton, n < n2);
        this.setEnabled(this.getComponent(this.copyButtonFID), n > 0 && n < n2);
        this.setEnabled(this.getComponent(this.delButtonFID), n > 0 && this.getSelectedIndex() != -1);
    }

    public void updateCorrelatorDependingComponent() {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getMyModel().getBaseBandConfig();
        if (abstractBaseBandConfig != null) {
            boolean bl = abstractBaseBandConfig.isACA();
            for (Component component : this.blComponents) {
                component.setVisible(!bl);
            }
            for (Component component : this.acaComponents) {
                component.setVisible(bl);
            }
        }
    }

    protected void setAllowAcaSpecifidMode(boolean bl) {
        ((SpectralWindowEditor)this.subEditor).setAllowsAcaSpecificMode(bl);
    }

    @Override
    protected String tabTitle(int n) {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getMyModel().getBaseBandConfig();
        return abstractBaseBandConfig == null ? null : abstractBaseBandConfig.getSpectralWindow(n).getSpectralWindowName();
    }

    public void setupPairCellEditors(boolean bl) {
        SpectralWindowTable spectralWindowTable = (SpectralWindowTable)this.getTable();
        spectralWindowTable.setupPairCellEditors(bl);
    }

    Frequency calculateBasebandOffsetFrequency(alma.obsprep.services.experts.spectralline.SpectralLine spectralLine) {
        SpectralWindowTabbedModel spectralWindowTabbedModel = this.getMyModel();
        if (spectralWindowTabbedModel == null) {
            return null;
        }
        AbstractBaseBandConfig abstractBaseBandConfig = spectralWindowTabbedModel.getBaseBandConfig();
        if (abstractBaseBandConfig == null) {
            return null;
        }
        Frequency[] frequencyArray = abstractBaseBandConfig.getLOFrequencies();
        if (frequencyArray == null) {
            return null;
        }
        Frequency frequency = frequencyArray[0];
        Frequency frequency2 = frequencyArray[1];
        Frequency frequency3 = spectralLine.getFrequency();
        SpectralSpecModel spectralSpecModel = spectralWindowTabbedModel.getSpectralSpecModel();
        Velocity velocity = spectralSpecModel.getSourceVelocity();
        Frequency frequency4 = velocity.dopplerShift(frequency3);
        Frequency frequency5 = (Frequency)this.SIX_GHZ.minus((AbstractDoubleWithUnit)frequency2);
        Frequency frequency6 = (Frequency)frequency4.minus((AbstractDoubleWithUnit)frequency);
        Frequency frequency7 = null;
        frequency7 = abstractBaseBandConfig.getSideBandUse().usesUSB() ? (Frequency)frequency5.plus((AbstractDoubleWithUnit)frequency6) : (Frequency)frequency5.minus((AbstractDoubleWithUnit)frequency6);
        frequency7.convertToMHz();
        return frequency7;
    }

    private SpectralWindowI getSpwFromLine(alma.obsprep.services.experts.spectralline.SpectralLine spectralLine) {
        Frequency frequency = this.calculateBasebandOffsetFrequency(spectralLine);
        if (frequency == null) {
            return null;
        }
        SpectralWindowI spectralWindowI = this.getMyModel().getBaseBandConfig().createNewSpectralWindow();
        spectralWindowI.changeSideBandUse(this.getMyModel().getBaseBandConfig().getSideBandUse());
        spectralWindowI.addSpectralLine(SpectralLine.createFromSplatalogue(spectralLine));
        int n = 8192;
        Frequency frequency2 = Frequency.createFrequencyGHZ(9999.0);
        for (CorrConfigMode corrConfigMode : spectralWindowI.getApplicableModeSet()) {
            if (!corrConfigMode.getNominalBandwidth().isLessThan((AbstractDoubleWithUnit)frequency2)) continue;
            frequency2 = corrConfigMode.getNominalBandwidth().deepCopy().convertToFriendlyUnit();
        }
        spectralWindowI.setBandParameters(frequency2.convertToFriendlyUnit(), n, SpectralWindowBand.ChannelType.NOMINAL);
        spectralWindowI.setCenterFrequency(frequency);
        spectralWindowI.adjustCenterFrequency();
        return spectralWindowI;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        SpectralWindowTabbedModel spectralWindowTabbedModel = this.getMyModel();
        if (fieldID.equals(documentFID)) {
            this.updateButtons();
            this.updateCorrelatorDependingComponent();
        } else {
            if (fieldID.equals(this.addButtonFID)) {
                int n = this.getSelectedIndex();
                spectralWindowTabbedModel.newBO(n + 1);
                this.setSelectedIndex(n + 1);
                this.updateButtons();
                return;
            }
            if (this.addFromCatalogFID.equals(fieldID)) {
                if (object instanceof List) {
                    List list = (List)object;
                    SpectralWindowI spectralWindowI = null;
                    if (list.size() == 1) {
                        alma.obsprep.services.experts.spectralline.SpectralLine spectralLine = (alma.obsprep.services.experts.spectralline.SpectralLine)list.get(0);
                        spectralWindowI = this.getSpwFromLine(spectralLine);
                    }
                    if (spectralWindowI != null) {
                        int n = this.getSelectedIndex();
                        spectralWindowTabbedModel.addSpectralWindowI(n + 1, spectralWindowI);
                        spectralWindowTabbedModel.publish();
                        this.setSelectedIndex(n + 1);
                        this.updateButtons();
                    }
                    return;
                }
            } else {
                if (fieldID.equals(this.copyButtonFID)) {
                    int n = this.getSelectedIndex();
                    spectralWindowTabbedModel.getBaseBandConfig().copyAndAddSpectralWindow(n, n + 1);
                    spectralWindowTabbedModel.publish();
                    this.setSelectedIndex(n + 1);
                    this.updateButtons();
                    return;
                }
                if (fieldID.equals(this.delButtonFID)) {
                    int n = this.getSelectedIndex();
                    spectralWindowTabbedModel.deleteBO(spectralWindowTabbedModel.getBO(n));
                    if (n == 0) {
                        if (spectralWindowTabbedModel.getBOCount() != 0) {
                            this.setSelectedIndex(n);
                        } else {
                            this.setSelectedIndex(-1);
                        }
                    } else if (n == spectralWindowTabbedModel.getBOCount()) {
                        this.setSelectedIndex(n - 1);
                    } else if (n != -1) {
                        this.setSelectedIndex(n);
                    }
                    this.updateButtons();
                    return;
                }
                if (fieldID.equals(this.printButtonFID)) {
                    Log.logger((Object)this).info("\n" + this.getMyModel().getBaseBandConfig().detailString());
                    return;
                }
            }
        }
        if (fieldID.equals(ACASPECIFICMODE_FID)) {
            boolean bl = this.get((JCheckBox)this.getComponent(fieldID));
            this.setAllowAcaSpecifidMode(bl);
            this.setupPairCellEditors(!bl);
            super.update(fieldID, object);
            return;
        }
        super.update(fieldID, object);
    }

    public void doClickAddButton() {
        ((JButton)this.getComponent(this.addButtonFID)).doClick();
    }

    public void doClickCopyButton() {
        ((JButton)this.getComponent(this.copyButtonFID)).doClick();
    }

    public void doClickDeleteButton() {
        ((JButton)this.getComponent(this.delButtonFID)).doClick();
    }

    protected void cancellCellEditingOnSwTable() {
        JTable jTable = this.getTable();
        if (jTable == null) {
            return;
        }
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableCellEditor tableCellEditor;
            TableColumn tableColumn = enumeration.nextElement();
            if (tableColumn == null || (tableCellEditor = tableColumn.getCellEditor()) == null) continue;
            tableCellEditor.cancelCellEditing();
        }
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config/otData");
        InitServices.initModelSupportClasses();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                Logger logger = Logger.getAnonymousLogger();
                logger.log(Level.SEVERE, "Thread terminated with exception: " + thread.getName(), throwable);
            }
        });
        JFrame jFrame = new JFrame("An example of TabbedEditor");
        jFrame.setDefaultCloseOperation(3);
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpecWithBLCorrelatorConfiguration(Optional.empty());
        AbstractBaseBandConfig abstractBaseBandConfig = (AbstractBaseBandConfig)spectralSpec.addNewBaseBand();
        AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
        abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
        abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
        spectralSpec.setLO1Frequency(Frequency.createFrequencyGHZ(105.02));
        abstractBaseBandConfig.setLO2Frequency(Frequency.createFrequencyGHZ(8.98));
        SpectralWindowTabbedModel spectralWindowTabbedModel = new SpectralWindowTabbedModel(null);
        SpectralWindowEditor spectralWindowEditor = new SpectralWindowEditor(spectralWindowTabbedModel.getSubModel());
        SpectralWindowTabbedEditor spectralWindowTabbedEditor = new SpectralWindowTabbedEditor((TabbedEditorModel)spectralWindowTabbedModel, spectralWindowEditor);
        ((Model)spectralWindowTabbedModel).setDocument(abstractBaseBandConfig);
        SpectralSpecModel spectralSpecModel = new SpectralSpecModel(spectralSpec);
        spectralSpecModel.getSourceVelocity().setCenterVelocity(Speed.createSpeed((double)10000.0, (String)Speed.UNIT_KM_S));
        spectralWindowTabbedModel.setParentModel(spectralSpecModel);
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 3));
        jFrame.getContentPane().setPreferredSize(new Dimension(800, 600));
        jFrame.getContentPane().add(spectralWindowTabbedEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

