/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.ReferencePointEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.ReferenceModel;
import alma.obsprep.ot.models.schedblock.ReferencePointModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Time;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ReferenceEditor
extends Editor
implements ChangeListener {
    public static final FieldID FID_TABBEDPANE = new FieldID("ReferenceEditor.tabs");
    protected final FieldID FID_ADD_BUTTON = new FieldID("ReferenceEditor.addBtn");
    protected final FieldID FID_DELETE_BUTTON = new FieldID("ReferenceEditor.delBtn");
    private JTabbedPane tabbedPane;

    public ReferenceEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    protected void build() {
        this.setLayout(new BoxLayout(this, 3));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(0);
        this.tabbedPane.addChangeListener(this);
        this.initEvents(this.tabbedPane, FID_TABBEDPANE);
        this.add(this.tabbedPane);
        this.add(this.createButtonBox());
    }

    private Box createButtonBox() {
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton("Add");
        jButton.setToolTipText("Up to 2 positions may be added.");
        this.initEvents(jButton, this.FID_ADD_BUTTON);
        box.add(jButton);
        jButton = new JButton("Delete");
        jButton.setToolTipText("Delete the selected reference");
        this.initEvents(jButton, this.FID_DELETE_BUTTON);
        box.add(jButton);
        return box;
    }

    private void updateButtons() {
        JButton jButton = (JButton)this.getComponent(this.FID_ADD_BUTTON);
        JButton jButton2 = (JButton)this.getComponent(this.FID_DELETE_BUTTON);
        jButton.setEnabled(true);
        jButton2.setEnabled(true);
        this.tabbedPane.setVisible(true);
        ReferenceModel referenceModel = (ReferenceModel)this.getModel();
        if (referenceModel.getReferenceCount() == 0) {
            jButton2.setEnabled(false);
            this.tabbedPane.setVisible(false);
        } else if (referenceModel.getReferenceCount() == 2) {
            jButton.setEnabled(false);
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        ReferenceModel referenceModel = (ReferenceModel)this.getModel();
        if (fieldID == FID_TABBEDPANE) {
            if (object instanceof FieldSource) {
                FieldSource fieldSource = (FieldSource)object;
                this.resetTabEditor(fieldSource);
                this.updateButtons();
                this.setTabTitles();
            }
            return;
        }
        if (fieldID == this.FID_ADD_BUTTON) {
            FieldSource fieldSource = referenceModel.getFieldSource();
            Reference reference = Reference.createReference();
            fieldSource.addReference(reference);
            Component component = this.tabbedPane.add("Reference", this.getNewReferencePointEditor(reference));
            this.tabbedPane.setSelectedComponent(component);
            this.updateButtons();
            this.setTabTitles();
            return;
        }
        if (fieldID == this.FID_DELETE_BUTTON) {
            if (this.tabbedPane.getTabCount() == 1 && !GUIUtilities.confirm(null, "Are you sure you want to delete the last reference position?")) {
                return;
            }
            FieldSource fieldSource = referenceModel.getFieldSource();
            Reference reference = (Reference)((Editor)this.tabbedPane.getSelectedComponent()).getModel().getDocument();
            fieldSource.removeReference(reference);
            this.tabbedPane.remove(this.tabbedPane.getSelectedIndex());
            this.updateButtons();
            this.setTabTitles();
            return;
        }
        super.update(fieldID, object);
    }

    private ReferencePointEditor getNewReferencePointEditor(Reference reference) {
        return new ReferencePointEditor(new ReferencePointModel(reference));
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.setTabTitles();
    }

    private void setTabTitles() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Editor editor = (Editor)this.tabbedPane.getComponent(i);
            if (editor == null) continue;
            this.tabbedPane.setTitleAt(i, "Reference" + i);
        }
    }

    public void resetTabEditor(FieldSource fieldSource) {
        this.tabbedPane.removeAll();
        for (int i = 0; i < fieldSource.getReferenceCount(); ++i) {
            this.tabbedPane.add(this.getNewReferencePointEditor(fieldSource.getReference(i)));
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Reference Editor");
        jFrame.setDefaultCloseOperation(3);
        FieldSource fieldSource = FieldSource.createFieldSource();
        Reference reference = Reference.createReference();
        reference.getReferenceCoordinates().getLatitude().setContent(10.0);
        reference.getReferenceCoordinates().getLongitude().setContent(20.0);
        reference.getIntegrationTime().setContent(30.0);
        reference.getCycleTime().setContent(40.0);
        Reference reference2 = Reference.createReference();
        reference2.getReferenceCoordinates().getLatitude().setContent(50.0);
        reference2.getReferenceCoordinates().getLongitude().setContent(60.0);
        reference2.getIntegrationTime().setContent(70.0);
        reference2.getIntegrationTime().setUnit(Time.UNIT_MIN);
        reference2.getCycleTime().setContent(80.0);
        reference2.getCycleTime().setUnit(Time.UNIT_H);
        fieldSource.addReference(reference);
        fieldSource.addReference(reference2);
        ReferenceModel referenceModel = new ReferenceModel(fieldSource);
        ReferenceEditor referenceEditor = new ReferenceEditor(referenceModel);
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 3));
        jFrame.getContentPane().setPreferredSize(new Dimension(600, 400));
        jFrame.getContentPane().add(referenceEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

