/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.annotations.PointingPatternI;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.guiutil.mvc.widgets.OTComboBox;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.misc.OTTextCellEditor;
import alma.obsprep.ot.editors.schedblock.PointingImpexFactory;
import alma.obsprep.ot.editors.schedblock.PointingPatternCoordsTypeEnum;
import alma.obsprep.ot.editors.sciencegoals.AbstractTargetEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.ot.models.schedblock.PointingPatternTableModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.UserAngle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import lombok.NonNull;

public class PointingPatternEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    public static final FieldID POINTING_PATTERN_TABLE_FID = new FieldID("PointingPatternTable");
    public static final FieldID OFFSET_COORD_TYPE_SELECTOR = new FieldID("CoordTypeSelector");
    public static final FieldID CUSTOM_MOSAIC_CHECKBOX_FID = new FieldID("CustomMosaicCheckBox");
    public static final FieldID OFFSET_UNIT_COMBO_FID = new FieldID("OffsetUnit");
    public static final FieldID NPOINTINGS12M_FID = new FieldID("PointingPatternEditor.12mNpointings");
    public static final FieldID NPOINTINGS7M_FID = new FieldID("PointingPatternEditor.7mNpointings");
    private static final FieldID IMPORTPOINTINGS_FID = new FieldID("PointingPatternEditor.importPointings");
    private static final FieldID EXPORTPOINTINGS_FID = new FieldID("PointingPatternEditor.exportPointings");
    public static final FieldID ACA_SCHEDULED = new FieldID("PointingPatternEditor.acaScheduled");
    public static final FieldID SACA_SCHEDULED = new FieldID("PointingPatternEditor.sacaScheduled");
    public static final FieldID POINTING_TYPE_SELECTION = new FieldID("PointingPatternEditor.pointingTypeSelection");
    public static final FieldID IS_PHASE_2 = new FieldID("PointingPatternEditor.pointingTypeSelection");
    private final FieldID addPPFID = new FieldID("PointingPatternEditor.addBtn");
    private final FieldID delPPFID = new FieldID("PointingPatternEditor.delBtn");
    private JButton importButton = null;
    private JButton exportButton = null;
    private JButton addPointingButton = null;
    private JButton pointingDeleteButton = null;
    private JTable pointingPatternTable = null;
    private ComponentCollection customMosaicChkComp = null;
    private ComponentCollection offsetTypeButtons = null;
    private JScrollPane pointingsScroller;
    private JButton resetButton;
    private boolean isSACA = false;
    private boolean isACAScheduled = false;
    private String pointingsArrayDisplayed = Antenna.ANTENNA_12M.getLabel();
    private final PointingImpexFactory.PointingImpexInterface pointingImportExporter;
    private JLabel noPointings7mLabel;
    private JLabel noPointings12mLabel;

    public PointingPatternEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
        this.pointingImportExporter = PointingImpexFactory.getPointingImpex(PointingImpexFactory.PointingPatternSource.Pointing, model);
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        PointingPatternModel pointingPatternModel = (PointingPatternModel)this.getModel();
        this.addPointingButton = new JButton("Add");
        this.addPointingButton.setToolTipText("Add a Pointing");
        this.initEvents(this.addPointingButton, this.addPPFID);
        this.pointingDeleteButton = new JButton("Delete");
        this.pointingDeleteButton.setToolTipText("Delete a Pointing");
        this.initEvents(this.pointingDeleteButton, this.delPPFID);
        this.resetButton = new JButton("Reset");
        this.resetButton.setToolTipText("Reset pointing pattern");
        this.resetButton.addActionListener(actionEvent -> this.resetPointingPattern());
        this.importButton = new JButton("Import");
        this.importButton.setToolTipText("Import pointings from a file");
        this.initEvents(this.importButton, IMPORTPOINTINGS_FID);
        this.importButton.addActionListener(actionEvent -> this.pointingImportExporter.importPointingsFromFile(this));
        this.exportButton = new JButton("Export");
        this.exportButton.setToolTipText("Export current pointings to a file");
        this.initEvents(this.exportButton, EXPORTPOINTINGS_FID);
        this.exportButton.addActionListener(actionEvent -> this.pointingImportExporter.exportPointingsToFile(this));
        this.pointingPatternTable = new Table(pointingPatternModel.getPointingPatternTableModel()){
            private static final long serialVersionUID = 5882214124972330395L;

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int[] nArray = this.getSelectedRows();
                super.tableChanged(tableModelEvent);
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] >= this.getRowCount() || nArray[i] < 0) continue;
                    if (i == 0) {
                        this.setRowSelectionInterval(nArray[i], nArray[i]);
                        continue;
                    }
                    this.addRowSelectionInterval(nArray[i], nArray[i]);
                }
            }
        };
        int n = this.pointingDeleteButton.getPreferredSize().height;
        Dimension dimension = new Dimension(this.pointingPatternTable.getPreferredSize());
        dimension.height = n * 3;
        dimension.width *= 4;
        this.pointingPatternTable.setPreferredScrollableViewportSize(dimension);
        this.pointingPatternTable.getTableHeader().setReorderingAllowed(false);
        this.pointingPatternTable.setSelectionMode(2);
        this.pointingPatternTable.setColumnSelectionAllowed(false);
        this.pointingPatternTable.getSelectionModel().addListSelectionListener(this);
        this.pointingsScroller = new ScrollWhenFocusedPane(this.pointingPatternTable);
        this.pointingPatternTable.setToolTipText("Coordinates/offsets of each pointing");
        this.pointingPatternTable.setDefaultEditor(String.class, new OTTextCellEditor());
        this.pointingPatternTable.setSelectionForeground(Color.BLACK);
        this.initEvents(this.pointingPatternTable, POINTING_PATTERN_TABLE_FID);
        this.addPointingButton.setPreferredSize(this.pointingDeleteButton.getPreferredSize());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.addPointingButton);
        jPanel2.add(this.pointingDeleteButton);
        jPanel2.add(this.resetButton);
        jPanel2.add(this.importButton);
        jPanel2.add(this.exportButton);
        this.customMosaicChkComp = new ComponentCollection();
        this.customMosaicChkComp.remember(this.makeCheckBox(CUSTOM_MOSAIC_CHECKBOX_FID, null, pointingPatternModel.isMosaic(), "<html>Switch between treating the pattern as a single shape to be mosaiced for 12m and 7m arrays.<br/>and treating it as one or more individual antenna pointings</html>"));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, this.customMosaicChkComp);
        this.getComponent(CUSTOM_MOSAIC_CHECKBOX_FID).setVisible(false);
        this.offsetTypeButtons = new ComponentCollection();
        this.offsetTypeButtons.remember(this.makeLabel("Coord Type"));
        OTButtonGroup oTButtonGroup = this.makeOTButtonGroup(OFFSET_COORD_TYPE_SELECTOR, PointingPatternCoordsTypeEnum.values(), new String[]{"Relative coordinate type", "Absolute coordinate type"});
        this.set(oTButtonGroup, PointingPatternCoordsTypeEnum.Relative.getUILabel());
        this.offsetTypeButtons.remember(oTButtonGroup);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, this.offsetTypeButtons);
        OTButtonGroup oTButtonGroup2 = this.addOTButtonGroup((JComponent)jPanel, gridBagLayout, gridBagConstraints, POINTING_TYPE_SELECTION, "Array Type", "Display pointings for the selected array type", Antenna.getLabels());
        this.set(oTButtonGroup2, Antenna.ANTENNA_12M.getLabel());
        OTComboBox oTComboBox = this.addOTComboBox(jPanel, gridBagLayout, gridBagConstraints, OFFSET_UNIT_COMBO_FID, "Offset Unit", "Unit of offset pointings", UserAngle.getOrderedKnownModelUnits());
        this.set2(oTComboBox, (Object)PointingPatternI.DEFAULT_OFFSETANGLE_UNIT);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        Box box = Box.createHorizontalBox();
        this.noPointings12mLabel = this.makeLabel("12m Array ");
        box.add(this.noPointings12mLabel);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.makeTextField(NPOINTINGS12M_FID, 5, false, "Number of 12-m pointings in this field"));
        box.add(Box.createHorizontalStrut(20));
        this.noPointings7mLabel = this.makeLabel("7m Array ");
        box.add(this.noPointings7mLabel);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.makeTextField(NPOINTINGS7M_FID, 5, false, "Number of 7-m pointings in this field"));
        gridBagConstraints.fill = 10;
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "#Pointings", (JComponent)box);
        gridBagConstraints.fill = 2;
        box.add(Box.createHorizontalStrut(20));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.pointingsScroller);
        this.constraints.weightx = 1.0;
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
        this.addComponent(this, this.layout, this.constraints, jPanel);
    }

    private void resetPointingPattern() {
        Model model;
        if (GUIUtilities.confirm(null, "Are you sure you want to reset the pointing pattern?") && (model = this.getModel()) != null) {
            PointingPatternModel pointingPatternModel = (PointingPatternModel)model;
            pointingPatternModel.performCoordinateResetOfAllPointings();
        }
    }

    @Override
    public void build() {
        super.build("PointingPatternEditor");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        PointingPatternModel pointingPatternModel = (PointingPatternModel)this.getModel();
        if (fieldID.equals(this.addPPFID)) {
            int n = this.pointingPatternTable.getSelectedRow();
            OTButtonGroup oTButtonGroup = (OTButtonGroup)this.getComponent(OFFSET_COORD_TYPE_SELECTOR);
            boolean bl = Boolean.valueOf(PointingPatternCoordsTypeEnum.valueOf(oTButtonGroup.getSelectedItem()).getBOMapping());
            pointingPatternModel.addPointing(n + 1, bl);
            this.pointingPatternTable.setRowSelectionInterval(n + 1, n + 1);
            this.setButtons(pointingPatternModel);
        } else if (fieldID.equals(this.delPPFID)) {
            int[] nArray = this.pointingPatternTable.getSelectedRows();
            if (nArray.length == pointingPatternModel.getPointingCount()) {
                GUIUtilities.info(null, "Deleting all of the pointings is not permitted.");
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                pointingPatternModel.deletePointing(nArray[i] - i);
            }
            if (pointingPatternModel.getPointingCount() == 0) {
                this.pointingPatternTable.clearSelection();
            } else {
                this.pointingPatternTable.setRowSelectionInterval(0, 0);
            }
            this.setButtons(pointingPatternModel);
        } else if (fieldID.equals(POINTING_PATTERN_TABLE_FID)) {
            ((PointingPatternTableModel)this.pointingPatternTable.getModel()).fireTableDataChanged();
            OTComboBox oTComboBox = (OTComboBox)this.getComponent(OFFSET_UNIT_COMBO_FID);
            if (oTComboBox != null) {
                String string = ((PointingPatternModel)this.getModel()).getDisplayedOffsetUnit();
                this.set2(oTComboBox, (Object)string);
            }
        } else if (fieldID.equals(NPOINTINGS12M_FID) || fieldID.equals(NPOINTINGS7M_FID)) {
            super.update(fieldID, object);
            int n = (Integer)object;
            if (n == 0) {
                return;
            }
            JCheckBox jCheckBox = (JCheckBox)this.getComponent(CUSTOM_MOSAIC_CHECKBOX_FID);
            boolean bl = n > 1;
            this.setCollectionComponentEnabled(this.customMosaicChkComp, bl);
            jCheckBox.setSelected(bl);
            ((PointingPatternModel)this.getModel()).setIsMosaic(bl);
        } else if (fieldID.equals(OFFSET_COORD_TYPE_SELECTOR)) {
            super.update(fieldID, object);
            boolean bl = object instanceof String ? Boolean.valueOf((String)object).booleanValue() : ((Boolean)object).booleanValue();
            OTComboBox oTComboBox = (OTComboBox)this.getComponent(OFFSET_UNIT_COMBO_FID);
            if (oTComboBox != null) {
                oTComboBox.setEnabled(bl);
                if (bl) {
                    String string = (String)oTComboBox.getSelectedItem();
                    ((PointingPatternModel)this.getModel()).setOffsetUnit(string);
                    ((PointingPatternTableModel)this.pointingPatternTable.getModel()).fireTableStructureChanged();
                }
            }
        } else if (fieldID.equals(AbstractTargetEditor.FID_NONSIDEREALMOTION)) {
            boolean bl = (Boolean)object;
            OTButtonGroup oTButtonGroup = (OTButtonGroup)this.getComponent(OFFSET_COORD_TYPE_SELECTOR);
            if (bl) {
                oTButtonGroup.setSelectedItem(PointingPatternCoordsTypeEnum.Relative.name());
                oTButtonGroup.setEnabled(false);
            } else {
                oTButtonGroup.setEnabled(true);
            }
        } else if (fieldID.equals(ACA_SCHEDULED)) {
            this.isACAScheduled = (Boolean)object;
            this.configurePointingTypeSelectionComponents();
        } else if (fieldID.equals(SACA_SCHEDULED)) {
            this.isSACA = (Boolean)object;
            this.configurePointingTypeSelectionComponents();
        } else if (fieldID.equals(POINTING_TYPE_SELECTION)) {
            this.pointingsArrayDisplayed = (String)object;
            this.configureReadOnlyStateOfPointingEditorComponents(this.pointingsArrayDisplayed);
            OTButtonGroup oTButtonGroup = (OTButtonGroup)this.getComponent(POINTING_TYPE_SELECTION);
            oTButtonGroup.getButtonStream().filter(abstractButton -> abstractButton.getText().equals(object)).forEach(abstractButton -> abstractButton.setSelected(true));
        } else if (fieldID.equals(IS_PHASE_2)) {
            boolean bl = (Boolean)object;
            this.getComponent(POINTING_TYPE_SELECTION).setEnabled(!bl);
        } else {
            super.update(fieldID, object);
        }
    }

    private void configurePointingTypeSelectionComponents() {
        OTButtonGroup oTButtonGroup = (OTButtonGroup)this.getComponent(POINTING_TYPE_SELECTION);
        List<AbstractButton> list = oTButtonGroup.getButtonGroupList();
        JComponent jComponent = this.getComponent(NPOINTINGS12M_FID);
        JComponent jComponent2 = this.getComponent(NPOINTINGS7M_FID);
        if (this.isSACA) {
            oTButtonGroup.setSelectedItem(Antenna.ANTENNA_7M.getLabel());
            list.get(0).setVisible(false);
            list.get(1).setVisible(true);
            jComponent.setVisible(false);
            jComponent2.setVisible(true);
            this.noPointings7mLabel.setVisible(true);
            this.noPointings12mLabel.setVisible(false);
        } else {
            if (!this.isACAScheduled) {
                oTButtonGroup.setSelectedItem(Antenna.ANTENNA_12M.getLabel());
            }
            list.get(0).setVisible(true);
            list.get(1).setVisible(this.isACAScheduled);
            jComponent2.setVisible(this.isACAScheduled);
            jComponent.setVisible(true);
            this.noPointings7mLabel.setVisible(this.isACAScheduled);
            this.noPointings12mLabel.setVisible(true);
        }
    }

    private void configureReadOnlyStateOfPointingEditorComponents(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("antenna is marked non-null but is null");
        }
        boolean bl = string.equals(Antenna.ANTENNA_7M.getLabel()) && !this.isSACA;
        List.of(this.pointingPatternTable, this.importButton, this.resetButton, this.pointingDeleteButton, this.addPointingButton).stream().forEach(jComponent -> jComponent.setEnabled(!bl));
    }

    private void setButtons(PointingPatternModel pointingPatternModel) {
        int n = pointingPatternModel.getPointingCount();
        this.setEnabled(this.addPointingButton, this.pointingPatternTable.getSelectedRowCount() < 2);
        this.setEnabled(this.pointingDeleteButton, n > 0 && this.pointingPatternTable.getSelectedRow() != -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons((PointingPatternModel)this.getModel());
    }

    @Override
    public List<JComponent> getUserRestrictedEditableComponents() {
        return Arrays.asList(this.pointingsScroller, this.pointingPatternTable);
    }

    private void setCollectionComponentEnabled(ComponentCollection componentCollection, boolean bl) {
        for (Component component : componentCollection.getComponents()) {
            component.setEnabled(bl);
        }
    }

    public JTable getPointingPatternTable() {
        return this.pointingPatternTable;
    }

    public static enum OffsetCoordsFormat {
        ARCSECS,
        ARCMINS,
        DEGREES;

    }

    public static enum AbsoluteCoordsFormat {
        SEXAGESIMAL,
        DEGREES,
        RADIANS;

    }

    public static enum PointingStorageFormat {
        ABSOLUTECOORDS("Absolute"),
        OFFSETCOORDS("Offset");

        private final String label;

        public static PointingStorageFormat getExportFormat(@NonNull String string) {
            if (string == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            for (PointingStorageFormat pointingStorageFormat : PointingStorageFormat.values()) {
                if (!string.trim().equalsIgnoreCase(pointingStorageFormat.getLabel())) continue;
                return pointingStorageFormat;
            }
            return null;
        }

        private PointingStorageFormat(String string2) {
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

